/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.connectors.internal.api;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.loader.EJBClassLoader;
import com.sun.logging.LogDomains;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.ConnectorClassFinder;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class ConnectorsClassLoaderUtil {
    @Inject
    private ClassLoaderHierarchy clh;
    private static List<ConnectorClassFinder> systemRARClassLoaders;
    private Logger _logger = LogDomains.getLogger(ConnectorRuntime.class, (String)"javax.enterprise.resource.resourceadapter");
    @Inject
    private ServerEnvironment env;

    public ConnectorClassFinder createRARClassLoader(String moduleDir, ClassLoader deploymentParent, String moduleName, List<URI> appLibs) throws ConnectorRuntimeException {
        ClassLoader parent = null;
        parent = deploymentParent == null ? this.clh.getConnectorClassLoader(null).getParent() : deploymentParent;
        return this.createRARClassLoader(parent, moduleDir, moduleName, appLibs);
    }

    private DelegatingClassLoader.ClassFinder getLibrariesClassLoader(final List<URI> appLibs) throws MalformedURLException, ConnectorRuntimeException {
        try {
            return (DelegatingClassLoader.ClassFinder)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ConnectorsClassLoaderUtil.this.clh.getAppLibClassFinder(appLibs);
                }
            });
        }
        catch (PrivilegedActionException e) {
            this._logger.log(Level.SEVERE, "failed to create libraries classloader", e);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
            cre.initCause(e);
            throw cre;
        }
    }

    private ConnectorClassFinder createRARClassLoader(final ClassLoader parent, String moduleDir, final String moduleName, List<URI> appLibs) throws ConnectorRuntimeException {
        ConnectorClassFinder cl = null;
        try {
            final DelegatingClassLoader.ClassFinder librariesCL = this.getLibrariesClassLoader(appLibs);
            cl = (ConnectorClassFinder)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new ConnectorClassFinder(parent, moduleName, librariesCL);
                }
            });
        }
        catch (Exception ex) {
            this._logger.log(Level.SEVERE, "failed to create connector classloader", ex);
            ConnectorRuntimeException cre = new ConnectorRuntimeException(ex.getMessage());
            cre.initCause(ex);
            throw cre;
        }
        File file = new File(moduleDir);
        try {
            cl.appendURL(file.toURI().toURL());
            this.appendJars(file, (EJBClassLoader)cl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return cl;
    }

    public Collection<ConnectorClassFinder> getSystemRARClassLoaders() throws ConnectorRuntimeException {
        ArrayList<ConnectorClassFinder> classLoaders = new ArrayList<ConnectorClassFinder>();
        for (String rarName : ConnectorConstants.systemRarNames) {
            String location = ConnectorsUtil.getSystemModuleLocation(rarName);
            ArrayList<URI> libraries = new ArrayList<URI>();
            ConnectorClassFinder ccf = this.createRARClassLoader(location, null, rarName, libraries);
            classLoaders.add(ccf);
        }
        return classLoaders;
    }

    public ConnectorClassFinder getSystemRARClassLoader(String rarName) throws ConnectorRuntimeException {
        Collection<ConnectorClassFinder> systemRarCLs = this.getSystemRARClassLoaders();
        for (ConnectorClassFinder ccf : systemRarCLs) {
            if (!ccf.getResourceAdapterName().equals(rarName)) continue;
            return ccf;
        }
        throw new ConnectorRuntimeException("No Classloader found for RA [ " + rarName + " ]");
    }

    private void appendJars(File moduleDir, EJBClassLoader cl) throws MalformedURLException {
        if (moduleDir.isDirectory()) {
            for (File file : moduleDir.listFiles()) {
                if (file.getName().toUpperCase().endsWith(".JAR")) {
                    cl.appendURL(file.toURI().toURL());
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.appendJars(file, cl);
            }
        }
    }
}

