/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package org.glassfish.api.jdbc.validation;

import com.sun.logging.LogDomains;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.jdbc.ConnectionValidation;

/**
 * Default connection validation mechanism used by common database vendors to
 * perform connection validation.
 * 
 * @author Shalini M
 */
public class DefaultConnectionValidation implements ConnectionValidation {
    private String SQL = "SELECT '1'";

    /**
     * Check for validity of <code>java.sql.Connection</code>
     *
     * @param con       <code>java.sql.Connection</code>to be validated
     * @throws SQLException if the connection is not valid
     */
    public boolean isConnectionValid(Connection con) {
        boolean isValid = false;
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            isValid = stmt.execute(SQL);
        } catch (SQLException sqle) {
            isValid = false;
            Logger.getLogger(LogDomains.RSR_LOGGER).log(Level.FINEST,
                    "connection_validation_exception", sqle);
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (Exception ex) {
                }
            }
        }
        return isValid;
    }
}
