/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.connectors.ActiveOutboundResourceAdapter;
import com.sun.enterprise.connectors.BootstrapContextImpl;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ConnectorDDTransformUtils;
import com.sun.enterprise.connectors.util.SetMethodAction;
import com.sun.enterprise.deployment.AdminObject;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.resource.beans.AdministeredObjectResource;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.ResourceAdapterInternalException;
import org.glassfish.api.admin.config.Property;
import org.glassfish.api.naming.GlassfishNamingManager;

public class ActiveInboundResourceAdapter
extends ActiveOutboundResourceAdapter {
    protected ResourceAdapter resourceadapter_;
    protected String moduleName_;
    private static Logger _logger = LogDomains.getLogger(ActiveInboundResourceAdapter.class, (String)"javax.enterprise.resource.resourceadapter");
    private StringManager localStrings = StringManager.getManager(ActiveInboundResourceAdapter.class);
    private BootstrapContext bootStrapContextImpl;

    public ActiveInboundResourceAdapter(ResourceAdapter ra, ConnectorDescriptor desc, String moduleName, ClassLoader jcl) throws ConnectorRuntimeException {
        super(desc, moduleName, jcl);
        this.resourceadapter_ = ra;
        this.moduleName_ = moduleName;
        try {
            this.loadRAConfiguration();
            ConnectorRegistry registry = ConnectorRegistry.getInstance();
            String poolId = null;
            ResourceAdapterConfig raConfig = registry.getResourceAdapterConfig(this.moduleName_);
            if (raConfig != null) {
                poolId = raConfig.getThreadPoolIds();
            }
            this.bootStrapContextImpl = new BootstrapContextImpl(poolId, this.moduleName_);
            this.resourceadapter_.start(this.bootStrapContextImpl);
        }
        catch (ResourceAdapterInternalException ex) {
            _logger.log(Level.SEVERE, "rardeployment.start_failed", ex);
            String i18nMsg = this.localStrings.getString("rardeployment.start_failed", (Object)ex.getMessage());
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause((Throwable)ex);
            throw cre;
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "rardeployment.start_failed", t);
            t.printStackTrace();
            String i18nMsg = this.localStrings.getString("rardeployment.start_failed", (Object)t.getMessage());
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            if (t.getCause() != null) {
                cre.initCause(t.getCause());
            } else {
                cre.initCause(t);
            }
            throw cre;
        }
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceadapter_;
    }

    public void setup() throws ConnectorRuntimeException {
        if (this.connectionDefs_ == null || this.connectionDefs_.length == 0) {
            return;
        }
        super.setup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.connectionDefs_ != null && this.connectionDefs_.length != 0) {
            super.destroy();
        }
        try {
            _logger.fine("Calling Resource Adapter stop" + this.getModuleName());
            this.resourceadapter_.stop();
            _logger.fine("Resource Adapter stop call of " + this.getModuleName() + "returned successfully");
            _logger.log(Level.FINE, "rar_stop_call_successful");
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "rardeployment.stop_warning", t);
        }
        finally {
            this.removeProxiesFromRegistry(this.moduleName_);
        }
    }

    private void removeProxiesFromRegistry(String moduleName_) {
        ConnectorRuntime.getRuntime().removeWorkManagerProxy(moduleName_);
    }

    public ManagedConnectionFactory createManagedConnectionFactory(ConnectorConnectionPool pool, ClassLoader jcl) {
        ManagedConnectionFactory mcf = super.createManagedConnectionFactory(pool, jcl);
        if (mcf instanceof ResourceAdapterAssociation) {
            try {
                ((ResourceAdapterAssociation)mcf).setResourceAdapter(this.resourceadapter_);
            }
            catch (ResourceException ex) {
                _logger.log(Level.SEVERE, "rardeployment.assoc_failed", ex);
            }
        }
        return mcf;
    }

    protected void loadRAConfiguration() throws ConnectorRuntimeException {
        try {
            ConnectorRegistry registry = ConnectorRegistry.getInstance();
            ResourceAdapterConfig raConfig = registry.getResourceAdapterConfig(this.moduleName_);
            List<Object> raConfigProps = new ArrayList<Property>();
            if (raConfig != null) {
                raConfigProps = raConfig.getProperty();
            }
            Set mergedProps = ConnectorDDTransformUtils.mergeProps(raConfigProps, this.getDescriptor().getConfigProperties());
            SetMethodAction setMethodAction = new SetMethodAction(this.resourceadapter_, mergedProps);
            setMethodAction.run();
        }
        catch (Exception e) {
            String i18nMsg = this.localStrings.getString("ccp_adm.wrong_params_for_create", (Object)e.getMessage());
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause((Throwable)e);
            throw cre;
        }
    }

    public BootstrapContext getBootStrapContext() {
        return this.bootStrapContextImpl;
    }

    public void addAdminObject(String appName, String connectorName, String jndiName, String adminObjectType, Properties props) throws ConnectorRuntimeException {
        if (props == null) {
            props = new Properties();
        }
        ConnectorRegistry registry = null;
        try {
            registry = ConnectorRegistry.getInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        ConnectorDescriptor desc = registry.getDescriptor(connectorName);
        AdminObject aoDesc = desc.getAdminObjectByType(adminObjectType);
        AdministeredObjectResource aor = new AdministeredObjectResource(jndiName);
        aor.initialize(aoDesc);
        aor.setResourceAdapter(connectorName);
        Object[] envProps = aoDesc.getConfigProperties().toArray();
        for (int i = 0; i < envProps.length; ++i) {
            EnvironmentProperty environmentProperty = (EnvironmentProperty)envProps[i];
            String name = environmentProperty.getName();
            String userValue = (String)props.remove(name);
            if (userValue != null) {
                aor.addConfigProperty(new EnvironmentProperty(name, userValue, userValue, environmentProperty.getType()));
                continue;
            }
            aor.addConfigProperty(environmentProperty);
        }
        for (String string : props.keySet()) {
            String userValue = props.getProperty(string);
            if (userValue == null) continue;
            aor.addConfigProperty(new EnvironmentProperty(string, userValue, userValue));
        }
        try {
            Reference reference = aor.createAdminObjectReference();
            GlassfishNamingManager nm = ConnectorRuntime.getRuntime().getNamingManager();
            nm.publishObject(jndiName, (Object)reference, true);
        }
        catch (NamingException namingException) {
            String i18nMsg = this.localStrings.getString("aira.cannot_bind_admin_obj");
            throw new ConnectorRuntimeException(i18nMsg);
        }
    }
}

