/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.module;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.javaee.services.ResourceManager;

public class ConnectorApplication
implements ApplicationContainer {
    private static Logger _logger = LogDomains.getLogger(ConnectorApplication.class, (String)"javax.enterprise.resource.resourceadapter");
    private String moduleName = "";
    private ResourceManager resourceManager;
    private ClassLoader loader;

    public ConnectorApplication(String moduleName, ResourceManager resourceManager, ClassLoader loader) {
        this.moduleName = moduleName;
        this.resourceManager = resourceManager;
        this.loader = loader;
    }

    public Object getDescriptor() {
        return null;
    }

    public boolean start(ApplicationContext startupContext) {
        boolean started = false;
        this.deployResources(this.moduleName);
        started = true;
        this.logFine("Resource Adapter [ " + this.moduleName + " ] started");
        return started;
    }

    private void deployResources(String resourceAdapterName) {
        this.deployResourcesForModule(resourceAdapterName, this.resourceManager.getAllResources());
    }

    private void deployResourcesForModule(String moduleName, Resources allResources) {
        Collection connectionPools = ConnectorsUtil.getAllPoolsOfModule((String)moduleName, (Resources)allResources);
        Collection poolNames = ConnectorsUtil.getAllPoolNames((Collection)connectionPools);
        Collection connectorResources = ConnectorsUtil.getAllResources((Collection)poolNames, (Resources)allResources);
        this.resourceManager.deployResources(connectorResources);
    }

    private void undeployResources(String resourceAdapterName) {
        this.undeployResources(resourceAdapterName, this.resourceManager.getAllResources());
    }

    private void undeployResources(String resourceAdapterName, Resources allResources) {
        Collection connectionPools = ConnectorsUtil.getAllPoolsOfModule((String)resourceAdapterName, (Resources)allResources);
        Collection poolNames = ConnectorsUtil.getAllPoolNames((Collection)connectionPools);
        Collection connectorResources = ConnectorsUtil.getAllResources((Collection)poolNames, (Resources)allResources);
        ArrayList resources = new ArrayList();
        resources.addAll(connectorResources);
        resources.addAll(connectionPools);
        this.resourceManager.undeployResources(resources);
    }

    public boolean stop(ApplicationContext stopContext) {
        boolean stopped = false;
        this.undeployResources(this.moduleName);
        stopped = true;
        this.logFine("Resource Adapter [ " + this.moduleName + " ] stopped");
        return stopped;
    }

    public boolean suspend() {
        return false;
    }

    public boolean resume() {
        return false;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public void logFine(String message) {
        _logger.log(Level.FINE, message);
    }
}

