/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.resizer;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceState;
import com.sun.enterprise.resource.pool.PoolProperties;
import com.sun.enterprise.resource.pool.ResourceHandler;
import com.sun.enterprise.resource.pool.datastructure.DataStructure;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;

public class Resizer
extends TimerTask {
    private String poolName;
    private DataStructure ds;
    private PoolProperties pool;
    private ResourceHandler handler;
    private static final Logger _logger = LogDomains.getLogger(Resizer.class, (String)"javax.enterprise.resource.resourceadapter");

    public Resizer(String poolName, DataStructure ds, PoolProperties pp, ResourceHandler handler) {
        this.poolName = poolName;
        this.ds = ds;
        this.pool = pp;
        this.handler = handler;
    }

    public void run() {
        Resizer.debug("Resizer for pool " + this.poolName);
        this.resizePool(true);
    }

    public void resizePool(boolean forced) {
        if (this.pool.getWaitQueueLength() > 0) {
            return;
        }
        int noOfResourcesRemoved = this.removeIdleAndInvalidResources();
        int poolScaleDownQuantity = this.pool.getResizeQuantity() - noOfResourcesRemoved;
        this.scaleDownPool(poolScaleDownQuantity, forced);
        this.ensureSteadyPool();
        Resizer.debug("No. of resources held for pool [ " + this.poolName + " ] : " + this.ds.getResourcesSize());
    }

    private void ensureSteadyPool() {
        if (this.ds.getResourcesSize() < this.pool.getSteadyPoolSize()) {
            for (int i = this.ds.getResourcesSize(); i < this.pool.getSteadyPoolSize(); ++i) {
                try {
                    this.handler.createResourceAndAddToPool();
                    continue;
                }
                catch (PoolingException ex) {
                    Object[] params = new Object[]{this.poolName, ex.getMessage()};
                    _logger.log(Level.WARNING, "resource_pool.resize_pool_error", params);
                }
            }
        }
    }

    private void scaleDownPool(int scaleDownQuantity, boolean forced) {
        if (this.pool.getResizeQuantity() > 0 && forced) {
            ResourceHandle h;
            int n = scaleDownQuantity = scaleDownQuantity <= this.ds.getResourcesSize() - this.pool.getSteadyPoolSize() ? scaleDownQuantity : 0;
            while (scaleDownQuantity > 0 && (h = this.ds.getResource()) != null) {
                this.ds.removeResource(h);
                --scaleDownQuantity;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeIdleAndInvalidResources() {
        int poolSizeBeforeRemoval = this.ds.getResourcesSize();
        int size = this.ds.getFreeListSize();
        long currentTime = System.currentTimeMillis();
        HashSet<ResourceHandle> activeResources = new HashSet<ResourceHandle>();
        try {
            ResourceHandle h;
            while ((h = this.ds.getResource()) != null) {
                ResourceState state = h.getResourceState();
                if (currentTime - state.getTimestamp() > this.pool.getIdleTimeout()) {
                    this.ds.removeResource(h);
                    continue;
                }
                activeResources.add(h);
            }
        }
        finally {
            for (ResourceHandle activeResource : activeResources) {
                this.ds.returnResource(activeResource);
            }
        }
        this.removeInvalidResources(activeResources);
        Resizer.debug("Number of Idle resources freed for pool [ " + this.poolName + " ] - " + (size - activeResources.size()));
        Resizer.debug("Number of Invalid resources removed for pool [ " + this.poolName + " ] - " + (activeResources.size() - this.ds.getFreeListSize()));
        int noOfResourcesRemoved = poolSizeBeforeRemoval - this.ds.getResourcesSize();
        return noOfResourcesRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInvalidResources(Set freeConnections) {
        block12: {
            try {
                Resizer.debug("Sending a set of free connections to RA, of size : " + freeConnections.size());
                Set invalidConnections = this.handler.getInvalidConnections(freeConnections);
                if (invalidConnections != null) {
                    Resizer.debug("No. of invalid connections received from RA : " + invalidConnections.size());
                    for (Object invalidConnection : invalidConnections) {
                        ManagedConnection invalidManagedConnection = (ManagedConnection)invalidConnection;
                        ArrayList<ResourceHandle> activeResources = new ArrayList<ResourceHandle>();
                        try {
                            ResourceHandle handle;
                            while ((handle = this.ds.getResource()) != null) {
                                if (invalidManagedConnection.equals(handle.getResource())) {
                                    this.ds.removeResource(handle);
                                    this.handler.invalidConnectionDetected(handle);
                                    continue;
                                }
                                activeResources.add(handle);
                            }
                        }
                        finally {
                            for (ResourceHandle activeResource : activeResources) {
                                this.ds.returnResource(activeResource);
                            }
                        }
                        activeResources.clear();
                    }
                    break block12;
                }
                Resizer.debug("RA does not support ValidatingManagedConnectionFactory");
            }
            catch (ResourceException re) {
                _logger.log(Level.FINE, "ResourceException while trying to get invalid connections from MCF", re);
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "Exception while trying to get invalid connections from MCF", e);
            }
        }
    }

    private static void debug(String debugStatement) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, debugStatement);
        }
    }
}

