/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsClassLoaderUtil;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.api.WorkManagerFactory;
import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.corba.se.impl.orbutil.threadpool.ThreadPoolManagerImpl;
import com.sun.corba.se.spi.orbutil.threadpool.NoSuchThreadPoolException;
import com.sun.corba.se.spi.orbutil.threadpool.ThreadPool;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.SecurityMap;
import com.sun.enterprise.connectors.ActiveRAFactory;
import com.sun.enterprise.connectors.ConnectionManagerFactory;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.XATerminatorProxy;
import com.sun.enterprise.connectors.authentication.AuthenticationService;
import com.sun.enterprise.connectors.module.ConnectorApplication;
import com.sun.enterprise.connectors.naming.ConnectorNamingEventNotifier;
import com.sun.enterprise.connectors.service.ConnectorAdminObjectAdminServiceImpl;
import com.sun.enterprise.connectors.service.ConnectorAdminServicesFactory;
import com.sun.enterprise.connectors.service.ConnectorConnectionPoolAdminServiceImpl;
import com.sun.enterprise.connectors.service.ConnectorResourceAdminServiceImpl;
import com.sun.enterprise.connectors.service.ConnectorSecurityAdminServiceImpl;
import com.sun.enterprise.connectors.service.ConnectorService;
import com.sun.enterprise.connectors.service.ResourceAdapterAdminServiceImpl;
import com.sun.enterprise.connectors.util.RAWriterAdapter;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.logging.LogDomains;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkManager;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.glassfish.api.admin.config.Property;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class ConnectorRuntime
implements ConnectorConstants,
com.sun.appserv.connectors.internal.api.ConnectorRuntime,
PostConstruct,
PreDestroy {
    private volatile int environment = 1;
    private static ConnectorRuntime _runtime;
    private Logger _logger = LogDomains.getLogger(ConnectorRuntime.class, (String)"javax.enterprise.resource.resourceadapter");
    private ConnectorConnectionPoolAdminServiceImpl ccPoolAdmService;
    private ConnectorResourceAdminServiceImpl connectorResourceAdmService;
    private ConnectorService connectorService;
    private ResourceAdapterAdminServiceImpl resourceAdapterAdmService;
    private ConnectorSecurityAdminServiceImpl connectorSecurityAdmService;
    private ConnectorAdminObjectAdminServiceImpl adminObjectAdminService;
    private ConnectorRegistry connectorRegistry = ConnectorRegistry.getInstance();
    @Inject
    private GlassfishNamingManager namingManager;
    @Inject
    private PoolManager poolManager;
    @Inject
    private InvocationManager invocationManager;
    @Inject
    private ComponentEnvManager componentEnvManager;
    @Inject
    private JavaEETransactionManager transactionManager;
    @Inject
    private ModulesRegistry registry;
    @Inject
    private WorkManagerFactory wmf;
    @Inject
    private Resources allResources;
    @Inject
    private Habitat deployerHabitat;
    @Inject
    private ClassLoaderHierarchy clh;
    @Inject
    private ConnectorsClassLoaderUtil cclUtil;
    @Inject
    private ActiveRAFactory activeRAFactory;
    private final Object getTimerLock = new Object();
    private Timer timer;

    public static ConnectorRuntime getRuntime() {
        if (_runtime == null) {
            throw new RuntimeException("Connector Runtime not initialized");
        }
        return _runtime;
    }

    public ConnectorRuntime() {
        _runtime = this;
    }

    public void initialize(int environment) {
        this.environment = environment;
        this.connectorService.initialize(this.getEnviron());
    }

    public int getEnviron() {
        return this.environment;
    }

    public String getDefaultPoolName(String moduleName, String connectionDefName) {
        return this.connectorService.getDefaultPoolName(moduleName, connectionDefName);
    }

    public void deleteConnectorConnectionPool(String poolName) throws ConnectorRuntimeException {
        this.ccPoolAdmService.deleteConnectorConnectionPool(poolName);
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool connectorPoolObj) throws ConnectorRuntimeException {
        this.ccPoolAdmService.createConnectorConnectionPool(connectorPoolObj);
    }

    public void createConnectorResource(String jndiName, String poolName, String resourceType) throws ConnectorRuntimeException {
        this.connectorResourceAdmService.createConnectorResource(jndiName, poolName, resourceType);
    }

    public String getDefaultResourceName(String moduleName, String connectionDefName) {
        return this.connectorService.getDefaultResourceName(moduleName, connectionDefName);
    }

    public PrintWriter getResourceAdapterLogWriter() {
        Logger logger = LogDomains.getLogger(ConnectorRuntime.class, (String)"javax.enterprise.resource.resourceadapter");
        RAWriterAdapter writerAdapter = new RAWriterAdapter(logger);
        return new PrintWriter(writerAdapter);
    }

    public void deleteConnectorResource(String jndiName) throws ConnectorRuntimeException {
        this.connectorResourceAdmService.deleteConnectorResource(jndiName);
    }

    public ConnectorDescriptor getConnectorDescriptor(String rarName) throws ConnectorRuntimeException {
        return this.connectorService.getConnectorDescriptor(rarName);
    }

    public void createActiveResourceAdapter(String moduleDir, String moduleName, ClassLoader loader) throws ConnectorRuntimeException {
        this.resourceAdapterAdmService.createActiveResourceAdapter(moduleDir, moduleName, loader);
    }

    public void destroyActiveResourceAdapter(String moduleName, boolean cascade) throws ConnectorRuntimeException {
        this.resourceAdapterAdmService.stopActiveResourceAdapter(moduleName, cascade);
    }

    public ManagedConnectionFactory obtainManagedConnectionFactory(String poolName) throws ConnectorRuntimeException {
        return this.ccPoolAdmService.obtainManagedConnectionFactory(poolName);
    }

    public ManagedConnectionFactory[] obtainManagedConnectionFactories(String poolName) throws ConnectorRuntimeException {
        return this.ccPoolAdmService.obtainManagedConnectionFactories(poolName);
    }

    public ConnectionManager obtainConnectionManager(String poolName, boolean forceNoLazyAssoc) throws ConnectorRuntimeException {
        ConnectionManager mgr = ConnectionManagerFactory.getAvailableConnectionManager(poolName, forceNoLazyAssoc);
        return mgr;
    }

    public Object lookupPMResource(String jndiName, boolean force) throws NamingException {
        if (force) {
            this._logger.log(Level.INFO, "lookup PM Resource [ " + jndiName + " ] with force=true is not supported");
        }
        return this.connectorResourceAdmService.lookup(jndiName + "__pm");
    }

    public Object lookupNonTxResource(String jndiName, boolean force) throws NamingException {
        if (force) {
            this._logger.log(Level.INFO, "lookup NonTx Resource [ " + jndiName + " ] with force=true is not supported");
        }
        return this.connectorResourceAdmService.lookup(jndiName + "__nontx");
    }

    public Map<String, Object> getConnectionDefinitionPropertiesAndDefaults(String connectionDefinitionClassName) {
        return ConnectorConnectionPoolAdminServiceImpl.getConnectionDefinitionPropertiesAndDefaults(connectionDefinitionClassName);
    }

    public ThreadPool getThreadPool(String threadPoolId) throws NoSuchThreadPoolException {
        int env = this.getEnviron();
        if (env == 1) {
            ThreadPoolManagerImpl tpm = new ThreadPoolManagerImpl(null);
            if (threadPoolId != null) {
                return tpm.getThreadPool(threadPoolId);
            }
            return tpm.getDefaultThreadPool();
        }
        return null;
    }

    public void switchOnMatching(String rarName, String poolName) {
        this.connectorService.switchOnMatching(rarName, poolName);
    }

    public void switchOnMatchingInJndi(String poolName) throws ConnectorRuntimeException {
        this.ccPoolAdmService.switchOnMatching(poolName);
    }

    public GlassfishNamingManager getNamingManager() {
        return this.namingManager;
    }

    public void postConstruct() {
        this.ccPoolAdmService = (ConnectorConnectionPoolAdminServiceImpl)ConnectorAdminServicesFactory.getService("ConnectorConnectionPool");
        this.connectorResourceAdmService = (ConnectorResourceAdminServiceImpl)ConnectorAdminServicesFactory.getService("ConnectorResource");
        this.connectorService = new ConnectorService();
        this.resourceAdapterAdmService = (ResourceAdapterAdminServiceImpl)ConnectorAdminServicesFactory.getService("ResourceAdapter");
        this.connectorSecurityAdmService = (ConnectorSecurityAdminServiceImpl)ConnectorAdminServicesFactory.getService("Security");
        this.adminObjectAdminService = (ConnectorAdminObjectAdminServiceImpl)ConnectorAdminServicesFactory.getService("AdminObjectResource");
        ArrayList<ModuleDefinition> defs = new ArrayList<ModuleDefinition>();
        Module module = this.registry.makeModuleFor("org.glassfish.common.glassfish-api", null);
        if (module != null) {
            defs.add(module.getModuleDefinition());
        }
        if ((module = this.registry.makeModuleFor("org.glassfish.common.glassfish-ee-api", null)) != null) {
            defs.add(module.getModuleDefinition());
        }
        if ((module = this.registry.makeModuleFor("org.glassfish.common.common-util", null)) != null) {
            defs.add(module.getModuleDefinition());
        }
        if ((module = this.registry.makeModuleFor("org.glassfish.connectors.connectors-internal-api", null)) != null) {
            defs.add(module.getModuleDefinition());
        }
    }

    public boolean isConnectorConnectionPoolDeployed(String poolName) {
        return this.ccPoolAdmService.isConnectorConnectionPoolDeployed(poolName);
    }

    public boolean reconfigureConnectorConnectionPool(ConnectorConnectionPool ccp, Set excludedProps) throws ConnectorRuntimeException {
        return this.ccPoolAdmService.reconfigureConnectorConnectionPool(ccp, excludedProps);
    }

    public void recreateConnectorConnectionPool(ConnectorConnectionPool ccp) throws ConnectorRuntimeException {
        this.ccPoolAdmService.recreateConnectorConnectionPool(ccp);
    }

    public void createConnectorConnectionPool(ConnectorConnectionPool ccp, String connectionDefinitionName, String rarName, List<Property> props, List<SecurityMap> securityMaps) throws ConnectorRuntimeException {
        this.ccPoolAdmService.createConnectorConnectionPool(ccp, connectionDefinitionName, rarName, props, securityMaps);
    }

    public boolean checkAndLoadResource(Object resource, Object pool, String resourceType, String resourceName, String raName) throws ConnectorRuntimeException {
        return this.connectorService.checkAndLoadResource(resource, pool, resourceType, resourceName, raName);
    }

    public void stopAllActiveResourceAdapters() {
        this.resourceAdapterAdmService.stopAllActiveResourceAdapters();
    }

    public void shutdownAllActiveResourceAdapters(Collection<String> resources) {
        this.stopAllActiveResourceAdapters();
    }

    public PoolManager getPoolManager() {
        return this.poolManager;
    }

    public InvocationManager getInvocationManager() {
        return this.invocationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timer getTimer() {
        Object object = this.getTimerLock;
        synchronized (object) {
            if (this.timer == null) {
                this.timer = new Timer("connector-runtime", true);
            }
        }
        return this.timer;
    }

    public Set getResourceReferenceDescriptor() {
        JndiNameEnvironment jndiEnv = this.componentEnvManager.getCurrentJndiNameEnvironment();
        if (jndiEnv != null) {
            return jndiEnv.getResourceReferenceDescriptors();
        }
        return null;
    }

    public void preDestroy() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public AuthenticationService getAuthenticationService(String rarName, String poolName) {
        return this.connectorSecurityAdmService.getAuthenticationService(rarName, poolName);
    }

    public static boolean isServer() {
        ConnectorRuntime connectorRuntime = ConnectorRuntime.getRuntime();
        return connectorRuntime.connectorService.isServer();
    }

    public Transaction getTransaction() throws SystemException {
        return this.transactionManager.getTransaction();
    }

    public JavaEETransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    private ConnectorNamingEventNotifier getResourceRebindEventNotifier() {
        return this.connectorResourceAdmService.getResourceRebindEventNotifier();
    }

    public ResourcePool getConnectionPoolConfig(String poolName) {
        return ConnectorsUtil.getConnectionPoolConfig((String)poolName, (Resources)this.allResources);
    }

    public boolean pingConnectionPool(String poolName) throws ResourceException {
        return this.ccPoolAdmService.testConnectionPool(poolName);
    }

    public ConnectorConstants.PoolType getPoolType(String poolName) throws ConnectorRuntimeException {
        return this.ccPoolAdmService.getPoolType(poolName);
    }

    public WorkManager getWorkManagerProxy(String poolId, String moduleName) throws ConnectorRuntimeException {
        return this.wmf.getWorkManagerProxy(poolId, moduleName);
    }

    public XATerminator getXATerminatorProxy(String moduleName) {
        XATerminator xat = this.getTransactionManager().getXATerminator();
        return new XATerminatorProxy(xat);
    }

    public void removeWorkManagerProxy(String moduleName) {
        this.wmf.removeWorkManager(moduleName);
    }

    public void addAdminObject(String appName, String connectorName, String jndiName, String adminObjectType, Properties props) throws ConnectorRuntimeException {
        this.adminObjectAdminService.addAdminObject(appName, connectorName, jndiName, adminObjectType, props);
    }

    public void deleteAdminObject(String jndiName) throws ConnectorRuntimeException {
        this.adminObjectAdminService.deleteAdminObject(jndiName);
    }

    public ClassLoader getConnectorClassLoader(String rarName) {
        return this.clh.getConnectorClassLoader(rarName);
    }

    public ClassLoader createConnectorClassLoader(String moduleDirectory) {
        return this.cclUtil.createRARClassLoader(moduleDirectory);
    }

    public ResourceDeployer getResourceDeployer(Object resource) {
        Collection deployers = this.deployerHabitat.getAllByContract(ResourceDeployer.class);
        for (ResourceDeployer deployer : deployers) {
            if (!deployer.handles(resource)) continue;
            return deployer;
        }
        return null;
    }

    public void addResourceAdapterConfig(String rarName, ResourceAdapterConfig raConfig) throws ConnectorRuntimeException {
        this.resourceAdapterAdmService.addResourceAdapterConfig(rarName, raConfig);
    }

    public void deleteResourceAdapterConfig(String rarName) {
        this.resourceAdapterAdmService.deleteResourceAdapterConfig(rarName);
    }

    public void registerConnectorApplication(ConnectorApplication rarModule) {
        this.connectorRegistry.addConnectorApplication(rarModule);
    }

    public void unregisterConnectorApplication(String rarName) {
        this.connectorRegistry.removeConnectorApplication(rarName);
    }

    public void undeployResourcesOfModule(String rarName) {
        ConnectorApplication app = this.connectorRegistry.getConnectorApplication(rarName);
        app.undeployResources();
    }

    public void deployResourcesOfModule(String rarName) {
        ConnectorApplication app = this.connectorRegistry.getConnectorApplication(rarName);
        app.deployResources();
    }

    public ActiveRAFactory getActiveRAFactory() {
        return this.activeRAFactory;
    }
}

