/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.DeferredResourceConfig;
import com.sun.enterprise.connectors.util.ClassLoadingUtility;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.XADataSource;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.config.ConfigBeanProxy;

public class ResourcesUtil {
    static ThreadLocal<ResourcesUtil> localResourcesUtil = new ThreadLocal();
    static Logger _logger = LogDomains.getLogger(ResourcesUtil.class, (String)"javax.enterprise.resource.resourceadapter");
    static StringManager localStrings = StringManager.getManager(ResourcesUtil.class);
    static ServerContext sc_ = null;
    protected Domain dom = null;
    protected Resources res = null;

    public static void setServerContext(ServerContext sc) {
        sc_ = sc;
    }

    public boolean belongToStandAloneRar(String resourceAdapterName) {
        return false;
    }

    public static ResourcesUtil createInstance() {
        if (localResourcesUtil.get() != null) {
            return localResourcesUtil.get();
        }
        localResourcesUtil.set(new ResourcesUtil());
        return localResourcesUtil.get();
    }

    public String getRANameofJdbcConnectionPool(JdbcConnectionPool pool) {
        String dsRAName = "__ds_jdbc_ra";
        if (pool.getResType() == null || pool.getDatasourceClassname() == null) {
            return dsRAName;
        }
        Class dsClass = null;
        try {
            dsClass = ClassLoadingUtility.loadClass(pool.getDatasourceClassname());
        }
        catch (ClassNotFoundException cnfe) {
            return dsRAName;
        }
        if ("javax.sql.XADataSource".equals(pool.getResType()) && XADataSource.class.isAssignableFrom(dsClass)) {
            return "__xa_jdbc_ra";
        }
        if ("javax.sql.ConnectionPoolDataSource".equals(pool.getResType()) && ConnectionPoolDataSource.class.isAssignableFrom(dsClass)) {
            return "__cp_jdbc_ra";
        }
        return dsRAName;
    }

    public DeferredResourceConfig getDeferredResourceConfig(Object resource, Object pool, String resType, String raName) throws ConnectorRuntimeException {
        String resourceAdapterName = raName;
        DeferredResourceConfig resConfig = null;
        if ("jdbc".equalsIgnoreCase(resType) || "jcp".equalsIgnoreCase(resType)) {
            JdbcConnectionPool jdbcPool = (JdbcConnectionPool)pool;
            JdbcResource jdbcResource = (JdbcResource)resource;
            resourceAdapterName = this.getRANameofJdbcConnectionPool((JdbcConnectionPool)pool);
            resConfig = new DeferredResourceConfig(resourceAdapterName, null, null, null, jdbcPool, jdbcResource, null);
            ConfigBeanProxy[] resourcesToload = new ConfigBeanProxy[]{jdbcPool, jdbcResource};
            resConfig.setResourcesToLoad(resourcesToload);
        } else if ("cr".equalsIgnoreCase(resType) || "ccp".equalsIgnoreCase(resType)) {
            ConnectorConnectionPool connPool = (ConnectorConnectionPool)pool;
            ConnectorResource connResource = (ConnectorResource)resource;
            resConfig = new DeferredResourceConfig(resourceAdapterName, null, connPool, connResource, null, null, null);
            ConfigBeanProxy[] resourcesToload = new ConfigBeanProxy[]{connPool, connResource};
            resConfig.setResourcesToLoad(resourcesToload);
        } else {
            throw new ConnectorRuntimeException("unsupported resource type : " + resType);
        }
        return resConfig;
    }

    protected boolean isReferenced(String resourceName) {
        throw new UnsupportedOperationException();
    }

    public String getResourceType(ConfigBeanProxy cb) {
        if (cb instanceof ConnectorConnectionPool) {
            return "ccp";
        }
        if (cb instanceof ConnectorResource) {
            return "cr";
        }
        if (cb instanceof JdbcConnectionPool) {
            return "jcp";
        }
        if (cb instanceof JdbcResource) {
            return "jdbc";
        }
        return null;
    }
}

