/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.spi.ConfigurableTransactionSupport;
import com.sun.appserv.connectors.spi.TransactionSupport;
import com.sun.enterprise.connectors.ActiveResourceAdapter;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import com.sun.enterprise.connectors.util.ConnectorDDTransformUtils;
import com.sun.enterprise.connectors.util.PrintWriterAdapter;
import com.sun.enterprise.connectors.util.SetMethodAction;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.io.PrintWriter;
import java.security.PrivilegedActionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class ActiveResourceAdapterImpl
implements ActiveResourceAdapter {
    protected ConnectorDescriptor desc_;
    protected String moduleName_;
    protected ClassLoader jcl_;
    protected ConnectionDefDescriptor[] connectionDefs_;
    protected ConnectorRuntime connectorRuntime_ = null;
    private static Logger _logger = LogDomains.getLogger(ActiveResourceAdapterImpl.class, (String)"javax.enterprise.resource.resourceadapter");
    private StringManager localStrings = StringManager.getManager(ActiveResourceAdapterImpl.class);

    public void init(ResourceAdapter ra, ConnectorDescriptor desc, String moduleName, ClassLoader jcl) throws ConnectorRuntimeException {
        this.desc_ = desc;
        this.moduleName_ = moduleName;
        this.jcl_ = jcl;
        this.connectorRuntime_ = ConnectorRuntime.getRuntime();
        this.connectionDefs_ = ConnectorDDTransformUtils.getConnectionDefs(this.desc_);
    }

    public String getModuleName() {
        return this.moduleName_;
    }

    public void setup() throws ConnectorRuntimeException {
        if (this.connectionDefs_ == null || this.connectionDefs_.length != 1) {
            _logger.log(Level.SEVERE, "rardeployment.invalid_connector_desc", this.moduleName_);
            String i18nMsg = this.localStrings.getString("ccp_adm.invalid_connector_desc", (Object)this.moduleName_);
            throw new ConnectorRuntimeException(i18nMsg);
        }
        if (this.isServer() && !this.isSystemRar(this.moduleName_)) {
            this.createAllConnectorResources();
        }
        _logger.log(Level.FINE, "Completed Active Resource adapter setup", this.moduleName_);
    }

    protected boolean isServer() {
        return this.connectorRuntime_.getEnviron() == 1;
    }

    protected void createAllConnectorResources() throws ConnectorRuntimeException {
        try {
            if (this.desc_.getSunDescriptor() != null && this.desc_.getSunDescriptor().getResourceAdapter() != null) {
                String jndiName = (String)this.desc_.getSunDescriptor().getResourceAdapter().getValue("JndiName");
                if (jndiName == null || jndiName.equals("")) {
                    this.createDefaultConnectorConnectionPools(true);
                } else {
                    this.createSunRAConnectionPool();
                    this.createDefaultConnectorConnectionPools(false);
                }
            } else {
                this.createDefaultConnectorConnectionPools(false);
            }
            this.createDefaultConnectorResources();
        }
        catch (ConnectorRuntimeException cre) {
            _logger.log(Level.SEVERE, "rardeployment.defaultpoolresourcecreation.failed", cre);
            _logger.log(Level.FINE, "Error while trying to create the default connectorconnection pool and resource", cre);
        }
    }

    protected void destroyAllConnectorResources() {
        if (!this.isSystemRar(this.moduleName_)) {
            String jndiName;
            this.deleteDefaultConnectorResources();
            this.deleteDefaultConnectorConnectionPools();
            if (this.desc_.getSunDescriptor() != null && this.desc_.getSunDescriptor().getResourceAdapter() != null && (jndiName = (String)this.desc_.getSunDescriptor().getResourceAdapter().getValue("JndiName")) != null && !jndiName.equals("")) {
                this.deleteSunRAConnectionPool();
            }
        }
    }

    protected boolean isSystemRar(String moduleName) {
        return ConnectorsUtil.belongsToSystemRA((String)moduleName);
    }

    protected void deleteDefaultConnectorConnectionPools() {
        for (ConnectionDefDescriptor aConnectionDefs_ : this.connectionDefs_) {
            String connectionDefName = aConnectionDefs_.getConnectionFactoryIntf();
            String resourceJndiName = this.connectorRuntime_.getDefaultPoolName(this.moduleName_, connectionDefName);
            try {
                this.connectorRuntime_.deleteConnectorConnectionPool(resourceJndiName);
            }
            catch (ConnectorRuntimeException cre) {
                _logger.log(Level.WARNING, "rar.undeployment.default_pool_delete_fail", resourceJndiName);
            }
        }
    }

    protected void deleteDefaultConnectorResources() {
        for (ConnectionDefDescriptor aConnectionDefs_ : this.connectionDefs_) {
            String connectionDefName = aConnectionDefs_.getConnectionFactoryIntf();
            String resourceJndiName = this.connectorRuntime_.getDefaultResourceName(this.moduleName_, connectionDefName);
            try {
                this.connectorRuntime_.deleteConnectorResource(resourceJndiName);
            }
            catch (ConnectorRuntimeException cre) {
                _logger.log(Level.WARNING, "rar.undeployment.default_resource_delete_fail", resourceJndiName);
                _logger.log(Level.FINE, "Error while trying to delete the default connector resource", cre);
            }
        }
    }

    public void destroy() {
        if (this.isServer()) {
            this.destroyAllConnectorResources();
        }
    }

    public ConnectorDescriptor getDescriptor() {
        return this.desc_;
    }

    public boolean handles(ConnectorDescriptor cd) {
        return "".equals(cd.getResourceAdapterClass());
    }

    public ManagedConnectionFactory[] createManagedConnectionFactories(ConnectorConnectionPool ccp, ClassLoader jcl) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public ManagedConnectionFactory createManagedConnectionFactory(ConnectorConnectionPool ccp, ClassLoader jcl) {
        String mcfClass = ccp.getConnectorDescriptorInfo().getManagedConnectionFactoryClass();
        try {
            ManagedConnectionFactory mcf = null;
            mcf = this.instantiateMCF(mcfClass, jcl);
            if (mcf instanceof ConfigurableTransactionSupport) {
                TransactionSupport ts = ConnectionPoolObjectsUtils.getTransactionSupport(ccp.getTransactionSupport());
                if (!TransactionSupport.XA_TRANSACTION.equals((Object)ts)) {
                    ((ConfigurableTransactionSupport)mcf).setTransactionSupport(ts);
                } else {
                    throw new UnsupportedOperationException("XA Transaction is not supported");
                }
            }
            SetMethodAction setMethodAction = new SetMethodAction(mcf, ccp.getConnectorDescriptorInfo().getMCFConfigProperties());
            setMethodAction.run();
            _logger.log(Level.FINE, "Created MCF object : ", mcfClass);
            return mcf;
        }
        catch (PrivilegedActionException ex) {
            _logger.log(Level.SEVERE, "rardeployment.privilegedaction_error", new Object[]{mcfClass, ex.getException().getMessage()});
            _logger.log(Level.FINE, "rardeployment.privilegedaction_error", ex.getException());
            return null;
        }
        catch (ClassNotFoundException Ex) {
            _logger.log(Level.SEVERE, "rardeployment.class_not_found", new Object[]{mcfClass, Ex.getMessage()});
            _logger.log(Level.FINE, "rardeployment.class_not_found", Ex);
            return null;
        }
        catch (InstantiationException Ex) {
            _logger.log(Level.SEVERE, "rardeployment.class_instantiation_error", new Object[]{mcfClass, Ex.getMessage()});
            _logger.log(Level.FINE, "rardeployment.class_instantiation_error", Ex);
            return null;
        }
        catch (IllegalAccessException Ex) {
            _logger.log(Level.SEVERE, "rardeployment.illegalaccess_error", new Object[]{mcfClass, Ex.getMessage()});
            _logger.log(Level.FINE, "rardeployment.illegalaccess_error", Ex);
            return null;
        }
        catch (Exception Ex) {
            _logger.log(Level.SEVERE, "rardeployment.mcfcreation_error", new Object[]{mcfClass, Ex.getMessage()});
            _logger.log(Level.FINE, "rardeployment.mcfcreation_error", Ex);
            return null;
        }
    }

    private void setLogWriter(ManagedConnectionFactory mcf) {
        PrintWriterAdapter adapter = new PrintWriterAdapter(ConnectorRuntime.getRuntime().getResourceAdapterLogWriter());
        try {
            mcf.setLogWriter((PrintWriter)adapter);
        }
        catch (Exception e) {
            Object[] params = new Object[]{mcf.getClass().getName(), e.getMessage()};
            _logger.log(Level.WARNING, "rardeployment.logwriter_error", params);
            _logger.log(Level.FINE, "Unable to set LogWriter for ManagedConnectionFactory : " + mcf.getClass().getName(), e);
        }
    }

    private ManagedConnectionFactory instantiateMCF(String mcfClass, ClassLoader loader) throws Exception {
        ManagedConnectionFactory mcf = null;
        mcf = this.jcl_ != null ? (ManagedConnectionFactory)this.jcl_.loadClass(mcfClass).newInstance() : (loader != null ? (ManagedConnectionFactory)loader.loadClass(mcfClass).newInstance() : (ManagedConnectionFactory)Class.forName(mcfClass).newInstance());
        this.setLogWriter(mcf);
        return mcf;
    }

    protected void createDefaultConnectorResources() throws ConnectorRuntimeException {
        for (ConnectionDefDescriptor descriptor : this.connectionDefs_) {
            String connectionDefName = descriptor.getConnectionFactoryIntf();
            String resourceName = this.connectorRuntime_.getDefaultResourceName(this.moduleName_, connectionDefName);
            String poolName = this.connectorRuntime_.getDefaultPoolName(this.moduleName_, connectionDefName);
            this.connectorRuntime_.createConnectorResource(resourceName, poolName, null);
            _logger.log(Level.FINE, "Created default connector resource : ", resourceName);
        }
    }

    protected void createDefaultConnectorConnectionPools(boolean useSunRA) throws ConnectorRuntimeException {
        for (ConnectionDefDescriptor descriptor : this.connectionDefs_) {
            String poolName = this.connectorRuntime_.getDefaultPoolName(this.moduleName_, descriptor.getConnectionFactoryIntf());
            ConnectorDescriptorInfo connectorDescriptorInfo = ConnectorDDTransformUtils.getConnectorDescriptorInfo(descriptor);
            connectorDescriptorInfo.setRarName(this.moduleName_);
            connectorDescriptorInfo.setResourceAdapterClassName(this.desc_.getResourceAdapterClass());
            ConnectorConnectionPool connectorPoolObj = useSunRA ? ConnectionPoolObjectsUtils.createSunRaConnectorPoolObject(poolName, this.desc_, this.moduleName_) : ConnectionPoolObjectsUtils.createDefaultConnectorPoolObject(poolName, this.moduleName_);
            connectorPoolObj.setConnectorDescriptorInfo(connectorDescriptorInfo);
            this.connectorRuntime_.createConnectorConnectionPool(connectorPoolObj);
            _logger.log(Level.FINE, "Created default connection pool : ", poolName);
        }
    }

    private void createSunRAConnectionPool() throws ConnectorRuntimeException {
        String defaultPoolName = this.connectorRuntime_.getDefaultPoolName(this.moduleName_, this.connectionDefs_[0].getConnectionFactoryIntf());
        String sunRAPoolName = defaultPoolName + "sunRAPool";
        ConnectorDescriptorInfo connectorDescriptorInfo = ConnectorDDTransformUtils.getConnectorDescriptorInfo(this.connectionDefs_[0]);
        connectorDescriptorInfo.setRarName(this.moduleName_);
        connectorDescriptorInfo.setResourceAdapterClassName(this.desc_.getResourceAdapterClass());
        ConnectorConnectionPool connectorPoolObj = ConnectionPoolObjectsUtils.createSunRaConnectorPoolObject(sunRAPoolName, this.desc_, this.moduleName_);
        connectorPoolObj.setConnectorDescriptorInfo(connectorDescriptorInfo);
        this.connectorRuntime_.createConnectorConnectionPool(connectorPoolObj);
        _logger.log(Level.FINE, "Created SUN-RA connection pool:", sunRAPoolName);
        String jndiName = (String)this.desc_.getSunDescriptor().getResourceAdapter().getValue("JndiName");
        this.connectorRuntime_.createConnectorResource(jndiName, sunRAPoolName, null);
        _logger.log(Level.FINE, "Created SUN-RA connector resource : ", jndiName);
    }

    private void deleteSunRAConnectionPool() {
        String defaultPoolName = this.connectorRuntime_.getDefaultPoolName(this.moduleName_, this.connectionDefs_[0].getConnectionFactoryIntf());
        String sunRAPoolName = defaultPoolName + "sunRAPool";
        try {
            this.connectorRuntime_.deleteConnectorConnectionPool(sunRAPoolName);
        }
        catch (ConnectorRuntimeException cre) {
            _logger.log(Level.WARNING, "rar.undeployment.sun_ra_pool_delete_fail", sunRAPoolName);
        }
    }

    public ClassLoader getClassLoader() {
        return this.jcl_;
    }
}

