/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.service;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.DeferredResourceConfig;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.util.ConnectorDDTransformUtils;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.config.ConfigBeanProxy;

public class ConnectorService
implements ConnectorConstants {
    protected static final Logger _logger = LogDomains.getLogger(ConnectorService.class, (String)"javax.enterprise.resource.resourceadapter");
    protected static final ConnectorRegistry _registry = ConnectorRegistry.getInstance();
    private boolean debug = true;
    protected static int environment = 1;
    protected ConnectorRuntime _runtime = ConnectorRuntime.getRuntime();

    public void initialize(int environ) {
        environment = environ;
    }

    public static int getEnviron() {
        return environment;
    }

    public String getDefaultPoolName(String moduleName, String connectionDefName) {
        return moduleName + "#" + connectionDefName;
    }

    public String getDefaultResourceName(String moduleName, String connectionDefName) {
        String resourceJNDIName = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForResource(moduleName);
        return resourceJNDIName + "#" + connectionDefName;
    }

    public static boolean isServer() {
        return ConnectorService.getEnviron() == 1;
    }

    public boolean checkAndLoadResource(Object resource, Object pool, String resourceType, String resourceName, String raName) throws ConnectorRuntimeException {
        String resname = ConnectorAdminServiceUtils.getOriginalResourceName(resourceName);
        _logger.fine("ConnectorService :: checkAndLoadResource resolved to load " + resname);
        ResourcesUtil resUtil = ResourcesUtil.createInstance();
        DeferredResourceConfig defResConfig = resUtil.getDeferredResourceConfig(resource, pool, resourceType, raName);
        return this.loadResourcesAndItsRar(defResConfig);
    }

    public boolean loadResourcesAndItsRar(DeferredResourceConfig defResConfig) {
        if (defResConfig != null) {
            try {
                this.loadDeferredResources((ConfigBeanProxy[])defResConfig.getResourceAdapterConfig());
                String rarName = defResConfig.getRarName();
                this.loadDeferredResourceAdapter(rarName);
                final ConfigBeanProxy[] resToLoad = defResConfig.getResourcesToLoad();
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            ConnectorService.this.loadDeferredResources(resToLoad);
                        }
                        catch (Exception ex) {
                            _logger.log(Level.SEVERE, "failed to load resources/ResourceAdapter");
                            _logger.log(Level.SEVERE, "", ex);
                        }
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "failed to load resources/ResourceAdapter");
                _logger.log(Level.SEVERE, "", ex);
                return false;
            }
            return true;
        }
        return false;
    }

    public void loadDeferredResourceAdapter(String rarName) throws ConnectorRuntimeException {
        try {
            if (ConnectorsUtil.belongsToSystemRA((String)rarName)) {
                this._runtime.createActiveResourceAdapter(ConnectorsUtil.getSystemModuleLocation((String)rarName), rarName, null);
            }
        }
        catch (Exception e) {
            ConnectorRuntimeException ce = new ConnectorRuntimeException(e.getMessage());
            ce.initCause((Throwable)e);
            throw ce;
        }
    }

    public void loadDeferredResources(ConfigBeanProxy[] resourcesToLoad) throws Exception {
        if (resourcesToLoad == null || resourcesToLoad.length == 0) {
            return;
        }
        for (ConfigBeanProxy resource : resourcesToLoad) {
            if (resource == null) continue;
            try {
                this._runtime.getResourceDeployer(resource).deployResource((Object)resource);
            }
            catch (Exception e) {
                ConnectorRuntimeException cre = new ConnectorRuntimeException(e.getMessage());
                cre.initCause((Throwable)e);
                throw cre;
            }
        }
    }

    public ConnectorDescriptor getConnectorDescriptor(String rarName) throws ConnectorRuntimeException {
        if (rarName == null) {
            return null;
        }
        ConnectorDescriptor desc = null;
        desc = _registry.getDescriptor(rarName);
        if (desc != null) {
            return desc;
        }
        String moduleDir = ConnectorsUtil.belongsToSystemRA((String)rarName) ? ConnectorsUtil.getSystemModuleLocation((String)rarName) : ConnectorsUtil.getLocation((String)rarName);
        if (moduleDir != null) {
            desc = ConnectorDDTransformUtils.getConnectorDescriptor(moduleDir);
        } else {
            _logger.log(Level.SEVERE, "rardeployment.no_module_deployed", rarName);
        }
        return desc;
    }

    public void switchOnMatching(String rarName, String poolName) {
        PoolManager poolMgr;
        boolean result;
        if ((rarName.equals("__ds_jdbc_ra") || rarName.equals("__cp_jdbc_ra") || rarName.equals("__xa_jdbc_ra")) && !(result = (poolMgr = this._runtime.getPoolManager()).switchOnMatching(poolName))) {
            try {
                this._runtime.switchOnMatchingInJndi(poolName);
            }
            catch (ConnectorRuntimeException cre) {
                // empty catch block
            }
        }
    }

    public boolean checkAndLoadPool(String poolName) {
        boolean status = false;
        try {
            ResourcesUtil resutil = ResourcesUtil.createInstance();
            ResourcePool pool = this._runtime.getConnectionPoolConfig(poolName);
            DeferredResourceConfig defResConfig = resutil.getDeferredResourceConfig(null, pool, ConnectorsUtil.getResourceType((Resource)pool), null);
            status = this.loadResourcesAndItsRar(defResConfig);
        }
        catch (ConnectorRuntimeException cre) {
            _logger.log(Level.WARNING, "unable to load Jdbc Connection Pool [ " + poolName + " ]", cre);
        }
        return status;
    }

    public void ifSystemRarLoad(String rarName) throws ConnectorRuntimeException {
        if (ConnectorsUtil.belongsToSystemRA((String)rarName)) {
            this.loadDeferredResourceAdapter(rarName);
        }
    }
}

