/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.api.JavaEEResource;
import com.sun.appserv.connectors.internal.api.ResourcePropertyImpl;
import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.PersistenceManagerFactoryResource;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.resource.beans.PMFResource;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.glassfish.api.admin.config.Property;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class PersistenceManagerFactoryResourceDeployer
implements ResourceDeployer {
    @Inject
    private GlassfishNamingManager namingMgr;
    private static final StringManager localStrings = StringManager.getManager(PersistenceManagerFactoryResourceDeployer.class);
    private static Logger _logger = LogDomains.getLogger(PersistenceManagerFactoryResourceDeployer.class, (String)"javax.enterprise.system.core");
    private static final String SET_ = "set";
    private static final String SET_CONNECTION_FACTORY_NAME = "setConnectionFactoryName";

    public synchronized void deployResource(Object resource) throws Exception {
        PersistenceManagerFactoryResource configPMFRes = (PersistenceManagerFactoryResource)resource;
        this.loadJdbcResource(configPMFRes);
        PMFResource j2eeResource = (PMFResource)PersistenceManagerFactoryResourceDeployer.toPMFJavaEEResource(configPMFRes);
        this.installPersistenceManagerResource(j2eeResource);
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        PersistenceManagerFactoryResource configPMFRes = (PersistenceManagerFactoryResource)resource;
        this.namingMgr.unpublishObject(configPMFRes.getJndiName());
    }

    public synchronized void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    public boolean handles(Object resource) {
        return resource instanceof PersistenceManagerFactoryResource;
    }

    public synchronized void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public synchronized void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    private void loadJdbcResource(PersistenceManagerFactoryResource cr) throws Exception {
        String resName = cr.getJdbcResourceJndiName();
        try {
            InitialContext ic = new InitialContext();
            ic.lookup(resName);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Unable to load jdbc-resource [ " + resName + " ] " + "used by PMF [ " + cr.getJndiName() + " ]", e);
        }
    }

    public void installPersistenceManagerResource(PMFResource pmfRes) throws Exception {
        String jndiName = null;
        try {
            jndiName = pmfRes.getName();
            this.logFine("***** installPersistenceManagerResources jndiName *****" + jndiName);
            String factory = pmfRes.getFactoryClass();
            this.logFine("**** PersistenceManagerSettings - factory " + factory);
            Class<?> pmfImplClass = Class.forName(factory);
            Object pmfImpl = pmfImplClass.newInstance();
            String ds_jndi = pmfRes.getJdbcResourceJndiName();
            if (ds_jndi != null && ds_jndi.length() > 0) {
                String ds_jndi_pm = ConnectorsUtil.getPMJndiName((String)ds_jndi);
                this.logFine("**** PersistenceManagerSettings - ds_jndi " + ds_jndi_pm);
                DataSource pmDataSource = null;
                try {
                    InitialContext ctx = new InitialContext();
                    pmDataSource = (DataSource)ctx.lookup(ds_jndi_pm);
                    Method connFacMethod = pmfImplClass.getMethod(SET_CONNECTION_FACTORY_NAME, String.class);
                    connFacMethod.invoke(pmfImpl, ds_jndi_pm);
                }
                catch (Exception ex) {
                    _logger.log(Level.SEVERE, "jndi.persistence_manager_config", ds_jndi_pm);
                    _logger.log(Level.FINE, "jndi.persistence_manager_config_excp", ex);
                    throw ex;
                }
            }
            Set propSet = pmfRes.getProperties();
            for (ResourceProperty prop : propSet) {
                String name = prop.getName();
                String value = (String)prop.getValue();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("**** PersistenceManager propSettings - " + name + " " + value);
                }
                String methodName = SET_ + name.substring(0, 1).toUpperCase() + name.substring(1);
                Method method = pmfImplClass.getMethod(methodName, String.class);
                method.invoke(pmfImpl, value);
            }
            this.namingMgr.publishObject(jndiName, pmfImpl, true);
            this.logFine("***** After publishing PersistenceManagerResources *****");
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "poolmgr.datasource_error", jndiName);
            _logger.log(Level.FINE, "poolmgr.datasource_error_excp", ex);
            throw ex;
        }
    }

    private void logFine(String msg) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(msg);
        }
    }

    public static JavaEEResource toPMFJavaEEResource(PersistenceManagerFactoryResource rbean) {
        PMFResource jr = new PMFResource(rbean.getJndiName());
        jr.setFactoryClass(rbean.getFactoryClass());
        jr.setJdbcResourceJndiName(rbean.getJdbcResourceJndiName());
        List properties = rbean.getProperty();
        if (properties != null) {
            for (Property property : properties) {
                ResourcePropertyImpl rp = new ResourcePropertyImpl(property.getName(), (Object)property.getValue());
                jr.addProperty((ResourceProperty)rp);
            }
        }
        return jr;
    }
}

