/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.DeferredResourceConfig;
import com.sun.enterprise.connectors.util.ClassLoadingUtility;
import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.util.RelativePathResolver;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.net.URI;
import java.util.List;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.XADataSource;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.config.ConfigBeanProxy;

public class ResourcesUtil {
    static ThreadLocal<ResourcesUtil> localResourcesUtil = new ThreadLocal();
    static Logger _logger = LogDomains.getLogger(ResourcesUtil.class, (String)"javax.enterprise.resource.resourceadapter");
    static StringManager localStrings = StringManager.getManager(ResourcesUtil.class);
    static ServerContext sc_ = null;
    protected Domain dom = null;
    protected Resources res = null;
    private ConnectorRuntime runtime = ConnectorRuntime.getRuntime();

    public static void setServerContext(ServerContext sc) {
        sc_ = sc;
    }

    private Applications getApplications() {
        return this.runtime.getApplications();
    }

    private ConnectorModule getConnectorModuleByName(String name) {
        ConnectorModule module = null;
        List modules = this.getApplications().getModules(ConnectorModule.class);
        for (ConnectorModule connectorModule : modules) {
            if (!connectorModule.getName().equals(name)) continue;
            module = connectorModule;
            break;
        }
        return module;
    }

    private com.sun.enterprise.config.serverbeans.Application getApplicationByName(String name) {
        com.sun.enterprise.config.serverbeans.Application application = null;
        List apps = this.getApplications().getApplications();
        for (com.sun.enterprise.config.serverbeans.Application app : apps) {
            if (!app.getName().equals(name)) continue;
            application = app;
            break;
        }
        return application;
    }

    public String getApplicationDeployLocation(String appName) {
        String location = null;
        com.sun.enterprise.config.serverbeans.Application app = this.getApplicationByName(appName);
        if (app != null) {
            location = RelativePathResolver.resolvePath((String)app.getLocation());
        }
        return location;
    }

    public boolean belongToStandAloneRar(String resourceAdapterName) {
        ConnectorModule connectorModule = this.getConnectorModuleByName(resourceAdapterName);
        return connectorModule != null;
    }

    public static ResourcesUtil createInstance() {
        if (localResourcesUtil.get() != null) {
            return localResourcesUtil.get();
        }
        localResourcesUtil.set(new ResourcesUtil());
        return localResourcesUtil.get();
    }

    public String getRANameofJdbcConnectionPool(JdbcConnectionPool pool) {
        String dsRAName = "__ds_jdbc_ra";
        if (pool.getResType() == null || pool.getDatasourceClassname() == null) {
            return dsRAName;
        }
        Class dsClass = null;
        try {
            dsClass = ClassLoadingUtility.loadClass(pool.getDatasourceClassname());
        }
        catch (ClassNotFoundException cnfe) {
            return dsRAName;
        }
        if ("javax.sql.XADataSource".equals(pool.getResType()) && XADataSource.class.isAssignableFrom(dsClass)) {
            return "__xa_jdbc_ra";
        }
        if ("javax.sql.ConnectionPoolDataSource".equals(pool.getResType()) && ConnectionPoolDataSource.class.isAssignableFrom(dsClass)) {
            return "__cp_jdbc_ra";
        }
        return dsRAName;
    }

    public DeferredResourceConfig getDeferredResourceConfig(Object resource, Object pool, String resType, String raName) throws ConnectorRuntimeException {
        String resourceAdapterName = raName;
        DeferredResourceConfig resConfig = null;
        if ("jdbc".equalsIgnoreCase(resType) || "jcp".equalsIgnoreCase(resType)) {
            JdbcConnectionPool jdbcPool = (JdbcConnectionPool)pool;
            JdbcResource jdbcResource = (JdbcResource)resource;
            resourceAdapterName = this.getRANameofJdbcConnectionPool((JdbcConnectionPool)pool);
            resConfig = new DeferredResourceConfig(resourceAdapterName, null, null, null, jdbcPool, jdbcResource, null);
            ConfigBeanProxy[] resourcesToload = new ConfigBeanProxy[]{jdbcPool, jdbcResource};
            resConfig.setResourcesToLoad(resourcesToload);
        } else if ("cr".equalsIgnoreCase(resType) || "ccp".equalsIgnoreCase(resType)) {
            ConnectorConnectionPool connPool = (ConnectorConnectionPool)pool;
            ConnectorResource connResource = (ConnectorResource)resource;
            resourceAdapterName = connPool.getResourceAdapterName();
            resConfig = new DeferredResourceConfig(resourceAdapterName, null, connPool, connResource, null, null, null);
            ConfigBeanProxy[] resourcesToload = new ConfigBeanProxy[]{connPool, connResource};
            resConfig.setResourcesToLoad(resourcesToload);
        } else {
            throw new ConnectorRuntimeException("unsupported resource type : " + resType);
        }
        return resConfig;
    }

    protected boolean isReferenced(String resourceName) {
        throw new UnsupportedOperationException();
    }

    public String getResourceType(ConfigBeanProxy cb) {
        if (cb instanceof ConnectorConnectionPool) {
            return "ccp";
        }
        if (cb instanceof ConnectorResource) {
            return "cr";
        }
        if (cb instanceof JdbcConnectionPool) {
            return "jcp";
        }
        if (cb instanceof JdbcResource) {
            return "jdbc";
        }
        return null;
    }

    public ConnectorDescriptor getConnectorDescriptorFromUri(String rarName, String raLoc) {
        try {
            String appName = rarName.substring(0, rarName.indexOf("#"));
            String appDeployLocation = ResourcesUtil.createInstance().getApplicationDeployLocation(appName);
            FileArchive in = ConnectorRuntime.getRuntime().getFileArchive();
            in.open(new URI(appDeployLocation));
            ApplicationArchivist archivist = ConnectorRuntime.getRuntime().getApplicationArchivist();
            Application application = archivist.open((ReadableArchive)in);
            return application.getRarDescriptorByUri(raLoc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

