/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.listener.PoolLifeCycleListener;
import com.sun.enterprise.resource.pool.monitor.JdbcConnPoolProbeProvider;

public class JdbcPoolEmitterImpl
implements PoolLifeCycleListener {
    private String poolName;
    private JdbcConnPoolProbeProvider jdbcConnPoolProbeProvider;

    public JdbcPoolEmitterImpl(String poolName) {
        this.poolName = poolName;
        this.jdbcConnPoolProbeProvider = ConnectorRuntime.getRuntime().getJdbcConnPoolProvider();
    }

    public void toString(StringBuffer stackTrace) {
        if (this.jdbcConnPoolProbeProvider != null) {
            stackTrace.append("\n Monitoring Statistics for \n" + this.poolName);
            this.jdbcConnPoolProbeProvider.toString(this.poolName, stackTrace);
        }
    }

    public void connectionAcquired() {
        if (this.jdbcConnPoolProbeProvider != null) {
            this.jdbcConnPoolProbeProvider.connectionAcquiredEvent(this.poolName);
        }
    }

    public void connectionRequestServed(long timeTakenInMillis) {
        if (this.jdbcConnPoolProbeProvider != null) {
            this.jdbcConnPoolProbeProvider.connectionRequestServedEvent(this.poolName, timeTakenInMillis);
        }
    }

    public void connectionTimedOut() {
        if (this.jdbcConnPoolProbeProvider != null) {
            this.jdbcConnPoolProbeProvider.connectionTimedOutEvent(this.poolName);
        }
    }

    public void connectionNotMatched() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void connectionMatched() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void connectionDestroyed() {
        if (this.jdbcConnPoolProbeProvider != null) {
            this.jdbcConnPoolProbeProvider.connectionDestroyedEvent(this.poolName);
        }
    }

    public void connectionReleased() {
        if (this.jdbcConnPoolProbeProvider != null) {
            this.jdbcConnPoolProbeProvider.connectionReleasedEvent(this.poolName);
        }
    }

    public void connectionCreated() {
        if (this.jdbcConnPoolProbeProvider != null) {
            this.jdbcConnPoolProbeProvider.connectionCreatedEvent(this.poolName);
        }
    }

    public void foundPotentialConnectionLeak() {
        if (this.jdbcConnPoolProbeProvider != null) {
            this.jdbcConnPoolProbeProvider.potentialConnLeakEvent(this.poolName);
        }
    }

    public void connectionValidationFailed(int count) {
        if (this.jdbcConnPoolProbeProvider != null) {
            this.jdbcConnPoolProbeProvider.connectionValidationFailedEvent(this.poolName, count);
        }
    }

    public void connectionUsed() {
        if (this.jdbcConnPoolProbeProvider != null) {
            this.jdbcConnPoolProbeProvider.connectionUsedEvent(this.poolName);
        }
    }

    public void connectionsFreed(int count) {
        if (this.jdbcConnPoolProbeProvider != null) {
            this.jdbcConnPoolProbeProvider.connectionsFreedEvent(this.poolName, count);
        }
    }

    public void decrementConnectionUsed(boolean beingDestroyed, int steadyPoolSize) {
        if (this.jdbcConnPoolProbeProvider != null) {
            this.jdbcConnPoolProbeProvider.decrementConnectionUsedEvent(this.poolName, beingDestroyed, steadyPoolSize);
        }
    }

    public void decrementFreeConnectionsSize(int steadyPoolSize) {
        if (this.jdbcConnPoolProbeProvider != null) {
            this.jdbcConnPoolProbeProvider.decrementFreeConnectionsSizeEvent(this.poolName, steadyPoolSize);
        }
    }
}

