/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.monitor.telemetry;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.resource.listener.PoolLifeCycle;
import com.sun.enterprise.resource.pool.JdbcPoolEmitterImpl;
import com.sun.enterprise.resource.pool.PoolLifeCycleListenerRegistry;
import com.sun.enterprise.resource.pool.PoolLifeCycleRegistry;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.resource.pool.monitor.telemetry.JDBCPoolTelemetry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.monitoring.TelemetryProvider;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.client.ProbeClientMediator;
import org.glassfish.flashlight.datatree.TreeNode;
import org.glassfish.flashlight.datatree.factory.TreeNodeFactory;
import org.glassfish.flashlight.provider.ProbeProviderEventManager;
import org.glassfish.flashlight.provider.ProbeProviderListener;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

@Service(name="jdbc-connection-pool")
@Scoped(value=Singleton.class)
public class JDBCPoolTelemetryBootstrap
implements ProbeProviderListener,
TelemetryProvider,
PostConstruct,
PoolLifeCycle {
    @Inject
    private ProbeProviderEventManager ppem;
    @Inject
    Logger logger;
    @Inject
    private static Domain domain;
    @Inject
    private MonitoringRuntimeDataRegistry mrdr;
    @Inject
    private ProbeClientMediator pcm;
    @Inject
    private PoolManager poolManager;
    private boolean poolProviderRegistered = false;
    private boolean probeProviderListenerRegistered = false;
    private boolean jdbcPoolMonitoringEnabled = false;
    private boolean isJdbcPoolTreeBuilt = false;
    private String monitoringLevel = null;
    private TreeNode serverNode;
    private TreeNode jdbcConnPoolNode = null;
    private List<JDBCPoolTelemetry> jdbcPoolTMs = null;

    public void providerRegistered(String moduleName, String providerName, String appName) {
        try {
            this.logger.finest("[Monitor]Provider registered event received - providerName = " + providerName + " : module name = " + moduleName + " : appName = " + appName);
            if (providerName.equals("jdbc-connection-pool")) {
                this.logger.finest("[Monitor]and it is Jdbc Connection Pool");
                this.registerPoolLifeCycleListener();
                if (!this.isJdbcPoolTreeBuilt) {
                    this.buildJdbcPoolMonitoringTree();
                }
                this.poolProviderRegistered = true;
                if (this.isJdbcPoolTreeBuilt || !this.jdbcPoolMonitoringEnabled) {
                    return;
                }
            }
        }
        catch (Exception e) {
            this.logger.warning("[Monitor]WARNING: Exception in JDBCMonitorStartup : " + e.getLocalizedMessage());
        }
    }

    public void providerUnregistered(String moduleName, String providerName, String appName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void onLevelChange(String newLevel) {
        boolean newLevelEnabledValue = this.getEnabledValue(newLevel);
        this.logger.finest("[Monitor] New monitoring level for connection pool received : " + newLevel);
        if (this.jdbcPoolMonitoringEnabled == newLevelEnabledValue) {
            return;
        }
        this.jdbcPoolMonitoringEnabled = newLevelEnabledValue;
        if (this.jdbcPoolMonitoringEnabled) {
            if (!this.probeProviderListenerRegistered) {
                this.registerProbeProviderListener();
            } else {
                this.enableJdbcConnPoolMonitoring(true, newLevel);
            }
        } else {
            this.enableJdbcConnPoolMonitoring(false, newLevel);
        }
        this.setMonitoringLevel(newLevel);
    }

    public void postConstruct() {
        Level dbgLevel = Level.FINEST;
        Level defaultLevel = this.logger.getLevel();
        if (defaultLevel == null || dbgLevel.intValue() < defaultLevel.intValue()) {
            // empty if block
        }
        this.logger.finest("[Monitor]In the JDBCPoolTelemetry bootstrap");
        this.buildTopLevelMonitoringTree();
    }

    private void buildJdbcPoolMonitoringTree() {
        if (!this.jdbcPoolMonitoringEnabled) {
            return;
        }
        this.logger.finest("[Monitor]Jdbc Connection Pool Monitoring tree is being built");
        try {
            this.jdbcConnPoolNode = TreeNodeFactory.createTreeNode((String)"resources", null, (String)"jdbc-connection-pool");
            this.serverNode.addChild(this.jdbcConnPoolNode);
            this.jdbcPoolTMs = new ArrayList<JDBCPoolTelemetry>();
            List resources = domain.getResources().getResources();
            for (Resource resource : resources) {
                if (!(resource instanceof JdbcConnectionPool)) continue;
                JdbcConnectionPool pool = (JdbcConnectionPool)resource;
                String poolName = pool.getName();
                this.addAndRegisterTelemetryObject(poolName);
            }
            this.serverNode.addChild(this.jdbcConnPoolNode);
            this.isJdbcPoolTreeBuilt = true;
        }
        catch (Exception e) {
            this.isJdbcPoolTreeBuilt = false;
            this.logger.warning("[Monitor]WARNING: Exception in buildJdbcPoolMonitoringTree : " + e.getLocalizedMessage());
        }
    }

    private boolean addAndRegisterTelemetryObject(String poolName) {
        boolean addedTelemetryObject = false;
        if (this.poolManager.getPool(poolName) != null) {
            JDBCPoolTelemetry jdbcPoolTM = new JDBCPoolTelemetry(this.jdbcConnPoolNode, poolName, this.logger, this.pcm);
            this.setProbeListenerHandles(jdbcPoolTM);
            jdbcPoolTM.enableMonitoring(this.jdbcPoolMonitoringEnabled);
            String jdbcPoolName = jdbcPoolTM.getJdbcPoolName();
            PoolLifeCycleListenerRegistry poolRegistry = new PoolLifeCycleListenerRegistry(jdbcPoolName);
            poolRegistry.registerPoolLifeCycleListener(new JdbcPoolEmitterImpl(jdbcPoolName));
            jdbcPoolTM.setPoolRegistry(poolRegistry);
            jdbcPoolTM.setMonitoringLevel(this.monitoringLevel);
            this.jdbcPoolTMs.add(jdbcPoolTM);
            addedTelemetryObject = true;
        }
        return addedTelemetryObject;
    }

    private void registerPoolLifeCycleListener() {
        PoolLifeCycleRegistry poolLifeCycleRegistry = PoolLifeCycleRegistry.getRegistry();
        List resources = domain.getResources().getResources();
        for (Resource resource : resources) {
            if (!(resource instanceof JdbcConnectionPool)) continue;
            JdbcConnectionPool pool = (JdbcConnectionPool)resource;
            String poolName = pool.getName();
            poolLifeCycleRegistry.registerPoolLifeCycle(poolName, this);
        }
    }

    private void removeAndUnregisterTelemetryObject(String poolName) {
        Iterator<JDBCPoolTelemetry> i = this.jdbcPoolTMs.iterator();
        while (i.hasNext()) {
            JDBCPoolTelemetry jdbcPoolTM = i.next();
            if (!poolName.equals(jdbcPoolTM.getJdbcPoolName())) continue;
            TreeNode poolNode = jdbcPoolTM.getJdbcPoolNode();
            this.removeProbeListenerHandles(jdbcPoolTM);
            PoolLifeCycleListenerRegistry poolRegistry = jdbcPoolTM.getPoolRegistry();
            poolRegistry.unRegisterPoolLifeCycleListener(poolName);
            i.remove();
            this.serverNode.removeChild(poolNode);
        }
    }

    private void buildTopLevelMonitoringTree() {
        if (this.serverNode != null) {
            return;
        }
        if (this.mrdr.get("server") != null) {
            this.serverNode = this.mrdr.get("server");
            return;
        }
        Server srvr = null;
        List ls = domain.getServers().getServer();
        for (Server sr : ls) {
            if (!"server".equals(sr.getName())) continue;
            srvr = sr;
            break;
        }
        this.serverNode = TreeNodeFactory.createTreeNode((String)"server", null, (String)"server");
        this.mrdr.add("server", this.serverNode);
    }

    private void enableJdbcConnPoolMonitoring(boolean isEnabled, String newLevel) {
        this.jdbcConnPoolNode.setEnabled(isEnabled);
        if (this.poolProviderRegistered && this.jdbcPoolTMs != null) {
            for (JDBCPoolTelemetry jdbcPoolTM : this.jdbcPoolTMs) {
                jdbcPoolTM.enableMonitoring(isEnabled);
                jdbcPoolTM.setMonitoringLevel(newLevel);
            }
        }
    }

    public boolean getEnabledValue(String strEnabled) {
        return !"OFF".equals(strEnabled);
    }

    private void registerProbeProviderListener() {
        this.ppem.registerProbeProviderListener((ProbeProviderListener)this);
        this.probeProviderListenerRegistered = true;
    }

    public static Domain getDomain() {
        return domain;
    }

    public void setProbeListenerHandles(JDBCPoolTelemetry jdbcPoolTM) {
        Collection handles = this.pcm.registerListener((Object)jdbcPoolTM);
        jdbcPoolTM.setProbeListenerHandles(handles);
    }

    public void setMonitoringLevel(String monitoringLevel) {
        this.logger.finest("Setting Monitoring level");
        if (this.poolProviderRegistered && this.jdbcPoolTMs != null) {
            for (JDBCPoolTelemetry jdbcPoolTM : this.jdbcPoolTMs) {
                jdbcPoolTM.setMonitoringLevel(monitoringLevel);
            }
        }
        this.monitoringLevel = monitoringLevel;
    }

    public void poolCreated(String poolName) {
        this.logger.finest("Pool created : " + poolName);
        if (this.addAndRegisterTelemetryObject(poolName)) {
            this.serverNode.addChild(this.jdbcConnPoolNode);
        }
    }

    public void poolDestroyed(String poolName) {
        this.logger.finest("Pool Destroyed : " + poolName);
        this.removeAndUnregisterTelemetryObject(poolName);
    }

    private void removeProbeListenerHandles(JDBCPoolTelemetry jdbcPoolTM) {
        jdbcPoolTM.removeProbeListenerHandles();
    }
}

