/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.enterprise.loader.EJBClassLoader;
import com.sun.logging.LogDomains;
import java.io.File;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectorClassLoader
extends EJBClassLoader {
    private static final Logger _logger = LogDomains.getLogger(ConnectorClassLoader.class, (String)"javax.enterprise.system.core");
    private static ConnectorClassLoader classLoader = null;
    private final List classLoaderChain = new LinkedList();
    private ClassLoader parent = null;
    private final Map rarModuleClassLoaders = new HashMap();

    public static synchronized ConnectorClassLoader getInstance() {
        if (classLoader == null) {
            classLoader = new ConnectorClassLoader();
        }
        return classLoader;
    }

    private ConnectorClassLoader() {
    }

    private ConnectorClassLoader(ClassLoader parent) {
        super(parent);
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConnectorClassLoader getInstance(ClassLoader parent) {
        if (classLoader != null) return classLoader;
        Class<ConnectorClassLoader> clazz = ConnectorClassLoader.class;
        synchronized (ConnectorClassLoader.class) {
            classLoader = new ConnectorClassLoader(parent);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return classLoader;
        }
    }

    public void addResourceAdapter(String rarName, String moduleDir) {
        try {
            File file = new File(moduleDir);
            EJBClassLoader cl = new EJBClassLoader(this.parent);
            cl.appendURL(file.toURI().toURL());
            this.appendJars(file, cl);
            this.classLoaderChain.add(cl);
            this.rarModuleClassLoaders.put(rarName, cl);
        }
        catch (MalformedURLException ex) {
            _logger.log(Level.SEVERE, "enterprise_util.connector_malformed_url", ex);
        }
    }

    private void appendJars(File moduleDir, EJBClassLoader cl) throws MalformedURLException {
        if (moduleDir.isDirectory()) {
            for (File file : moduleDir.listFiles()) {
                if (file.getName().toUpperCase().endsWith(".JAR")) {
                    cl.appendURL(file.toURI().toURL());
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.appendJars(file, cl);
            }
        }
    }

    public void removeResourceAdapter(String moduleName) {
        EJBClassLoader classLoaderToRemove = (EJBClassLoader)this.rarModuleClassLoaders.get(moduleName);
        if (classLoaderToRemove != null) {
            this.classLoaderChain.remove(classLoaderToRemove);
            this.rarModuleClassLoaders.remove(moduleName);
            classLoaderToRemove = null;
            _logger.log(Level.WARNING, "The Connector module " + moduleName + "  has been removed. Please redeploy all applications that " + "are using this connector module's resources");
        }
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class clz = null;
        if (this.parent != null) {
            try {
                clz = this.parent.loadClass(name);
                if (clz != null) {
                    if (resolve) {
                        this.resolveClass(clz);
                    }
                    return clz;
                }
            }
            catch (ClassNotFoundException e) {}
        } else {
            return super.loadClass(name, resolve);
        }
        for (EJBClassLoader ccl : this.classLoaderChain) {
            try {
                clz = ccl.loadClass(name);
                if (clz == null) continue;
                if (resolve) {
                    this.resolveClass(clz);
                }
                return clz;
            }
            catch (ClassNotFoundException cnfe) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    public String getClasspath() {
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < this.classLoaderChain.size(); ++i) {
            EJBClassLoader ecl = (EJBClassLoader)this.classLoaderChain.get(i);
            String eclClasspath = ecl.getClasspath();
            if (eclClasspath == null) continue;
            if (i > 0) {
                strBuf.append(File.pathSeparator);
            }
            strBuf.append(eclClasspath);
        }
        return strBuf.toString();
    }
}

