/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class DriverLoader
implements ConnectorConstants {
    private static Logger logger = LogDomains.getLogger(DriverLoader.class, (String)"javax.enterprise.resource.resourceadapter");
    private static final String DRIVER_INTERFACE_NAME = "java.sql.Driver";
    private static final String SERVICES_DRIVER_IMPL_NAME = "META-INF/services/java.sql.Driver";
    private static final String DATABASE_VENDOR_DERBY = "DERBY";
    private static final String DATABASE_VENDOR_JAVADB = "JAVADB";

    public Set<String> getJdbcDriverClassNames(String dbVendor, String resType) {
        Set<String> implClassNames = new TreeSet<String>();
        List<File> jarFileLocations = this.getJdbcDriverLocations();
        HashSet<File> allJars = new HashSet<File>();
        if (jarFileLocations != null) {
            for (File lib : jarFileLocations) {
                if (!lib.isDirectory()) continue;
                for (File file : lib.listFiles(new JarFileFilter())) {
                    allJars.add(file);
                }
            }
        }
        for (File file : allJars) {
            if (file.isFile() && !(implClassNames = dbVendor != null && dbVendor.equalsIgnoreCase(DATABASE_VENDOR_JAVADB) ? this.introspectAndLoadJar(file, resType, DATABASE_VENDOR_DERBY) : this.introspectAndLoadJar(file, resType, dbVendor)).isEmpty()) break;
        }
        return implClassNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getImplClassesByIteration(File f, String resType, String dbVendor) {
        TreeSet<String> implClassNames = new TreeSet<String>();
        String implClass = null;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(f);
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry zipEntry = e.nextElement();
                if (zipEntry == null) continue;
                String entry = zipEntry.getName();
                if (DRIVER_INTERFACE_NAME.equals(resType) && SERVICES_DRIVER_IMPL_NAME.equals(entry)) {
                    InputStream metaInf = jarFile.getInputStream(zipEntry);
                    implClass = this.processMetaInf(metaInf);
                    if (implClass != null && this.isLoaded(implClass, resType) && this.isVendorSpecific(f, dbVendor)) {
                        implClassNames.add(implClass);
                    }
                    logger.finest("Driver loader : implClass = " + implClass);
                }
                if (!entry.endsWith(".class") || !implClassNames.isEmpty() || entry.indexOf("DataSource") == -1 && entry.indexOf("Driver") == -1 || (implClass = this.getClassName(entry)) == null || !this.isLoaded(implClass, resType) || !this.isVendorSpecific(f, dbVendor)) continue;
                implClassNames.add(implClass);
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Error while getting Jdbc driver classnames ", ex);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ex) {
                    logger.log(Level.FINE, "Exception while closing JarFile '" + jarFile.getName() + "' :", ex);
                }
            }
        }
        return implClassNames;
    }

    private Set<String> introspectAndLoadJar(File f, String resType, String dbVendor) {
        logger.finest("DriverLoader : introspectAndLoadJar ");
        return this.getImplClassesByIteration(f, resType, dbVendor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processMetaInf(InputStream metaInf) {
        String driverClassName = null;
        InputStreamReader reader = null;
        BufferedReader buffReader = null;
        try {
            String line;
            reader = new InputStreamReader(metaInf);
            buffReader = new BufferedReader(reader);
            while ((line = buffReader.readLine()) != null) {
                driverClassName = line;
            }
        }
        catch (IOException ioex) {
            logger.finest("DriverLoader : exception while processing META-INF directory for DriverClassName " + ioex);
        }
        finally {
            try {
                if (buffReader != null) {
                    buffReader.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.FINE, "Error while closing File handles after reading META-INF files : ", ex);
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.FINE, "Error while closing File handles after reading META-INF files : ", ex);
            }
        }
        return driverClassName;
    }

    private boolean isLoaded(String classname, String resType) {
        Class cls = null;
        try {
            cls = ConnectorRuntime.getRuntime().getConnectorClassLoader().loadClass(classname);
        }
        catch (Exception ex) {
            cls = null;
        }
        catch (Throwable t) {
            cls = null;
        }
        return this.isResType(cls, resType);
    }

    private boolean isResType(Class cls, String resType) {
        Class<?>[] interfaces;
        boolean isResType = false;
        if (cls != null && (interfaces = cls.getInterfaces()).length != 0) {
            for (int n = 0; n < interfaces.length; ++n) {
                String i = interfaces[n].getName();
                if (!resType.equals(i)) continue;
                isResType = true;
                break;
            }
        }
        return isResType;
    }

    private String getClassName(String classname) {
        classname = classname.replaceAll("/", ".");
        classname = classname.substring(0, classname.lastIndexOf(".class"));
        return classname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isVendorSpecific(File f, String dbVendor) {
        boolean isVendorSpecific = false;
        String vendor = null;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(f);
            Manifest manifest = jarFile.getManifest();
            Attributes mainAttributes = manifest.getMainAttributes();
            vendor = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR.toString());
            if (vendor == null) {
                vendor = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR_ID.toString());
            }
            if (vendor == null) {
                if (this.isVendorSpecificByIteration(dbVendor, f)) {
                    isVendorSpecific = true;
                }
            } else if (vendor.equalsIgnoreCase(dbVendor) || vendor.toUpperCase().indexOf(dbVendor.toUpperCase()) != -1) {
                isVendorSpecific = true;
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Exception while reading manifest file : ", ex);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ex) {
                    logger.log(Level.FINE, "Exception while closing JarFile '" + jarFile.getName() + "' :", ex);
                }
            }
        }
        return isVendorSpecific;
    }

    private List<File> getJdbcDriverLocations() {
        ArrayList<File> jarFileLocations = new ArrayList<File>();
        jarFileLocations.add(this.getLocation("com.sun.aas.derbyRoot"));
        jarFileLocations.add(this.getLocation("com.sun.aas.installRoot"));
        jarFileLocations.add(this.getLocation("com.sun.aas.instanceRoot"));
        return jarFileLocations;
    }

    private File getLocation(String property) {
        return new File(System.getProperty(property) + File.separator + "lib");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isVendorSpecificByIteration(String dbVendor, File f) {
        JarFile jarFile = null;
        boolean isVendorSpecific = false;
        try {
            jarFile = new JarFile(f);
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                String classname;
                ZipEntry entry = e.nextElement();
                if (entry == null || !(classname = entry.getName()).endsWith(".class") || classname.toUpperCase().indexOf(dbVendor.toUpperCase()) == -1) continue;
                isVendorSpecific = true;
                break;
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Exception while introspecting jdbc jar file for driver/datasource classname introspection : ", ex);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ex) {
                    logger.log(Level.FINE, "Exception while closing JarFile '" + jarFile.getName() + "' :", ex);
                }
            }
        }
        return isVendorSpecific;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isVendorSpecificByManifest(File f, String dbVendor) {
        boolean isVendorSpecific = false;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(f);
            Manifest manifest = jarFile.getManifest();
            Attributes mainAttributes = manifest.getMainAttributes();
            String implVendor = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION.toString());
            if (implVendor != null && implVendor.toUpperCase().indexOf(dbVendor.toUpperCase()) != -1) {
                isVendorSpecific = true;
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Exception while reading manifest file : ", ex);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ex) {
                    logger.log(Level.FINE, "Exception while closing JarFile '" + jarFile.getName() + "' :", ex);
                }
            }
        }
        return isVendorSpecific;
    }

    private static class JarFileFilter
    implements FilenameFilter {
        private final String JAR_EXT = ".jar";

        private JarFileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }
}

