/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.AdminObjectConfigParser;
import com.sun.enterprise.deployment.AdminObject;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AdminObjectConfigParserImpl
implements AdminObjectConfigParser {
    static Logger _logger = LogDomains.getLogger(ConnectorRuntime.class, (String)"javax.enterprise.resource.resourceadapter");

    public Properties getJavaBeanProps(ConnectorDescriptor desc, String adminObjectInterface, String rarName) throws ConnectorRuntimeException {
        if (desc == null || adminObjectInterface == null) {
            throw new ConnectorRuntimeException("Invalid arguments");
        }
        Set adminObjectSet = desc.getAdminObjects();
        if (adminObjectSet == null || adminObjectSet.size() == 0) {
            return null;
        }
        AdminObject adminObject = null;
        Iterator iter = adminObjectSet.iterator();
        Properties mergedVals = null;
        boolean adminInterfaceFound = false;
        while (iter.hasNext()) {
            adminObject = (AdminObject)iter.next();
            if (!adminObjectInterface.equals(adminObject.getAdminObjectInterface())) continue;
            adminInterfaceFound = true;
            break;
        }
        if (!adminInterfaceFound) {
            StringManager localStrings = StringManager.getManager(AdminObjectConfigParserImpl.class);
            String msg = localStrings.getString("no_adminobject_interface_found_in_raxml", (Object)adminObjectInterface);
            _logger.log(Level.FINE, msg);
            throw new ConnectorRuntimeException(msg);
        }
        Set ddVals = adminObject.getConfigProperties();
        String className = adminObject.getAdminObjectClass();
        if (className != null && className.length() != 0) {
            Properties introspectedVals = configParserUtil.introspectJavaBean(className, ddVals);
            mergedVals = configParserUtil.mergeProps(ddVals, introspectedVals);
        }
        return mergedVals;
    }

    public String[] getAdminObjectInterfaceNames(ConnectorDescriptor desc) throws ConnectorRuntimeException {
        if (desc == null) {
            throw new ConnectorRuntimeException("Invalid arguments");
        }
        Set adminObjectSet = desc.getAdminObjects();
        if (adminObjectSet == null || adminObjectSet.size() == 0) {
            return null;
        }
        String[] adminObjectInterfaceNames = new String[adminObjectSet.size()];
        Iterator it = adminObjectSet.iterator();
        AdminObject aor = null;
        int i = 0;
        while (it.hasNext()) {
            aor = (AdminObject)it.next();
            adminObjectInterfaceNames[i] = aor.getAdminObjectInterface();
            ++i;
        }
        return adminObjectInterfaceNames;
    }

    public String[] getAdminObjectClassNames(ConnectorDescriptor desc, String intfName) throws ConnectorRuntimeException {
        if (desc == null) {
            throw new ConnectorRuntimeException("Invalid arguments");
        }
        Set adminObjectSet = desc.getAdminObjects();
        if (adminObjectSet == null || adminObjectSet.size() == 0) {
            return null;
        }
        String[] adminObjectClassNames = new String[adminObjectSet.size()];
        Iterator it = adminObjectSet.iterator();
        AdminObject aor = null;
        HashSet<String> adminObjectClasses = new HashSet<String>();
        int i = 0;
        while (it.hasNext()) {
            aor = (AdminObject)it.next();
            String adminObjectIntfName = aor.getAdminObjectInterface();
            if (adminObjectIntfName.equals(intfName)) {
                adminObjectClasses.add(aor.getAdminObjectClass());
            }
            ++i;
        }
        adminObjectClassNames = adminObjectClasses.toArray(adminObjectClassNames);
        return adminObjectClassNames;
    }

    public boolean hasAdminObject(ConnectorDescriptor desc, String intfName, String className) throws ConnectorRuntimeException {
        if (desc == null || intfName == null || className == null) {
            throw new ConnectorRuntimeException("Invalid arguments");
        }
        Set adminObjectSet = desc.getAdminObjects();
        if (adminObjectSet == null || adminObjectSet.size() == 0) {
            return false;
        }
        Iterator it = adminObjectSet.iterator();
        AdminObject aor = null;
        int i = 0;
        while (it.hasNext()) {
            aor = (AdminObject)it.next();
            if (aor.getAdminObjectInterface().equals(intfName) && aor.getAdminObjectClass().equals(className)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

