/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.monitor;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolProbeProvider;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolStatsProviderBootstrap;
import com.sun.enterprise.resource.pool.monitor.ConnectorConnPoolProbeProvider;
import com.sun.enterprise.resource.pool.monitor.JdbcConnPoolProbeProvider;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

@Service
public class ConnectionPoolProbeProviderUtil {
    private ConnectionPoolProbeProvider jcaProbeProvider = null;
    private ConnectionPoolProbeProvider jdbcProbeProvider = null;
    private Logger _logger = LogDomains.getLogger(ConnectionPoolProbeProviderUtil.class, (String)"javax.enterprise.resource.resourceadapter");
    @Inject
    private Habitat habitat;

    public void registerProbeProvider() {
        if (ConnectorRuntime.getRuntime().isServer()) {
            this.getConnPoolBootstrap().registerProvider();
        }
    }

    public void createJcaProbeProvider() {
        try {
            this.jcaProbeProvider = new ConnectorConnPoolProbeProvider();
            if (this.jcaProbeProvider == null) {
                this._logger.log(Level.WARNING, "Unable to create probe provider for interface " + ConnectorConnPoolProbeProvider.class.getName() + ", using no-op provider");
            }
        }
        catch (Exception e) {
            this._logger.log(Level.SEVERE, "Unable to create probe provider for interface " + ConnectorConnPoolProbeProvider.class.getName() + ", using no-op provider", e);
        }
    }

    public void createJdbcProbeProvider() {
        try {
            this.jdbcProbeProvider = new JdbcConnPoolProbeProvider();
            if (this.jdbcProbeProvider == null) {
                this._logger.log(Level.WARNING, "Unable to create probe provider for interface " + JdbcConnPoolProbeProvider.class.getName() + ", using no-op provider");
            }
        }
        catch (Exception e) {
            this._logger.log(Level.SEVERE, "Unable to create probe provider for interface " + JdbcConnPoolProbeProvider.class.getName() + ", using no-op provider", e);
        }
    }

    private ConnectionPoolStatsProviderBootstrap getConnPoolBootstrap() {
        return (ConnectionPoolStatsProviderBootstrap)this.habitat.getComponent(ConnectionPoolStatsProviderBootstrap.class);
    }

    public ConnectionPoolProbeProvider getJcaProbeProvider() {
        return this.jcaProbeProvider;
    }

    public ConnectionPoolProbeProvider getJdbcProbeProvider() {
        return this.jdbcProbeProvider;
    }
}

