/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.pool.AssocWithThreadResourcePool;
import com.sun.enterprise.resource.pool.ConnectionPool;
import com.sun.enterprise.resource.pool.ResourcePool;
import com.sun.enterprise.resource.pool.UnpooledResource;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourcePoolFactoryImpl {
    private static final String SWITCH_OFF_ACC_CONNECTION_POOLING = "com.sun.enterprise.connectors.SwitchoffACCConnectionPooling";
    private static String switchOffACCConnectionPoolingProperty = System.getProperty("com.sun.enterprise.connectors.SwitchoffACCConnectionPooling");
    private static Logger _logger = LogDomains.getLogger(ResourcePoolFactoryImpl.class, (String)"javax.enterprise.resource.resourceadapter");

    public static ResourcePool newInstance(String poolName, ConnectorConstants.PoolType pt, Hashtable env) throws PoolingException {
        if (ConnectorRuntime.getRuntime().isAppClientRuntime() && "TRUE".equalsIgnoreCase(switchOffACCConnectionPoolingProperty)) {
            return new UnpooledResource(poolName, env);
        }
        ConnectionPool pool = null;
        if (pt == ConnectorConstants.PoolType.POOLING_DISABLED) {
            return new UnpooledResource(poolName, env);
        }
        pool = pt == ConnectorConstants.PoolType.ASSOCIATE_WITH_THREAD_POOL ? new AssocWithThreadResourcePool(poolName, env) : new ConnectionPool(poolName, env);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Created a pool of type : " + pt);
        }
        return pool;
    }
}

