/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.WorkContextHandler;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkContext;
import javax.resource.spi.work.WorkManager;
import javax.transaction.TransactionSynchronizationRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BootstrapContextImpl
implements BootstrapContext,
Serializable {
    private String poolId;
    private WorkManager wm;
    private XATerminator xa;
    private String moduleName;
    private String threadPoolId;
    private ClassLoader rarCL;
    private static final Logger logger = LogDomains.getLogger(BootstrapContextImpl.class, (String)"javax.enterprise.resource.resourceadapter");

    public BootstrapContextImpl(String moduleName) throws ConnectorRuntimeException {
        this.moduleName = moduleName;
        this.initializeWorkManager();
    }

    public BootstrapContextImpl(String poolId, String moduleName, ClassLoader rarCL) throws ConnectorRuntimeException {
        this.threadPoolId = poolId;
        this.moduleName = moduleName;
        this.rarCL = rarCL;
        this.initializeWorkManager();
    }

    public Timer createTimer() {
        return new Timer("connectors-runtime-context");
    }

    public boolean isContextSupported(Class<? extends WorkContext> aClass) {
        WorkContextHandler wch = ConnectorRuntime.getRuntime().getWorkContextHandler();
        wch.init(this.moduleName, this.rarCL);
        return wch.isContextSupported(true, aClass.getName());
    }

    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        try {
            InitialContext ic = new InitialContext();
            return (TransactionSynchronizationRegistry)ic.lookup("java:comp/TransactionSynchronizationRegistry");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "tx.sync.registry.lookup.failed", e);
            return null;
        }
    }

    public WorkManager getWorkManager() {
        this.initializeWorkManager();
        return this.wm;
    }

    private void initializeWorkManager() {
        if (this.wm == null) {
            try {
                this.wm = ConnectorRuntime.getRuntime().getWorkManagerProxy(this.threadPoolId, this.moduleName, this.rarCL);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "workmanager.instantiation_error", e);
            }
        }
    }

    public XATerminator getXATerminator() {
        this.initializeXATerminator();
        return this.xa;
    }

    private void initializeXATerminator() {
        if (this.xa == null) {
            this.xa = ConnectorRuntime.getRuntime().getXATerminatorProxy(this.moduleName);
        }
    }
}

