/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.monitor;

import com.sun.enterprise.resource.listener.PoolLifeCycleListener;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolProbeProvider;

public class ConnectionPoolEmitterImpl
implements PoolLifeCycleListener {
    private String poolName;
    private ConnectionPoolProbeProvider poolProbeProvider;

    public ConnectionPoolEmitterImpl(String poolName, ConnectionPoolProbeProvider provider) {
        this.poolName = poolName;
        this.poolProbeProvider = provider;
    }

    public void toString(StringBuffer stackTrace) {
        stackTrace.append("\n Monitoring Statistics for \n" + this.poolName);
        this.poolProbeProvider.toString(this.poolName, stackTrace);
    }

    public void connectionAcquired() {
        this.poolProbeProvider.connectionAcquiredEvent(this.poolName);
    }

    public void connectionRequestServed(long timeTakenInMillis) {
        this.poolProbeProvider.connectionRequestServedEvent(this.poolName, timeTakenInMillis);
    }

    public void connectionTimedOut() {
        this.poolProbeProvider.connectionTimedOutEvent(this.poolName);
    }

    public void connectionNotMatched() {
        this.poolProbeProvider.connectionNotMatchedEvent(this.poolName);
    }

    public void connectionMatched() {
        this.poolProbeProvider.connectionMatchedEvent(this.poolName);
    }

    public void connectionDestroyed() {
        this.poolProbeProvider.connectionDestroyedEvent(this.poolName);
    }

    public void connectionReleased() {
        this.poolProbeProvider.connectionReleasedEvent(this.poolName);
    }

    public void connectionCreated() {
        this.poolProbeProvider.connectionCreatedEvent(this.poolName);
    }

    public void foundPotentialConnectionLeak() {
        this.poolProbeProvider.potentialConnLeakEvent(this.poolName);
    }

    public void connectionValidationFailed(int count) {
        this.poolProbeProvider.connectionValidationFailedEvent(this.poolName, count);
    }

    public void connectionUsed() {
        this.poolProbeProvider.connectionUsedEvent(this.poolName);
    }

    public void connectionsFreed(int count) {
        this.poolProbeProvider.connectionsFreedEvent(this.poolName, count);
    }

    public void decrementConnectionUsed() {
        this.poolProbeProvider.decrementConnectionUsedEvent(this.poolName);
    }

    public void decrementNumConnFree() {
        this.poolProbeProvider.decrementNumConnFreeEvent(this.poolName);
    }

    public void incrementNumConnFree(boolean beingDestroyed, int steadyPoolSize) {
        this.poolProbeProvider.incrementNumConnFreeEvent(this.poolName, beingDestroyed, steadyPoolSize);
    }

    public void connectionRequestQueued() {
        this.poolProbeProvider.connectionRequestQueuedEvent(this.poolName);
    }

    public void connectionRequestDequeued() {
        this.poolProbeProvider.connectionRequestDequeuedEvent(this.poolName);
    }
}

