/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.resizer;

import com.sun.enterprise.resource.AssocWithThreadResourceHandle;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceState;
import com.sun.enterprise.resource.pool.PoolProperties;
import com.sun.enterprise.resource.pool.ResourceHandler;
import com.sun.enterprise.resource.pool.datastructure.DataStructure;
import com.sun.enterprise.resource.pool.resizer.Resizer;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.resource.ResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssocWithThreadPoolResizer
extends Resizer {
    public AssocWithThreadPoolResizer(String poolName, DataStructure ds, PoolProperties pp, ResourceHandler handler, boolean preferValidateOverRecreate) {
        super(poolName, ds, pp, handler, preferValidateOverRecreate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void scaleDownPool(int scaleDownQuantity, boolean forced) {
        if (this.pool.getResizeQuantity() > 0 && forced) {
            scaleDownQuantity = scaleDownQuantity <= this.ds.getResourcesSize() - this.pool.getSteadyPoolSize() ? scaleDownQuantity : 0;
            AssocWithThreadPoolResizer.debug("Scaling down pool by quantity : " + scaleDownQuantity);
            HashSet<ResourceHandle> resourcesToRemove = new HashSet<ResourceHandle>();
            try {
                for (ResourceHandle h : this.ds.getAllResources()) {
                    if (scaleDownQuantity <= 0) continue;
                    Object object = h.lock;
                    synchronized (object) {
                        if (!h.isBusy()) {
                            resourcesToRemove.add(h);
                            ((AssocWithThreadResourceHandle)h).setDirty();
                            --scaleDownQuantity;
                        }
                    }
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                for (ResourceHandle resourceToRemove : resourcesToRemove) {
                    if (!this.ds.getAllResources().contains(resourceToRemove)) continue;
                    this.ds.removeResource(resourceToRemove);
                }
                throw throwable;
            }
            for (ResourceHandle resourceToRemove : resourcesToRemove) {
                if (!this.ds.getAllResources().contains(resourceToRemove)) continue;
                this.ds.removeResource(resourceToRemove);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int removeIdleAndInvalidResources() {
        int poolSizeBeforeRemoval = this.ds.getResourcesSize();
        int noOfResourcesRemoved = 0;
        long currentTime = System.currentTimeMillis();
        int validConnectionsCounter = 0;
        int idleConnKeptInSteadyCounter = 0;
        HashSet<ResourceHandle> resourcesToValidate = new HashSet<ResourceHandle>();
        HashSet<ResourceHandle> resourcesToRemove = new HashSet<ResourceHandle>();
        try {
            for (ResourceHandle h : this.ds.getAllResources()) {
                Object object = h.lock;
                synchronized (object) {
                    ResourceState state = h.getResourceState();
                    if (!state.isBusy()) {
                        if (currentTime - state.getTimestamp() < this.pool.getIdleTimeout()) {
                            if (state.isUnenlisted() && state.isFree() && ((AssocWithThreadResourceHandle)h).isAssociated()) {
                                ((AssocWithThreadResourceHandle)h).setAssociated(false);
                                ++validConnectionsCounter;
                                resourcesToValidate.add(h);
                            }
                        } else {
                            boolean isResourceEligibleForRemoval = this.isResourceEligibleForRemoval(h, validConnectionsCounter);
                            if (!isResourceEligibleForRemoval) {
                                ++idleConnKeptInSteadyCounter;
                                AssocWithThreadPoolResizer.debug("PreferValidateOverRecreate: Keeping idle resource " + h + " in the steady part of the free pool " + "as the RA reports it to be valid (" + ++validConnectionsCounter + " <= " + this.pool.getSteadyPoolSize() + ")");
                            } else {
                                resourcesToRemove.add(h);
                                ((AssocWithThreadResourceHandle)h).setDirty();
                            }
                        }
                    }
                }
            }
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            for (ResourceHandle resourceToRemove : resourcesToRemove) {
                if (!this.ds.getAllResources().contains(resourceToRemove)) continue;
                this.ds.removeResource(resourceToRemove);
            }
            throw throwable;
        }
        for (ResourceHandle resourceToRemove : resourcesToRemove) {
            if (!this.ds.getAllResources().contains(resourceToRemove)) continue;
            this.ds.removeResource(resourceToRemove);
        }
        int noOfInvalidResources = this.removeInvalidResources(resourcesToValidate);
        if (this.preferValidateOverRecreate) {
            AssocWithThreadPoolResizer.debug("Idle resources validated and kept in the steady pool for pool [ " + this.poolName + " ] - " + idleConnKeptInSteadyCounter);
            AssocWithThreadPoolResizer.debug("Number of Idle resources freed for pool [ " + this.poolName + " ] - " + resourcesToRemove.size());
            AssocWithThreadPoolResizer.debug("Number of Invalid resources removed for pool [ " + this.poolName + " ] - " + noOfInvalidResources);
        } else {
            AssocWithThreadPoolResizer.debug("Number of Idle resources freed for pool [ " + this.poolName + " ] - " + resourcesToRemove.size());
            AssocWithThreadPoolResizer.debug("Number of Invalid resources removed for pool [ " + this.poolName + " ] - " + noOfInvalidResources);
        }
        noOfResourcesRemoved = poolSizeBeforeRemoval - this.ds.getResourcesSize();
        return noOfResourcesRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeInvalidResources(Set<ResourceHandle> freeConnectionsToValidate) {
        int invalidConnectionsCount = 0;
        try {
            AssocWithThreadPoolResizer.debug("Sending a set of free connections to RA, of size : " + freeConnectionsToValidate.size());
            try {
                for (ResourceHandle handle : freeConnectionsToValidate) {
                    if (handle == null) continue;
                    HashSet<Object> connectionsToTest = new HashSet<Object>();
                    connectionsToTest.add(handle.getResource());
                    Set invalidConnections = this.handler.getInvalidConnections(connectionsToTest);
                    if (invalidConnections == null || invalidConnections.size() <= 0) continue;
                    invalidConnectionsCount = this.validateAndRemoveResource(handle, invalidConnections);
                }
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                AssocWithThreadPoolResizer.debug("No. of invalid connections received from RA : " + invalidConnectionsCount);
                throw throwable;
            }
            AssocWithThreadPoolResizer.debug("No. of invalid connections received from RA : " + invalidConnectionsCount);
            {
            }
        }
        catch (ResourceException re) {
            _logger.log(Level.FINE, "ResourceException while trying to get invalid connections from MCF", re);
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Exception while trying to get invalid connections from MCF", e);
        }
        return invalidConnectionsCount;
    }
}

