/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.appserv.connectors.internal.spi.MCFLifecycleListener;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.enterprise.resource.listener.PoolLifeCycle;
import com.sun.enterprise.resource.pool.AbstractPoolManager;
import com.sun.enterprise.resource.pool.PoolStatus;
import com.sun.enterprise.resource.pool.ResourcePool;
import com.sun.enterprise.resource.pool.ResourcePoolFactoryImpl;
import com.sun.enterprise.resource.rm.LazyEnlistableResourceManagerImpl;
import com.sun.enterprise.resource.rm.NoTxResourceManagerImpl;
import com.sun.enterprise.resource.rm.ResourceManager;
import com.sun.enterprise.resource.rm.ResourceManagerImpl;
import com.sun.enterprise.resource.rm.SystemResourceManagerImpl;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.ComponentInvocationHandler;
import org.glassfish.api.invocation.InvocationException;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

@Service
public class PoolManagerImpl
extends AbstractPoolManager
implements ComponentInvocationHandler {
    private ConcurrentHashMap<String, ResourcePool> poolTable = new ConcurrentHashMap();
    private ResourceManager resourceManager = new ResourceManagerImpl();
    private ResourceManager sysResourceManager = new SystemResourceManagerImpl();
    private ResourceManager noTxResourceManager = new NoTxResourceManagerImpl();
    private LazyEnlistableResourceManagerImpl lazyEnlistableResourceManager = new LazyEnlistableResourceManagerImpl();
    private static Logger _logger = null;
    @Inject
    private Habitat connectorRuntimeHabitat;
    private ConnectorRuntime runtime;
    private PoolLifeCycle listener;

    public void createEmptyConnectionPool(String poolName, ConnectorConstants.PoolType pt, Hashtable env) throws PoolingException {
        ManagedConnectionFactory mcf;
        this.createAndInitPool(poolName, pt, env);
        if (this.listener != null) {
            try {
                this.listener.poolCreated(poolName);
            }
            catch (Exception ex) {
                _logger.log(Level.FINE, "Exception thrown on pool listener");
            }
        }
        if ((mcf = ConnectorRegistry.getInstance().getManagedConnectionFactory(poolName)) != null && mcf instanceof MCFLifecycleListener) {
            ((MCFLifecycleListener)mcf).mcfCreated();
        }
    }

    private ResourcePool createAndInitPool(String poolName, ConnectorConstants.PoolType pt, Hashtable env) throws PoolingException {
        ResourcePool pool = this.getPool(poolName);
        if (pool == null) {
            pool = ResourcePoolFactoryImpl.newInstance(poolName, pt, env);
            this.addPool(pool);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Created connection  pool  and added it to PoolManager :" + pool);
            }
        }
        return pool;
    }

    public Object getResource(ResourceSpec spec, ResourceAllocator alloc, ClientSecurityInfo info) throws PoolingException {
        ResourceHandle handle;
        Transaction tran = null;
        boolean transactional = alloc.isTransactional();
        if (transactional) {
            tran = this.getResourceManager(spec).getTransaction();
        }
        if (!(handle = this.getResourceFromPool(spec, alloc, info, tran)).supportsLazyAssociation()) {
            spec.setLazyAssociatable(false);
        }
        if (spec.isLazyAssociatable() && spec.getConnectionToAssociate() != null) {
            try {
                Object connection = spec.getConnectionToAssociate();
                ManagedConnection dmc = (ManagedConnection)handle.getResource();
                dmc.associateConnection(connection);
            }
            catch (ResourceException e) {
                this.putbackDirectToPool(handle, spec.getConnectionPoolName());
                PoolingException pe = new PoolingException(e.getMessage());
                pe.initCause((Throwable)e);
                throw pe;
            }
        }
        if (!handle.supportsLazyEnlistment()) {
            spec.setLazyEnlistable(false);
        }
        handle.setResourceSpec(spec);
        try {
            if (handle.getResourceState().isUnenlisted()) {
                this.getResourceManager(spec).enlistResource(handle);
            }
        }
        catch (Exception e) {
            this.putbackDirectToPool(handle, spec.getConnectionPoolName());
            _logger.log(Level.WARNING, "poolmgr.err_enlisting_res_in_getconn", spec.getConnectionPoolName());
            this.logFine("rm.enlistResource threw Exception. Returning resource to pool");
            throw new PoolingException(e);
        }
        return handle.getUserConnection();
    }

    public void putbackDirectToPool(ResourceHandle h, String poolName) {
        ResourcePool pool;
        if (poolName != null && (pool = this.poolTable.get(poolName)) != null) {
            pool.resourceClosed(h);
        }
    }

    public ResourceHandle getResourceFromPool(ResourceSpec spec, ResourceAllocator alloc, ClientSecurityInfo info, Transaction tran) throws PoolingException {
        ResourcePool pool = this.getPool(spec.getConnectionPoolName());
        return pool.getResource(spec, alloc, tran);
    }

    public boolean switchOnMatching(String poolName) {
        ResourcePool pool = (ResourcePool)this.getPoolTable().get(poolName);
        if (pool != null) {
            pool.switchOnMatching();
            return true;
        }
        return false;
    }

    public ConcurrentHashMap getPoolTable() {
        return this.poolTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPool(ResourcePool pool) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Adding pool " + pool.getPoolName() + "to pooltable");
        }
        ConcurrentHashMap<String, ResourcePool> concurrentHashMap = this.poolTable;
        synchronized (concurrentHashMap) {
            this.poolTable.put(pool.getPoolName(), pool);
        }
    }

    private ResourceManager getResourceManager(ResourceSpec spec) {
        if (spec.isNonTx()) {
            this.logFine("Returning noTxResourceManager");
            return this.noTxResourceManager;
        }
        if (spec.isPM()) {
            this.logFine("Returning sysResourceManager");
            return this.sysResourceManager;
        }
        if (spec.isLazyEnlistable()) {
            this.logFine("Returning LazyEnlistableResourceManager");
            return this.lazyEnlistableResourceManager;
        }
        this.logFine("Returning resourceManager");
        return this.resourceManager;
    }

    private void addSyncListener(Transaction tran) {
        SynchronizationListener sync = new SynchronizationListener(tran);
        try {
            tran.registerSynchronization((Synchronization)sync);
        }
        catch (Exception ex) {
            _logger.fine("Error adding syncListener : " + (ex.getMessage() != null ? ex.getMessage() : " "));
        }
    }

    public void transactionCompleted(Transaction tran, int status) throws IllegalStateException {
        Iterator iter = ((JavaEETransaction)tran).getAllParticipatingPools().iterator();
        while (iter.hasNext()) {
            ResourcePool pool = this.getPool((String)iter.next());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("calling transactionCompleted on " + pool.getPoolName());
            }
            pool.transactionCompleted(tran, status);
        }
    }

    public void resourceEnlisted(Transaction tran, com.sun.appserv.connectors.internal.api.ResourceHandle h) throws IllegalStateException {
        ResourcePool pool;
        ResourceHandle res = (ResourceHandle)h;
        String poolName = res.getResourceSpec().getConnectionPoolName();
        try {
            JavaEETransaction j2eeTran = (JavaEETransaction)tran;
            if (poolName != null && j2eeTran.getResources(poolName) == null) {
                this.addSyncListener(tran);
            }
        }
        catch (ClassCastException e) {
            this.addSyncListener(tran);
        }
        if (poolName != null && (pool = this.getPool(poolName)) != null) {
            pool.resourceEnlisted(tran, res);
        }
    }

    public void lazyEnlist(ManagedConnection mc) throws ResourceException {
        this.lazyEnlistableResourceManager.lazyEnlist(mc);
    }

    private ConnectorRuntime getConnectorRuntime() {
        if (this.runtime == null) {
            this.runtime = (ConnectorRuntime)this.connectorRuntimeHabitat.getComponent(ConnectorRuntime.class, null);
        }
        return this.runtime;
    }

    public void registerResource(com.sun.appserv.connectors.internal.api.ResourceHandle handle) throws PoolingException {
        ResourceHandle h = (ResourceHandle)handle;
        ResourceManager rm = this.getResourceManager(h.getResourceSpec());
        rm.registerResource(h);
    }

    public void registerPoolLifeCycleListener(PoolLifeCycle poolListener) {
        this.listener = poolListener;
    }

    public void unregisterPoolLifeCycleListener() {
        this.listener = null;
    }

    public void unregisterResource(com.sun.appserv.connectors.internal.api.ResourceHandle resource, int xaresFlag) {
        ResourceHandle h = (ResourceHandle)resource;
        ResourceManager rm = this.getResourceManager(h.getResourceSpec());
        rm.unregisterResource(h, xaresFlag);
    }

    public void resourceClosed(ResourceHandle resource) {
        ResourceManager rm = this.getResourceManager(resource.getResourceSpec());
        rm.delistResource(resource, 0x4000000);
        this.putbackResourceToPool(resource, false);
    }

    public void badResourceClosed(ResourceHandle resource) {
        ResourceManager rm = this.getResourceManager(resource.getResourceSpec());
        rm.delistResource(resource, 0x4000000);
        this.putbackBadResourceToPool(resource);
    }

    public void resourceErrorOccurred(ResourceHandle resource) {
        this.putbackResourceToPool(resource, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putbackBadResourceToPool(ResourceHandle h) {
        ResourcePool pool;
        String poolName = h.getResourceSpec().getConnectionPoolName();
        if (poolName != null && (pool = this.poolTable.get(poolName)) != null) {
            ResourcePool resourcePool = pool;
            synchronized (resourcePool) {
                pool.resourceClosed(h);
                h.setConnectionErrorOccurred();
                pool.resourceErrorOccurred(h);
            }
        }
    }

    public void putbackResourceToPool(ResourceHandle h, boolean errorOccurred) {
        ResourcePool pool;
        String poolName = h.getResourceSpec().getConnectionPoolName();
        if (poolName != null && (pool = this.poolTable.get(poolName)) != null) {
            if (errorOccurred) {
                pool.resourceErrorOccurred(h);
            } else {
                pool.resourceClosed(h);
            }
        }
    }

    private void logFine(String msg) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(msg);
        }
    }

    public ResourcePool getPool(String name) {
        if (name == null) {
            return null;
        }
        return this.poolTable.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killPool(String poolName) {
        ResourcePool pool = this.poolTable.get(poolName);
        if (pool != null) {
            ManagedConnectionFactory mcf;
            pool.cancelResizerTask();
            pool.emptyPool();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Removing pool " + pool + " from pooltable");
            }
            ConcurrentHashMap<String, ResourcePool> concurrentHashMap = this.poolTable;
            synchronized (concurrentHashMap) {
                this.poolTable.remove(poolName);
            }
            if (this.listener != null) {
                this.listener.poolDestroyed(poolName);
            }
            if ((mcf = ConnectorRegistry.getInstance().getManagedConnectionFactory(poolName)) != null && mcf instanceof MCFLifecycleListener) {
                ((MCFLifecycleListener)mcf).mcfDestroyed();
            }
        }
    }

    public void killFreeConnectionsInPools() {
        Iterator<ResourcePool> pools = this.poolTable.values().iterator();
        this.logFine("Killing all free connections in pools");
        while (pools.hasNext()) {
            ResourcePool pool = pools.next();
            if (pool == null) continue;
            String name = pool.getPoolName();
            try {
                if (name == null) continue;
                ResourcePool poolToKill = this.poolTable.get(name);
                if (poolToKill != null) {
                    pool.emptyFreeConnectionsInPool();
                }
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.fine("Now killing free connections in pool : " + name);
            }
            catch (Exception e) {
                _logger.fine("Error killing pool : " + name + " :: " + (e.getMessage() != null ? e.getMessage() : " "));
            }
        }
    }

    public ResourceReferenceDescriptor getResourceReference(String jndiName, String logicalName) {
        Set descriptors = this.getConnectorRuntime().getResourceReferenceDescriptor();
        ArrayList<ResourceReferenceDescriptor> matchingRefs = new ArrayList<ResourceReferenceDescriptor>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                ResourceReferenceDescriptor ref = (ResourceReferenceDescriptor)descriptor;
                String name = ref.getJndiName();
                if (!jndiName.equals(name)) continue;
                matchingRefs.add(ref);
            }
        }
        if (matchingRefs.size() == 1) {
            return (ResourceReferenceDescriptor)matchingRefs.get(0);
        }
        if (matchingRefs.size() > 1) {
            for (ResourceReferenceDescriptor rrd : matchingRefs) {
                String refName = rrd.getName();
                if (!(refName = PoolManagerImpl.getJavaName(refName)).equals(PoolManagerImpl.getJavaName(logicalName))) continue;
                return rrd;
            }
        }
        return null;
    }

    private static String getJavaName(String name) {
        if (name.startsWith("java:")) {
            return name;
        }
        return "java:comp/env/" + name;
    }

    public void beforePreInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation newInv) throws InvocationException {
    }

    public void afterPreInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation curInv) throws InvocationException {
    }

    public void beforePostInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation curInv) throws InvocationException {
    }

    public void afterPostInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation curInv) throws InvocationException {
        this.postInvoke(curInv);
    }

    private void postInvoke(ComponentInvocation curInv) {
        ComponentInvocation invToUse = curInv;
        if (invToUse == null) {
            return;
        }
        Object comp = invToUse.getInstance();
        if (comp == null) {
            return;
        }
        this.handleLazilyAssociatedConnectionPools(comp, invToUse);
    }

    private void handleLazilyAssociatedConnectionPools(Object comp, ComponentInvocation invToUse) {
        ResourceHandle[] handles;
        JavaEETransactionManager tm = this.getConnectorRuntime().getTransactionManager();
        List list = tm.getExistingResourceList(comp, invToUse);
        if (list == null) {
            return;
        }
        if (list.size() == 0) {
            return;
        }
        for (ResourceHandle h : handles = list.toArray(new ResourceHandle[0])) {
            Object var15_12;
            ResourceSpec spec = h.getResourceSpec();
            if (!spec.isLazyAssociatable()) continue;
            DissociatableManagedConnection mc = (DissociatableManagedConnection)h.getResource();
            if (h.isEnlisted()) {
                this.getResourceManager(spec).delistResource(h, 0x4000000);
            }
            try {
                try {
                    mc.dissociateConnections();
                }
                catch (ResourceException re) {
                    InvocationException ie = new InvocationException(re.getMessage());
                    ie.initCause((Throwable)re);
                    throw ie;
                }
                var15_12 = null;
                if (!h.getResourceState().isBusy()) continue;
                this.putbackDirectToPool(h, spec.getConnectionPoolName());
            }
            catch (Throwable throwable) {
                var15_12 = null;
                if (h.getResourceState().isBusy()) {
                    this.putbackDirectToPool(h, spec.getConnectionPoolName());
                }
                throw throwable;
            }
        }
    }

    public void reconfigPoolProperties(ConnectorConnectionPool ccp) throws PoolingException {
        String poolName = ccp.getName();
        ResourcePool pool = (ResourcePool)this.getPoolTable().get(poolName);
        if (pool != null) {
            pool.reconfigurePool(ccp);
        }
    }

    public boolean flushConnectionPool(String poolName) throws PoolingException {
        boolean result = false;
        ResourcePool pool = (ResourcePool)this.getPoolTable().get(poolName);
        if (pool == null) {
            _logger.log(Level.WARNING, "poolmgr.flush_noop_pool_not_initialized", poolName);
            throw new PoolingException("Flush Connection Pool for pool " + poolName + " failed. Please see server.log for more details.");
        }
        result = pool.flushConnectionPool();
        return result;
    }

    public PoolStatus getPoolStatus(String poolName) {
        ResourcePool pool = this.poolTable.get(poolName);
        return pool.getPoolStatus();
    }

    static {
        _logger = LogDomains.getLogger(PoolManagerImpl.class, (String)"javax.enterprise.resource.resourceadapter");
    }

    class SynchronizationListener
    implements Synchronization {
        private Transaction tran;

        SynchronizationListener(Transaction tran) {
            this.tran = tran;
        }

        public void afterCompletion(int status) {
            try {
                PoolManagerImpl.this.transactionCompleted(this.tran, status);
            }
            catch (Exception ex) {
                _logger.fine("Exception in afterCompletion : " + (ex.getMessage() != null ? ex.getMessage() : " "));
            }
        }

        public void beforeCompletion() {
        }
    }
}

