/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.ResourceState;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.enterprise.resource.listener.PoolLifeCycleListener;
import com.sun.enterprise.resource.pool.ConnectionLeakDetector;
import com.sun.enterprise.resource.pool.ConnectionLeakListener;
import com.sun.enterprise.resource.pool.PoolProperties;
import com.sun.enterprise.resource.pool.PoolStatus;
import com.sun.enterprise.resource.pool.PoolTxHelper;
import com.sun.enterprise.resource.pool.ResourceGateway;
import com.sun.enterprise.resource.pool.ResourceHandler;
import com.sun.enterprise.resource.pool.ResourcePool;
import com.sun.enterprise.resource.pool.datastructure.DataStructure;
import com.sun.enterprise.resource.pool.datastructure.DataStructureFactory;
import com.sun.enterprise.resource.pool.resizer.Resizer;
import com.sun.enterprise.resource.pool.waitqueue.PoolWaitQueue;
import com.sun.enterprise.resource.pool.waitqueue.PoolWaitQueueFactory;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.transaction.Transaction;

public class ConnectionPool
implements ResourcePool,
ConnectionLeakListener,
ResourceHandler,
PoolProperties {
    protected static final StringManager localStrings = StringManager.getManager(ConnectionPool.class);
    protected static final Logger _logger = LogDomains.getLogger(ConnectionPool.class, (String)"javax.enterprise.resource.resourceadapter");
    protected int maxPoolSize;
    protected int steadyPoolSize;
    protected int resizeQuantity;
    protected int maxWaitTime;
    protected long idletime;
    protected boolean failAllConnections = false;
    protected boolean matchConnections = false;
    protected boolean validation = false;
    protected boolean preferValidateOverRecreate = false;
    protected Resizer resizerTask;
    protected volatile boolean poolInitialized = false;
    protected Timer timer;
    protected boolean connectionCreationRetry_;
    protected int connectionCreationRetryAttempts_;
    protected long conCreationRetryInterval_;
    protected long validateAtmostPeriodInMilliSeconds_;
    protected int maxConnectionUsage_;
    private boolean validateAtmostEveryIdleSecs = false;
    protected String resourceSelectionStrategyClass;
    protected PoolLifeCycleListener poolLifeCycleListener;
    protected ResourceGateway gateway;
    protected String resourceGatewayClass;
    protected ConnectionLeakDetector leakDetector;
    protected DataStructure ds;
    protected String dataStructureType;
    protected String dataStructureParameters;
    protected PoolWaitQueue waitQueue;
    protected String poolWaitQueueClass;
    protected final String name;
    private PoolTxHelper poolTxHelper;
    protected ResourceSpec resourceSpec;
    protected ResourceAllocator allocator;
    private boolean selfManaged_;

    public ConnectionPool(String poolName, Hashtable env) throws PoolingException {
        this.name = poolName;
        this.setPoolConfiguration(env);
        this.initializePoolDataStructure();
        this.initializeResourceSelectionStragegy();
        this.initializePoolWaitQueue();
        this.poolTxHelper = new PoolTxHelper(this.name);
        this.gateway = ResourceGateway.getInstance(this.resourceGatewayClass);
        _logger.log(Level.FINE, "Connection Pool : " + poolName);
    }

    protected void initializePoolWaitQueue() throws PoolingException {
        this.waitQueue = PoolWaitQueueFactory.createPoolWaitQueue(this.poolWaitQueueClass);
    }

    protected void initializePoolDataStructure() throws PoolingException {
        this.ds = DataStructureFactory.getDataStructure(this.dataStructureType, this.dataStructureParameters, this.maxPoolSize, this, this.resourceSelectionStrategyClass);
    }

    protected void initializeResourceSelectionStragegy() {
    }

    private void setPoolConfiguration(Hashtable env) throws PoolingException {
        ConnectorConnectionPool poolResource = this.getPoolConfigurationFromJndi(env);
        this.idletime = (long)Integer.parseInt(poolResource.getIdleTimeoutInSeconds()) * 1000L;
        this.maxPoolSize = Integer.parseInt(poolResource.getMaxPoolSize());
        this.steadyPoolSize = Integer.parseInt(poolResource.getSteadyPoolSize());
        if (this.maxPoolSize < this.steadyPoolSize) {
            this.maxPoolSize = this.steadyPoolSize;
        }
        this.resizeQuantity = Integer.parseInt(poolResource.getPoolResizeQuantity());
        this.maxWaitTime = Integer.parseInt(poolResource.getMaxWaitTimeInMillis());
        if (this.maxWaitTime < 0) {
            this.maxWaitTime = 0;
        }
        this.failAllConnections = poolResource.isFailAllConnections();
        this.validation = poolResource.isIsConnectionValidationRequired();
        this.validateAtmostEveryIdleSecs = poolResource.isValidateAtmostEveryIdleSecs();
        this.dataStructureType = poolResource.getPoolDataStructureType();
        this.dataStructureParameters = poolResource.getDataStructureParameters();
        this.poolWaitQueueClass = poolResource.getPoolWaitQueue();
        this.resourceSelectionStrategyClass = poolResource.getResourceSelectionStrategyClass();
        this.resourceGatewayClass = poolResource.getResourceGatewayClass();
        this.setAdvancedPoolConfiguration(poolResource);
    }

    protected ConnectorConnectionPool getPoolConfigurationFromJndi(Hashtable env) throws PoolingException {
        ConnectorConnectionPool poolResource;
        try {
            InitialContext ic = env != null ? new InitialContext(env) : new InitialContext();
            String jndiNameOfPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(this.name);
            poolResource = (ConnectorConnectionPool)ic.lookup(jndiNameOfPool);
        }
        catch (NamingException ex) {
            throw new PoolingException((Exception)ex);
        }
        return poolResource;
    }

    protected synchronized void initPool(ResourceSpec resourceSpec, ResourceAllocator allocator) throws PoolingException {
        if (this.poolInitialized) {
            return;
        }
        this.resourceSpec = resourceSpec;
        this.allocator = allocator;
        this.createResources(this.allocator, this.steadyPoolSize - this.ds.getResourcesSize());
        if (this.idletime > 0L) {
            this.scheduleResizerTask();
        }
        if (this.poolLifeCycleListener != null) {
            this.poolLifeCycleListener.connectionsFreed(this.steadyPoolSize);
        }
        this.poolInitialized = true;
    }

    private void scheduleResizerTask() {
        if (this.resizerTask != null) {
            this.resizerTask.cancel();
            this.resizerTask = null;
        }
        this.resizerTask = this.initializeResizer();
        if (this.timer == null) {
            this.timer = ConnectorRuntime.getRuntime().getTimer();
        }
        this.timer.scheduleAtFixedRate((TimerTask)this.resizerTask, this.idletime, this.idletime);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("scheduled resizer task");
        }
    }

    protected Resizer initializeResizer() {
        return new Resizer(this.name, this.ds, this, this, this.preferValidateOverRecreate);
    }

    public void addResource(ResourceAllocator alloc) throws PoolingException {
        int numResCreated = this.ds.addResource(alloc, 1);
        if (numResCreated > 0) {
            for (int i = 0; i < numResCreated; ++i) {
                if (this.poolLifeCycleListener == null) continue;
                this.poolLifeCycleListener.incrementNumConnFree(false, this.steadyPoolSize);
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool: resource added");
        }
    }

    protected void setResourceStateToFree(ResourceHandle resourceHandle) {
        this.getResourceState(resourceHandle).setBusy(false);
        this.leakDetector.stopConnectionLeakTracing(resourceHandle, this);
    }

    protected void setResourceStateToBusy(ResourceHandle resourceHandle) {
        this.getResourceState(resourceHandle).setBusy(true);
        this.leakDetector.startConnectionLeakTracing(resourceHandle, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceHandle getResource(ResourceSpec spec, ResourceAllocator alloc, Transaction tran) throws PoolingException {
        ResourceHandle result = null;
        long startTime = System.currentTimeMillis();
        long remainingWaitTime = 0L;
        while (true) {
            long elapsedWaitTime;
            if (this.gateway.allowed()) {
                try {
                    result = this.internalGetResource(spec, alloc, tran);
                }
                finally {
                    this.gateway.acquiredResource();
                }
            }
            if (result != null) {
                if (this.poolLifeCycleListener == null) break;
                this.poolLifeCycleListener.connectionAcquired();
                elapsedWaitTime = System.currentTimeMillis() - startTime;
                this.poolLifeCycleListener.connectionRequestServed(elapsedWaitTime);
                break;
            }
            if (this.maxWaitTime > 0) {
                elapsedWaitTime = System.currentTimeMillis() - startTime;
                if (elapsedWaitTime < (long)this.maxWaitTime) {
                    remainingWaitTime = (long)this.maxWaitTime - elapsedWaitTime;
                } else {
                    if (this.poolLifeCycleListener != null) {
                        this.poolLifeCycleListener.connectionTimedOut();
                    }
                    String msg = localStrings.getStringWithDefault("poolmgr.no.available.resource", "No available resource. Wait-time expired.");
                    throw new PoolingException(msg);
                }
            }
            Object waitMonitor = this.waitQueue.addToQueue();
            if (this.poolLifeCycleListener != null) {
                this.poolLifeCycleListener.connectionRequestQueued();
            }
            Object object = waitMonitor;
            synchronized (object) {
                try {
                    this.logFine("Resource Pool: getting on wait queue");
                    waitMonitor.wait(remainingWaitTime);
                }
                catch (InterruptedException ex) {
                    break;
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "removing wait monitor from queue: " + waitMonitor);
                }
                if (this.waitQueue.removeFromQueue(waitMonitor) && this.poolLifeCycleListener != null) {
                    this.poolLifeCycleListener.connectionRequestDequeued();
                }
            }
        }
        alloc.fillInResourceObjects(result);
        return result;
    }

    protected ResourceHandle prefetch(ResourceSpec spec, ResourceAllocator alloc, Transaction tran) {
        return null;
    }

    protected ResourceHandle internalGetResource(ResourceSpec spec, ResourceAllocator alloc, Transaction tran) throws PoolingException {
        ResourceHandle result;
        if (!this.poolInitialized) {
            this.initPool(spec, alloc);
        }
        if ((result = this.prefetch(spec, alloc, tran)) != null) {
            return result;
        }
        result = this.getResourceFromTransaction(tran, alloc, spec);
        if (result == null && (result = this.getUnenlistedResource(spec, alloc, tran)) != null) {
            if (this.maxConnectionUsage_ > 0) {
                result.incrementUsageCount();
            }
            if (this.poolLifeCycleListener != null) {
                this.poolLifeCycleListener.connectionUsed();
                this.poolLifeCycleListener.decrementNumConnFree();
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ResourceHandle getResourceFromTransaction(Transaction tran, ResourceAllocator alloc, ResourceSpec spec) {
        ResourceHandle result = null;
        try {
            ResourceState state;
            ResourceHandle h;
            block8: {
                block9: {
                    if (tran == null) return result;
                    if (!alloc.shareableWithinComponent()) return result;
                    JavaEETransaction j2eetran = (JavaEETransaction)tran;
                    Set set = j2eetran.getResources(this.name);
                    if (set == null) return result;
                    Iterator iter = set.iterator();
                    while (iter.hasNext()) {
                        h = (ResourceHandle)iter.next();
                        if (h.hasConnectionErrorOccurred()) {
                            iter.remove();
                            continue;
                        }
                        state = h.getResourceState();
                        if (!h.getResourceAllocator().shareableWithinComponent() || !spec.isXA() && !this.poolTxHelper.isNonXAResourceAndFree(j2eetran, h)) continue;
                        if (!this.matchConnections) break block8;
                        if (!alloc.matchConnection(h)) {
                            if (this.poolLifeCycleListener == null) continue;
                            this.poolLifeCycleListener.connectionNotMatched();
                            continue;
                        }
                        if (h.hasConnectionErrorOccurred()) {
                            if (this.failAllConnections) {
                                return null;
                            }
                            iter.remove();
                            continue;
                        }
                        break block9;
                    }
                    return result;
                }
                if (this.poolLifeCycleListener != null) {
                    this.poolLifeCycleListener.connectionMatched();
                }
            }
            if (!state.isFree()) return h;
            this.setResourceStateToBusy(h);
            return h;
        }
        catch (ClassCastException e) {
            _logger.log(Level.FINE, "Pool: getResource : transaction is not JavaEETransaction but a " + tran.getClass().getName(), e);
        }
        return result;
    }

    protected ResourceHandle getUnenlistedResource(ResourceSpec spec, ResourceAllocator alloc, Transaction tran) throws PoolingException {
        return this.getResourceFromPool(alloc, spec);
    }

    private boolean isConnectionValid(ResourceHandle h, ResourceAllocator alloc) {
        boolean connectionValid = true;
        if (this.validation || this.validateAtmostEveryIdleSecs) {
            long timeSinceValidation;
            long validationPeriod = this.validation ? this.validateAtmostPeriodInMilliSeconds_ : this.idletime;
            boolean validationRequired = true;
            long currentTime = h.getLastValidated();
            if (validationPeriod > 0L && (timeSinceValidation = (currentTime = System.currentTimeMillis()) - h.getLastValidated()) < validationPeriod) {
                validationRequired = false;
            }
            if (validationRequired) {
                if (!alloc.isConnectionValid(h)) {
                    connectionValid = false;
                    this.incrementNumConnFailedValidation();
                } else {
                    h.setLastValidated(currentTime);
                }
            }
        }
        return connectionValid;
    }

    protected boolean matchConnection(ResourceHandle resource, ResourceAllocator alloc) {
        boolean matched = true;
        if (this.matchConnections) {
            matched = alloc.matchConnection(resource);
            if (this.poolLifeCycleListener != null) {
                if (matched) {
                    this.poolLifeCycleListener.connectionMatched();
                } else {
                    this.poolLifeCycleListener.connectionNotMatched();
                }
            }
        }
        return matched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ResourceHandle getResourceFromPool(ResourceAllocator alloc, ResourceSpec spec) throws PoolingException {
        ResourceHandle result = null;
        ArrayList<ResourceHandle> freeResources = new ArrayList<ResourceHandle>();
        try {
            ResourceHandle h;
            while ((h = this.ds.getResource()) != null) {
                if (h.hasConnectionErrorOccurred()) {
                    this.ds.removeResource(h);
                    continue;
                }
                if (this.matchConnection(h, alloc)) {
                    boolean isValid = this.isConnectionValid(h, alloc);
                    if (h.hasConnectionErrorOccurred() || !isValid) {
                        if (this.failAllConnections) {
                            h = this.createSingleResourceAndAdjustPool(alloc, spec);
                            break;
                        } else {
                            this.ds.removeResource(h);
                            continue;
                        }
                    }
                    result = h;
                    break;
                }
                freeResources.add(h);
            }
        }
        finally {
            Iterator i$ = freeResources.iterator();
            while (true) {
                if (!i$.hasNext()) {
                    freeResources.clear();
                }
                ResourceHandle freeResource = (ResourceHandle)i$.next();
                this.ds.returnResource(freeResource);
            }
        }
        if (result == null) return this.resizePoolAndGetNewResource(alloc);
        this.setResourceStateToBusy(result);
        return result;
    }

    private ResourceHandle resizePoolAndGetNewResource(ResourceAllocator alloc) throws PoolingException {
        ResourceHandle result = null;
        int numOfConnsToCreate = 0;
        if (this.ds.getResourcesSize() < this.steadyPoolSize) {
            numOfConnsToCreate = this.steadyPoolSize - this.ds.getResourcesSize();
        } else if (this.ds.getResourcesSize() + this.resizeQuantity <= this.maxPoolSize) {
            numOfConnsToCreate = this.resizeQuantity;
        } else if (this.ds.getResourcesSize() < this.maxPoolSize) {
            numOfConnsToCreate = this.maxPoolSize - this.ds.getResourcesSize();
        }
        if (numOfConnsToCreate > 0) {
            this.createResources(alloc, numOfConnsToCreate);
            result = this.getMatchedResourceFromPool(alloc);
        } else if (this.ds.getFreeListSize() > 0 && this.purgeResources(this.resizeQuantity) > 0) {
            result = this.resizePoolAndGetNewResource(alloc);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceHandle getMatchedResourceFromPool(ResourceAllocator alloc) {
        ResourceHandle result = null;
        ArrayList<ResourceHandle> activeResources = new ArrayList<ResourceHandle>();
        try {
            ResourceHandle handle;
            while ((handle = this.ds.getResource()) != null) {
                if (this.matchConnection(handle, alloc)) {
                    result = handle;
                    this.setResourceStateToBusy(result);
                    break;
                }
                activeResources.add(handle);
            }
        }
        finally {
            for (ResourceHandle activeResource : activeResources) {
                this.ds.returnResource(activeResource);
            }
            activeResources.clear();
        }
        return result;
    }

    private int purgeResources(int quantity) {
        int resourcesCount;
        int totalResourcesRemoved = 0;
        int freeResourcesCount = this.ds.getFreeListSize();
        int n = resourcesCount = freeResourcesCount >= quantity ? quantity : freeResourcesCount;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Purging resources of size : " + resourcesCount);
        }
        for (int i = resourcesCount - 1; i >= 0; --i) {
            ResourceHandle resource = this.ds.getResource();
            if (resource == null) continue;
            this.ds.removeResource(resource);
            ++totalResourcesRemoved;
        }
        return totalResourcesRemoved;
    }

    protected ResourceHandle createSingleResourceAndAdjustPool(ResourceAllocator alloc, ResourceSpec spec) throws PoolingException {
        ResourceHandle result;
        ResourceHandle handle = this.ds.getResource();
        if (handle != null) {
            this.ds.removeResource(handle);
        }
        if ((result = this.getNewResource(alloc)) != null) {
            alloc.fillInResourceObjects(result);
            result.getResourceState().setBusy(true);
        }
        return result;
    }

    protected ResourceHandle createSingleResource(ResourceAllocator resourceAllocator) throws PoolingException {
        ResourceHandle resourceHandle;
        int count = 0;
        while (true) {
            try {
                ++count;
                resourceHandle = resourceAllocator.createResource();
                if (!this.validation && !this.validateAtmostEveryIdleSecs) break;
                resourceHandle.setLastValidated(System.currentTimeMillis());
            }
            catch (Exception ex) {
                _logger.log(Level.FINE, "Connection creation failed for " + count + " time. It will be retried, " + "if connection creation retrial is enabled.", ex);
                if (!this.connectionCreationRetry_ || count >= this.connectionCreationRetryAttempts_) {
                    throw new PoolingException(ex);
                }
                try {
                    Thread.sleep(this.conCreationRetryInterval_);
                }
                catch (InterruptedException ie) {}
                continue;
            }
            break;
        }
        return resourceHandle;
    }

    private void createResources(ResourceAllocator alloc, int size) throws PoolingException {
        for (int i = 0; i < size; ++i) {
            this.createResourceAndAddToPool(alloc);
        }
    }

    public void setPoolLifeCycleListener(PoolLifeCycleListener listener) {
        this.poolLifeCycleListener = listener;
    }

    public void removePoolLifeCycleListener() {
        this.poolLifeCycleListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteResource(ResourceHandle resourceHandle) {
        try {
            try {
                resourceHandle.getResourceAllocator().destroyResource(resourceHandle);
            }
            catch (Exception ex) {
                Object[] args = new Object[]{resourceHandle.getResourceSpec().getConnectionPoolName(), ex.getMessage() == null ? "" : ex.getMessage()};
                _logger.log(Level.WARNING, "poolmgr.destroy_resource_failed", args);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "poolmgr.destroy_resource_failed", ex);
                }
                Object var5_3 = null;
                if (resourceHandle.getResourceState().isBusy()) {
                    this.leakDetector.stopConnectionLeakTracing(resourceHandle, this);
                }
                if (this.poolLifeCycleListener != null) {
                    this.poolLifeCycleListener.connectionDestroyed();
                    if (resourceHandle.getResourceState().isBusy()) {
                        this.poolLifeCycleListener.decrementConnectionUsed();
                        if (!resourceHandle.isMarkedForReclaim()) {
                            this.poolLifeCycleListener.incrementNumConnFree(true, this.steadyPoolSize);
                        }
                    } else {
                        this.poolLifeCycleListener.decrementNumConnFree();
                    }
                }
            }
            Object var5_2 = null;
            if (resourceHandle.getResourceState().isBusy()) {
                this.leakDetector.stopConnectionLeakTracing(resourceHandle, this);
            }
            if (this.poolLifeCycleListener != null) {
                this.poolLifeCycleListener.connectionDestroyed();
                if (resourceHandle.getResourceState().isBusy()) {
                    this.poolLifeCycleListener.decrementConnectionUsed();
                    if (!resourceHandle.isMarkedForReclaim()) {
                        this.poolLifeCycleListener.incrementNumConnFree(true, this.steadyPoolSize);
                    }
                } else {
                    this.poolLifeCycleListener.decrementNumConnFree();
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (resourceHandle.getResourceState().isBusy()) {
                this.leakDetector.stopConnectionLeakTracing(resourceHandle, this);
            }
            if (this.poolLifeCycleListener != null) {
                this.poolLifeCycleListener.connectionDestroyed();
                if (resourceHandle.getResourceState().isBusy()) {
                    this.poolLifeCycleListener.decrementConnectionUsed();
                    if (!resourceHandle.isMarkedForReclaim()) {
                        this.poolLifeCycleListener.incrementNumConnFree(true, this.steadyPoolSize);
                    }
                } else {
                    this.poolLifeCycleListener.decrementNumConnFree();
                }
            }
            throw throwable;
        }
    }

    public void resourceClosed(ResourceHandle h) throws IllegalStateException {
        ResourceState state;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool: resourceClosed: " + h);
        }
        if ((state = this.getResourceState(h)) == null) {
            throw new IllegalStateException("State is null");
        }
        if (!state.isBusy()) {
            throw new IllegalStateException("state.isBusy() : false");
        }
        this.setResourceStateToFree(h);
        state.touchTimestamp();
        if (state.isUnenlisted() || this.poolTxHelper.isNonXAResource(h) && this.poolTxHelper.isLocalTransactionInProgress() && this.poolTxHelper.isLocalResourceEligibleForReuse(h)) {
            this.freeUnenlistedResource(h);
        }
        if (this.poolLifeCycleListener != null) {
            this.poolLifeCycleListener.connectionReleased();
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool: resourceFreed: " + h);
        }
    }

    protected void performMaxConnectionUsageOperation(ResourceHandle handle) {
        if (handle.getUsageCount() >= this.maxConnectionUsage_) {
            this.ds.removeResource(handle);
            _logger.log(Level.INFO, "resource_pool.remove_max_used_conn", handle.getUsageCount());
            if (this.ds.getResourcesSize() < this.steadyPoolSize) {
                try {
                    this.createResourceAndAddToPool(handle.getResourceAllocator());
                }
                catch (Exception e) {
                    _logger.log(Level.WARNING, "resource_pool.failed_creating_resource", e);
                }
            }
        }
    }

    protected void freeUnenlistedResource(ResourceHandle h) {
        this.freeResource(h);
    }

    protected void freeResource(ResourceHandle resourceHandle) {
        if (this.cleanupResource(resourceHandle)) {
            this.ds.returnResource(resourceHandle);
            if (this.poolLifeCycleListener != null) {
                this.poolLifeCycleListener.decrementConnectionUsed();
                this.poolLifeCycleListener.incrementNumConnFree(false, this.steadyPoolSize);
            }
            if (this.maxConnectionUsage_ > 0) {
                this.performMaxConnectionUsageOperation(resourceHandle);
            }
            this.notifyWaitingThreads();
        }
    }

    protected boolean cleanupResource(ResourceHandle handle) {
        boolean cleanupSuccessful = true;
        try {
            ResourceAllocator alloc = handle.getResourceAllocator();
            alloc.cleanup(handle);
        }
        catch (PoolingException ex) {
            Object[] params = new Object[]{this.name, ex};
            _logger.log(Level.WARNING, "cleanup.resource.failed", params);
            cleanupSuccessful = false;
            this.resourceErrorOccurred(handle);
        }
        return cleanupSuccessful;
    }

    public void resourceErrorOccurred(ResourceHandle h) throws IllegalStateException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Pool: resourceErrorOccurred: " + h);
        }
        if (this.failAllConnections) {
            this.doFailAllConnectionsProcessing();
            return;
        }
        ResourceState state = this.getResourceState(h);
        if (state == null) {
            throw new IllegalStateException();
        }
        this.ds.removeResource(h);
    }

    private void doFailAllConnectionsProcessing() {
        this.logFine("doFailAllConnectionsProcessing entered");
        this.cancelResizerTask();
        if (this.poolLifeCycleListener != null) {
            this.poolLifeCycleListener.connectionValidationFailed(this.ds.getResourcesSize());
        }
        this.emptyPool();
        try {
            this.createResources(this.allocator, this.steadyPoolSize);
        }
        catch (PoolingException pe) {
            this.logFine("in doFailAllConnectionsProcessing couldn't create steady resources");
        }
        this.scheduleResizerTask();
        this.logFine("doFailAllConnectionsProcessing done - created new resources");
    }

    public void resourceEnlisted(Transaction tran, ResourceHandle resource) throws IllegalStateException {
        this.poolTxHelper.resourceEnlisted(tran, resource);
    }

    public void transactionCompleted(Transaction tran, int status) throws IllegalStateException {
        List<ResourceHandle> delistedResources = this.poolTxHelper.transactionCompleted(tran, status, this.name);
        for (ResourceHandle resource : delistedResources) {
            if (!this.isResourceUnused(resource)) continue;
            this.freeResource(resource);
        }
    }

    protected boolean isResourceUnused(ResourceHandle h) {
        return h.getResourceState().isFree();
    }

    public ResourceHandle createResource(ResourceAllocator alloc) throws PoolingException {
        ResourceHandle result = this.createSingleResource(alloc);
        ResourceState state = new ResourceState();
        state.setBusy(false);
        state.setEnlisted(false);
        result.setResourceState(state);
        if (this.poolLifeCycleListener != null) {
            this.poolLifeCycleListener.connectionCreated();
        }
        return result;
    }

    public void createResourceAndAddToPool() throws PoolingException {
        this.createResourceAndAddToPool(this.allocator);
    }

    public Set getInvalidConnections(Set connections) throws ResourceException {
        return this.allocator.getInvalidConnections(connections);
    }

    public void invalidConnectionDetected(ResourceHandle h) {
        this.incrementNumConnFailedValidation();
    }

    public void resizePool(boolean forced) {
        this.resizerTask.resizePool(forced);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyWaitingThreads() {
        Object waitMonitor = null;
        Object object = this.waitQueue;
        synchronized (object) {
            if (this.waitQueue.getQueueLength() > 0) {
                waitMonitor = this.waitQueue.remove();
                if (this.poolLifeCycleListener != null) {
                    this.poolLifeCycleListener.connectionRequestDequeued();
                }
            }
        }
        if (waitMonitor != null) {
            object = waitMonitor;
            synchronized (object) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Notifying wait monitor : " + waitMonitor.toString());
                }
                waitMonitor.notify();
            }
        } else {
            this.logFine(" Wait monitor is null");
        }
    }

    private void incrementNumConnFailedValidation() {
        if (this.poolLifeCycleListener != null) {
            this.poolLifeCycleListener.connectionValidationFailed(1);
        }
    }

    private ResourceHandle getNewResource(ResourceAllocator alloc) throws PoolingException {
        this.ds.addResource(alloc, 1);
        return this.ds.getResource();
    }

    private ResourceState getResourceState(ResourceHandle h) {
        return h.getResourceState();
    }

    public void emptyPool() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "EmptyPool: Name = " + this.name);
        }
        this.ds.removeAll();
    }

    public void emptyFreeConnectionsInPool() {
        ResourceHandle h;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Emptying free connections in pool : " + this.name);
        }
        while ((h = this.ds.getResource()) != null) {
            this.ds.removeResource(h);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Pool [");
        sb.append(this.name);
        sb.append("] PoolSize=");
        sb.append(this.ds.getResourcesSize());
        sb.append("  FreeResources=");
        sb.append(this.ds.getFreeListSize());
        sb.append("  QueueSize=");
        sb.append(this.waitQueue.getQueueLength());
        sb.append(" matching=");
        sb.append(this.matchConnections ? "on" : "off");
        sb.append(" validation=");
        sb.append(this.validation ? "on" : "off");
        return sb.toString();
    }

    public synchronized boolean flushConnectionPool() throws PoolingException {
        this.logFine("Flush Connection Pool entered");
        if (!this.poolInitialized) {
            _logger.log(Level.WARNING, "poolmgr.flush_noop_pool_not_initialized", this.getPoolName());
            throw new PoolingException("Flush Connection Pool failed for " + this.getPoolName() + ". Please see server.log for more details.");
        }
        try {
            this.killExtraResources(this.ds.getResourcesSize());
            this.increaseSteadyPoolSize(this.steadyPoolSize);
        }
        catch (PoolingException ex) {
            _logger.log(Level.WARNING, "pool.flush_pool_failure", new Object[]{this.getPoolName(), ex.getMessage()});
            throw ex;
        }
        this.logFine("Flush Connection Pool done");
        return true;
    }

    public synchronized void reconfigurePool(ConnectorConnectionPool poolResource) throws PoolingException {
        int _idleTime = Integer.parseInt(poolResource.getIdleTimeoutInSeconds()) * 1000;
        if (this.poolInitialized) {
            if ((long)_idleTime != this.idletime && _idleTime != 0) {
                this.scheduleResizerTask();
            }
            if (_idleTime == 0) {
                this.cancelResizerTask();
            }
        }
        this.idletime = _idleTime;
        this.resizeQuantity = Integer.parseInt(poolResource.getPoolResizeQuantity());
        this.maxWaitTime = Integer.parseInt(poolResource.getMaxWaitTimeInMillis());
        if (this.maxWaitTime < 0) {
            this.maxWaitTime = 0;
        }
        this.validation = poolResource.isIsConnectionValidationRequired();
        this.failAllConnections = poolResource.isFailAllConnections();
        this.setAdvancedPoolConfiguration(poolResource);
        if (!this.isSelfManaged()) {
            int toKill;
            int _maxPoolSize = Integer.parseInt(poolResource.getMaxPoolSize());
            int oldMaxPoolSize = this.maxPoolSize;
            this.maxPoolSize = _maxPoolSize < this.steadyPoolSize ? this.steadyPoolSize : _maxPoolSize;
            if (oldMaxPoolSize != this.maxPoolSize) {
                this.ds.setMaxSize(this.maxPoolSize);
            }
            int _steadyPoolSize = Integer.parseInt(poolResource.getSteadyPoolSize());
            int oldSteadyPoolSize = this.steadyPoolSize;
            this.steadyPoolSize = _steadyPoolSize > this.maxPoolSize ? this.maxPoolSize : _steadyPoolSize;
            if (this.poolInitialized && (toKill = this.ds.getResourcesSize() - this.maxPoolSize) > 0) {
                this.killExtraResources(toKill);
            }
            if (oldSteadyPoolSize != this.steadyPoolSize && this.poolInitialized && oldSteadyPoolSize < this.steadyPoolSize) {
                this.increaseSteadyPoolSize(_steadyPoolSize);
                if (this.poolLifeCycleListener != null) {
                    this.poolLifeCycleListener.connectionsFreed(this.steadyPoolSize);
                }
            }
        }
    }

    private void setAdvancedPoolConfiguration(ConnectorConnectionPool poolResource) {
        boolean connectionLeakTracing_;
        this.matchConnections = poolResource.matchConnections();
        this.preferValidateOverRecreate = poolResource.isPreferValidateOverRecreate();
        this.maxConnectionUsage_ = Integer.parseInt(poolResource.getMaxConnectionUsage());
        this.connectionCreationRetryAttempts_ = Integer.parseInt(poolResource.getConCreationRetryAttempts());
        this.conCreationRetryInterval_ = (long)Integer.parseInt(poolResource.getConCreationRetryInterval()) * 1000L;
        this.connectionCreationRetry_ = this.connectionCreationRetryAttempts_ > 0;
        this.validateAtmostPeriodInMilliSeconds_ = (long)Integer.parseInt(poolResource.getValidateAtmostOncePeriod()) * 1000L;
        boolean connectionLeakReclaim_ = poolResource.isConnectionReclaim();
        long connectionLeakTimeoutInMilliSeconds_ = (long)Integer.parseInt(poolResource.getConnectionLeakTracingTimeout()) * 1000L;
        boolean bl = connectionLeakTracing_ = connectionLeakTimeoutInMilliSeconds_ > 0L;
        if (this.leakDetector == null) {
            this.leakDetector = new ConnectionLeakDetector(this.name, connectionLeakTracing_, connectionLeakTimeoutInMilliSeconds_, connectionLeakReclaim_);
        } else {
            this.leakDetector.reset(connectionLeakTracing_, connectionLeakTimeoutInMilliSeconds_, connectionLeakReclaim_);
        }
    }

    private void killExtraResources(int numToKill) {
        ResourceHandle h;
        this.cancelResizerTask();
        for (int i = 0; i < numToKill && (h = this.ds.getResource()) != null; ++i) {
            this.ds.removeResource(h);
        }
        this.scheduleResizerTask();
    }

    private void increaseSteadyPoolSize(int newSteadyPoolSize) throws PoolingException {
        this.cancelResizerTask();
        for (int i = this.ds.getResourcesSize(); i < newSteadyPoolSize; ++i) {
            this.createResourceAndAddToPool(this.allocator);
        }
        this.scheduleResizerTask();
    }

    private void createResourceAndAddToPool(ResourceAllocator alloc) throws PoolingException {
        this.addResource(alloc);
    }

    public void switchOnMatching() {
        this.matchConnections = true;
    }

    public String getPoolName() {
        return this.name;
    }

    public synchronized void cancelResizerTask() {
        this.logFine("Cancelling resizer");
        if (this.resizerTask != null) {
            this.resizerTask.cancel();
        }
        this.resizerTask = null;
        if (this.timer != null) {
            this.timer.purge();
        }
    }

    public synchronized void dumpPoolStatus() {
        _logger.log(Level.INFO, "Name of pool :" + this.name);
        _logger.log(Level.INFO, "Free connections :" + this.ds.getFreeListSize());
        _logger.log(Level.INFO, "Total connections :" + this.ds.getResourcesSize());
        _logger.log(Level.INFO, "Pool's matching is :" + this.matchConnections);
    }

    private void logFine(String msg) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(msg);
        }
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getResizeQuantity() {
        return this.resizeQuantity;
    }

    public long getIdleTimeout() {
        return this.idletime;
    }

    public int getWaitQueueLength() {
        return this.waitQueue.getQueueLength();
    }

    public int getSteadyPoolSize() {
        return this.steadyPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxPoolSize(int size) {
        if (size < this.ds.getResourcesSize()) {
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                block7: {
                    int toKill = this.ds.getResourcesSize() - size;
                    if (toKill > 0) {
                        try {
                            this.killExtraResources(toKill);
                        }
                        catch (Exception re) {
                            if (!_logger.isLoggable(Level.FINE)) break block7;
                            _logger.log(Level.FINE, "setMaxPoolSize:: killExtraResources throws exception: " + re.getMessage());
                        }
                    }
                }
            }
        }
        this.maxPoolSize = size;
    }

    public void setSteadyPoolSize(int size) {
        this.steadyPoolSize = size;
    }

    public void setSelfManaged(boolean selfManaged) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Setting selfManaged to : " + selfManaged + " in pool : " + this.name);
        }
        this.selfManaged_ = selfManaged;
    }

    protected boolean isSelfManaged() {
        return this.selfManaged_;
    }

    public void potentialConnectionLeakFound() {
        if (this.poolLifeCycleListener != null) {
            this.poolLifeCycleListener.foundPotentialConnectionLeak();
        }
    }

    public void printConnectionLeakTrace(StringBuffer stackTrace) {
        if (this.poolLifeCycleListener != null) {
            String msg = localStrings.getStringWithDefault("monitoring.statistics", "Monitoring Statistics :");
            stackTrace.append("\n");
            stackTrace.append(msg);
            stackTrace.append("\n");
            this.poolLifeCycleListener.toString(stackTrace);
        }
    }

    public void reclaimConnection(ResourceHandle handle) {
        this.ds.removeResource(handle);
        this.notifyWaitingThreads();
    }

    public PoolStatus getPoolStatus() {
        PoolStatus poolStatus = new PoolStatus(this.name);
        int numFree = this.poolInitialized ? this.ds.getFreeListSize() : 0;
        int numUsed = this.poolInitialized ? this.ds.getResourcesSize() - this.ds.getFreeListSize() : 0;
        poolStatus.setNumConnFree(numFree);
        poolStatus.setNumConnUsed(numUsed);
        return poolStatus;
    }
}

