/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.recovery;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.TransactionService;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.enterprise.transaction.api.XAResourceWrapper;
import com.sun.enterprise.transaction.spi.RecoveryResourceHandler;
import com.sun.logging.LogDomains;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.types.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class JdbcRecoveryResourceHandler
implements RecoveryResourceHandler {
    @Inject
    private TransactionService txService;
    @Inject
    private Resources resources;
    @Inject
    private Habitat connectorRuntimeHabitat;
    private ResourcesUtil resourcesUtil = null;
    private static Logger _logger = LogDomains.getLogger(JdbcRecoveryResourceHandler.class, (String)"javax.enterprise.resource.resourceadapter");

    private void loadAllJdbcResources() {
        block5: {
            try {
                Collection<JdbcResource> jdbcResources = this.getJdbcResources();
                InitialContext ic = new InitialContext();
                Iterator<JdbcResource> i$ = jdbcResources.iterator();
                while (i$.hasNext()) {
                    JdbcResource resource;
                    JdbcResource jdbcResource = resource = i$.next();
                    if (!this.getResourcesUtil().isEnabled((BindableResource)jdbcResource)) continue;
                    try {
                        ic.lookup(jdbcResource.getJndiName());
                    }
                    catch (Exception ex) {
                        _logger.log(Level.SEVERE, "error.loading.jdbc.resources.during.recovery", jdbcResource.getJndiName());
                        if (!_logger.isLoggable(Level.FINE)) continue;
                        _logger.log(Level.FINE, ex.toString(), ex);
                    }
                }
            }
            catch (NamingException ne) {
                _logger.log(Level.SEVERE, "error.loading.jdbc.resources.during.recovery", ne.getMessage());
                if (!_logger.isLoggable(Level.FINE)) break block5;
                _logger.log(Level.FINE, ne.toString(), ne);
            }
        }
    }

    private Collection<JdbcResource> getJdbcResources() {
        return this.resources.getResources(JdbcResource.class);
    }

    private ResourcesUtil getResourcesUtil() {
        if (this.resourcesUtil == null) {
            this.resourcesUtil = ResourcesUtil.createInstance();
        }
        return this.resourcesUtil;
    }

    public void loadXAResourcesAndItsConnections(List xaresList, List connList) {
        Collection<JdbcResource> jdbcResources = this.getJdbcResources();
        if (jdbcResources == null || jdbcResources.size() == 0) {
            return;
        }
        ArrayList<JdbcConnectionPool> jdbcPools = new ArrayList<JdbcConnectionPool>();
        Iterator<JdbcResource> i$ = jdbcResources.iterator();
        while (i$.hasNext()) {
            JdbcResource resource;
            JdbcResource jdbcResource = resource = i$.next();
            if (!this.getResourcesUtil().isEnabled((BindableResource)jdbcResource)) continue;
            JdbcConnectionPool pool = this.getJdbcConnectionPoolByName(jdbcResource.getPoolName());
            if (pool != null && "javax.sql.XADataSource".equals(pool.getResType())) {
                jdbcPools.add(pool);
            }
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.fine("JdbcRecoveryResourceHandler:: loadXAResourcesAndItsConnections :: adding : " + jdbcResource.getPoolName());
        }
        ConnectorRuntime crt = (ConnectorRuntime)this.connectorRuntimeHabitat.getComponent(ConnectorRuntime.class);
        this.loadAllJdbcResources();
        Properties XAResourceWrappers = new Properties();
        XAResourceWrappers.put("oracle.jdbc.xa.client.OracleXADataSource", "com.sun.enterprise.transaction.jts.recovery.OracleXAResource");
        List properties = this.txService.getProperty();
        if (properties != null) {
            for (Property property : properties) {
                String name = property.getName();
                String value = property.getValue();
                if (name.equals("oracle-xa-recovery-workaround")) {
                    if (!"false".equals(value)) continue;
                    XAResourceWrappers.remove("oracle.jdbc.xa.client.OracleXADataSource");
                    continue;
                }
                if (!name.equals("sybase-xa-recovery-workaround") || !value.equals("true")) continue;
                XAResourceWrappers.put("com.sybase.jdbc2.jdbc.SybXADataSource", "com.sun.enterprise.transaction.jts.recovery.SybaseXAResource");
            }
        }
        for (JdbcConnectionPool jdbcConnectionPool : jdbcPools) {
            if (jdbcConnectionPool.getResType() == null || jdbcConnectionPool.getName() == null || !jdbcConnectionPool.getResType().equals("javax.sql.XADataSource")) continue;
            String poolName = jdbcConnectionPool.getName();
            try {
                String[] dbUserPassword = this.getdbUserPasswordOfJdbcConnectionPool(jdbcConnectionPool);
                String dbUser = dbUserPassword[0];
                String dbPassword = dbUserPassword[1];
                ManagedConnectionFactory fac = crt.obtainManagedConnectionFactory(poolName);
                Subject subject = new Subject();
                PasswordCredential pc = new PasswordCredential(dbUser, dbPassword.toCharArray());
                pc.setManagedConnectionFactory(fac);
                ResourcePrincipal prin = new ResourcePrincipal(dbUser, dbPassword);
                subject.getPrincipals().add((Principal)prin);
                subject.getPrivateCredentials().add(pc);
                ManagedConnection mc = fac.createManagedConnection(subject, null);
                connList.add(mc);
                try {
                    XAResource xares = mc.getXAResource();
                    if (xares == null) continue;
                    String datasourceClassname = jdbcConnectionPool.getDatasourceClassname();
                    String wrapperclass = (String)XAResourceWrappers.get(datasourceClassname);
                    if (wrapperclass != null) {
                        XAResourceWrapper xaresWrapper = null;
                        xaresWrapper = (XAResourceWrapper)crt.getConnectorClassLoader().loadClass(wrapperclass).newInstance();
                        xaresWrapper.init(mc, subject);
                        xaresList.add(xaresWrapper);
                        continue;
                    }
                    xaresList.add(xares);
                }
                catch (ResourceException ex) {
                }
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "datasource.xadatasource_error", poolName);
                _logger.log(Level.FINE, "datasource.xadatasource_error_excp", ex);
            }
        }
    }

    private JdbcConnectionPool getJdbcConnectionPoolByName(String poolName) {
        return (JdbcConnectionPool)this.resources.getResourceByName(JdbcConnectionPool.class, poolName);
    }

    public void closeConnections(List connList) {
        for (Object obj : connList) {
            try {
                ManagedConnection con = (ManagedConnection)obj;
                con.destroy();
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "recovery.jdbc-resource.destroy-error", ex);
            }
        }
    }

    public String[] getdbUserPasswordOfJdbcConnectionPool(JdbcConnectionPool jdbcConnectionPool) {
        String[] userPassword = new String[]{null, null};
        List properties = jdbcConnectionPool.getProperty();
        if (properties != null && properties.size() > 0) {
            for (Property property : properties) {
                String prop = property.getName().toUpperCase();
                if ("USERNAME".equals(prop) || "USER".equals(prop)) {
                    userPassword[0] = property.getValue();
                    continue;
                }
                if (!"PASSWORD".equals(prop)) continue;
                userPassword[1] = property.getValue();
            }
        } else {
            return userPassword;
        }
        return userPassword;
    }
}

