/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.service;

import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.service.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.service.ConnectorAdminServicesFactory;
import com.sun.enterprise.connectors.service.ConnectorConnectionPoolAdminServiceImpl;
import com.sun.enterprise.connectors.service.ConnectorService;
import com.sun.enterprise.connectors.util.ConnectionPoolObjectsUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcAdminServiceImpl
extends ConnectorService {
    private ConnectorConnectionPoolAdminServiceImpl ccPoolAdmService = (ConnectorConnectionPoolAdminServiceImpl)ConnectorAdminServicesFactory.getService("ConnectorConnectionPool");

    public Set<String> getValidationClassNames(String dbVendor) {
        TreeSet<String> classNames = new TreeSet<String>();
        if (dbVendor.equalsIgnoreCase("DERBY")) {
            classNames.add("org.glassfish.api.jdbc.validation.DerbyConnectionValidation");
        } else if (dbVendor.equalsIgnoreCase("MYSQL")) {
            classNames.add("org.glassfish.api.jdbc.validation.MySQLConnectionValidation");
        } else if (dbVendor.equalsIgnoreCase("ORACLE")) {
            classNames.add("org.glassfish.api.jdbc.validation.OracleConnectionValidation");
        } else if (dbVendor.equalsIgnoreCase("POSTGRES")) {
            classNames.add("org.glassfish.api.jdbc.validation.PostgresConnectionValidation");
        }
        return classNames;
    }

    public Set<String> getValidationTableNames(String poolName) throws ResourceException {
        ManagedConnectionFactory mcf = null;
        Subject defaultSubject = null;
        ManagedConnection mc = null;
        Connection con = null;
        try {
            mc = (ManagedConnection)this.ccPoolAdmService.getUnpooledConnection(poolName, null, false);
            mcf = this.ccPoolAdmService.obtainManagedConnectionFactory(poolName);
            if (mc != null) {
                con = (Connection)mc.getConnection(defaultSubject, null);
            }
            Set<String> set = JdbcAdminServiceImpl.getValidationTableNames(con, this.getDefaultDatabaseName(poolName, mcf));
            return set;
        }
        catch (Exception re) {
            _logger.log(Level.WARNING, "pool.get_validation_table_names_failure", re.getMessage());
            throw new ResourceException((Throwable)re);
        }
        finally {
            try {
                if (mc != null) {
                    mc.destroy();
                }
            }
            catch (Exception ex) {
                _logger.log(Level.FINEST, "pool.get_validation_table_names_mc_destroy", poolName);
            }
        }
    }

    private String getDefaultDatabaseName(String poolName, ManagedConnectionFactory mcf) throws NamingException {
        String databaseName = null;
        ConnectorConnectionPool connectorConnectionPool = null;
        String jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolName);
        Context ic = this._runtime.getNamingManager().getInitialContext();
        connectorConnectionPool = (ConnectorConnectionPool)ic.lookup(jndiNameForPool);
        databaseName = this.ccPoolAdmService.getPropertyValue("DATABASENAME", connectorConnectionPool);
        if (databaseName == null || databaseName.trim().equals("")) {
            databaseName = ConnectionPoolObjectsUtils.getValueFromMCF("DatabaseName", poolName, mcf);
        }
        return databaseName;
    }

    public static Set<String> getValidationTableNames(Connection con, String catalog) throws ResourceException {
        TreeSet<String> tableNames = new TreeSet<String>();
        if (catalog.trim().equals("")) {
            catalog = null;
        }
        if (con != null) {
            ResultSet rs = null;
            try {
                DatabaseMetaData dmd = con.getMetaData();
                rs = dmd.getTables(catalog, null, null, null);
                while (rs.next()) {
                    String tableName = rs.getString(3);
                    tableNames.add(tableName);
                }
            }
            catch (Exception sqle) {
                _logger.log(Level.INFO, "pool.get_validation_table_names");
                throw new ResourceException((Throwable)sqle);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e1) {}
            }
        }
        throw new ResourceException("The connection is not valid as the connection is null");
        return tableNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPingable(String tableName, Connection con) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("SELECT COUNT(*) FROM " + tableName);
        }
        catch (Exception sqle) {
            _logger.log(Level.INFO, "pool.exc_is_pingable", tableName);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e1) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e2) {}
        }
        return true;
    }
}

