/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.api.JavaEEResource;
import com.sun.appserv.connectors.internal.api.ResourcePropertyImpl;
import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.MailResource;
import com.sun.enterprise.container.common.impl.MailNamingObjectFactory;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.deployment.interfaces.MailResourceIntf;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.resource.deployer.GlobalResourceDeployer;
import com.sun.enterprise.resource.naming.SerializableObjectRefAddr;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Session;
import javax.naming.Reference;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.types.Property;

@Service
@Scoped(value=Singleton.class)
public class MailResourceDeployer
extends GlobalResourceDeployer
implements ResourceDeployer {
    @Inject
    private GlassfishNamingManager namingMgr;
    private static final StringManager localStrings = StringManager.getManager(MailResourceDeployer.class);
    private static Logger _logger = LogDomains.getLogger(MailResourceDeployer.class, (String)"javax.enterprise.system.core");

    public synchronized void deployResource(Object resource) throws Exception {
        MailResource mailRes = (MailResource)resource;
        if (mailRes == null) {
            _logger.log(Level.INFO, "core.resourcedeploy_error");
        } else if (ConnectorsUtil.parseBoolean((String)mailRes.getEnabled())) {
            this.installResource(mailRes);
        } else {
            _logger.log(Level.INFO, "core.resource_disabled", new Object[]{mailRes.getJndiName(), "mail"});
        }
    }

    void installResource(MailResource mailResource) throws Exception {
        JavaEEResource j2eeRes = MailResourceDeployer.toMailJavaEEResource(mailResource);
        this.installMailResource((com.sun.enterprise.resource.beans.MailResource)j2eeRes);
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        MailResource mailRes = (MailResource)resource;
        JavaEEResource javaEEResource = MailResourceDeployer.toMailJavaEEResource(mailRes);
        this.namingMgr.unpublishObject(javaEEResource.getName());
    }

    public synchronized void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    public boolean handles(Object resource) {
        return resource instanceof MailResource;
    }

    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    public synchronized void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public synchronized void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    public void installMailResource(com.sun.enterprise.resource.beans.MailResource mailRes) {
        String bindName = null;
        try {
            bindName = mailRes.getName();
            MailConfiguration config = new MailConfiguration((MailResourceIntf)mailRes);
            Reference ref = new Reference(Session.class.getName(), MailNamingObjectFactory.class.getName(), null);
            SerializableObjectRefAddr serializableRefAddr = new SerializableObjectRefAddr("jndiName", config);
            ref.add(serializableRefAddr);
            this.namingMgr.publishObject(bindName, (Object)ref, true);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "mailrsrc.create_obj_error", bindName);
            _logger.log(Level.SEVERE, "mailrsrc.create_obj_error_excp", ex);
        }
    }

    public static JavaEEResource toMailJavaEEResource(MailResource rbean) {
        com.sun.enterprise.resource.beans.MailResource jr = new com.sun.enterprise.resource.beans.MailResource(rbean.getJndiName());
        jr.setEnabled(ConnectorsUtil.parseBoolean((String)rbean.getEnabled()));
        jr.setStoreProtocol(rbean.getStoreProtocol());
        jr.setStoreProtocolClass(rbean.getStoreProtocolClass());
        jr.setTransportProtocol(rbean.getTransportProtocol());
        jr.setTransportProtocolClass(rbean.getTransportProtocolClass());
        jr.setMailHost(rbean.getHost());
        jr.setUsername(rbean.getUser());
        jr.setMailFrom(rbean.getFrom());
        jr.setDebug(ConnectorsUtil.parseBoolean((String)rbean.getDebug()));
        List properties = rbean.getProperty();
        if (properties != null) {
            for (Property property : properties) {
                ResourcePropertyImpl rp = new ResourcePropertyImpl(property.getName(), (Object)property.getValue());
                jr.addProperty((ResourceProperty)rp);
            }
        }
        return jr;
    }
}

