/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.naming;

import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.resource.DynamicallyReconfigurableResource;
import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.resource.ResourceException;
import javax.resource.spi.RetryableUnavailableException;

public class DynamicResourceReconfigurator
implements InvocationHandler,
DynamicallyReconfigurableResource {
    private Object actualObject;
    private String jndiName;
    private boolean invalid = false;
    protected static final Logger _logger = LogDomains.getLogger(DynamicResourceReconfigurator.class, (String)"javax.enterprise.resource.resourceadapter");

    public DynamicResourceReconfigurator(Object actualObject, String jndiName) {
        this.actualObject = actualObject;
        this.jndiName = jndiName;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.invalid) {
            throw new ResourceException("Resource [" + this.jndiName + "] instance is not valid any more");
        }
        if (method.getName().equals("setDelegate") && args.length == 1) {
            this.setDelegate(args[0]);
        } else if (method.getName().equals("setInvalid") && args.length == 0) {
            this.setInvalid();
        } else {
            Map<DynamicallyReconfigurableResource, Boolean> proxies = ConnectorRegistry.getInstance().getResourceFactories(this.jndiName);
            Boolean status = proxies.get(this);
            if (status == null || !status.booleanValue()) {
                this.debug("status is null or false: " + this);
                Hashtable<String, String> ht = new Hashtable<String, String>();
                ht.put("com.sun.enterprise.resource.reconfig.proxyCall", "TRUE");
                InitialContext ic = new InitialContext(ht);
                this.actualObject = ic.lookup(this.jndiName);
                proxies.put(this, true);
                this.debug("actualObject : " + this.actualObject);
            } else {
                this.debug("status is true: " + this);
            }
            this.debug("DynamicResourceReconfigurator : method : " + method.getName());
            try {
                return method.invoke(this.actualObject, args);
            }
            catch (InvocationTargetException ite) {
                this.debug("exception [ " + ite + " ] in method : " + method.getName());
                if (ite.getCause() != null && ite.getCause().getCause() != null) {
                    return this.retryIfNeeded(proxy, method, args, ite.getCause().getCause());
                }
                if (ite.getCause() != null) {
                    return this.retryIfNeeded(proxy, method, args, ite.getCause());
                }
                throw ite;
            }
        }
        return null;
    }

    private Object retryIfNeeded(Object proxy, Method method, Object[] args, Throwable actualException) throws Throwable {
        RetryableUnavailableException rue;
        if (actualException instanceof RetryableUnavailableException && "POOL-RECONFIGURED-1".equals((rue = (RetryableUnavailableException)actualException).getErrorCode())) {
            this.debug(" DynamicResourceReconfigurator : retryable-exception in method, retrying : " + method.getName());
            return this.invoke(proxy, method, args);
        }
        throw actualException;
    }

    public void setDelegate(Object o) {
        this.actualObject = o;
    }

    public void setInvalid() {
        this.invalid = true;
    }

    private void debug(String message) {
        _logger.finest("[DRC] : " + message);
    }
}

