/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.module;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.WorkSecurityMap;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.module.ConnectorApplication;
import com.sun.enterprise.connectors.module.ConnectorContainer;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.Configuration;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import javax.validation.bootstrap.GenericBootstrap;
import org.glassfish.api.container.Container;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.Events;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.ConnectorClassFinder;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.glassfish.javaee.services.ApplicationScopedResourcesManager;
import org.glassfish.javaee.services.ResourceManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ConnectorDeployer
extends JavaEEDeployer<ConnectorContainer, ConnectorApplication>
implements PostConstruct {
    @Inject
    private ConnectorRuntime runtime;
    @Inject
    private ClassLoaderHierarchy clh;
    @Inject
    private ResourceManager resourceManager;
    @Inject
    private ApplicationScopedResourcesManager asrManager;
    @Inject
    private Resources resources;
    @Inject
    private Domain domain;
    @Inject
    private Events events;
    private static Logger _logger = LogDomains.getLogger(ConnectorDeployer.class, (String)"javax.enterprise.resource.resourceadapter");

    public MetaData getMetaData() {
        return new MetaData(false, null, new Class[]{Application.class});
    }

    public <T> T loadMetaData(Class<T> type, DeploymentContext context) {
        return null;
    }

    public ConnectorApplication load(ConnectorContainer container, DeploymentContext context) {
        super.load((Container)container, context);
        File sourceDir = context.getSourceDir();
        String sourcePath = sourceDir.getAbsolutePath();
        String moduleName = sourceDir.getName();
        ConnectorDescriptor connDesc = (ConnectorDescriptor)context.getModuleMetaData(ConnectorDescriptor.class);
        if (connDesc != null) {
            connDesc.setClassLoader(context.getClassLoader());
        }
        boolean isEmbedded = ConnectorsUtil.isEmbedded((DeploymentContext)context);
        ConnectorClassFinder ccf = null;
        ClassLoader classLoader = null;
        if (!ConnectorsUtil.belongsToSystemRA((String)moduleName)) {
            try {
                classLoader = context.getClassLoader();
                if (isEmbedded) {
                    moduleName = ConnectorsUtil.getEmbeddedRarModuleName((String)ConnectorsUtil.getApplicationName((DeploymentContext)context), (String)moduleName);
                }
                if (!isEmbedded) {
                    ccf = (ConnectorClassFinder)context.getClassLoader();
                    this.clh.getConnectorClassLoader(null).addDelegate((DelegatingClassLoader.ClassFinder)ccf);
                }
                this.registerBeanValidator(moduleName, context.getSource(), classLoader);
                this.runtime.createActiveResourceAdapter(connDesc, moduleName, sourcePath, classLoader);
            }
            catch (Exception cre) {
                Object[] params = new Object[]{moduleName, cre};
                _logger.log(Level.WARNING, "unable.to.load.ra", params);
                if (!isEmbedded && ccf != null) {
                    this.clh.getConnectorClassLoader(null).removeDelegate((DelegatingClassLoader.ClassFinder)ccf);
                }
                this.unregisterBeanValidator(moduleName);
                throw new RuntimeException(cre.getMessage(), cre);
            }
        }
        return new ConnectorApplication(moduleName, ConnectorsUtil.getApplicationName((DeploymentContext)context), this.resourceManager, this.asrManager, classLoader, this.runtime, this.events, connDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unload(ConnectorApplication appContainer, DeploymentContext context) {
        File sourceDir = context.getSourceDir();
        String moduleName = sourceDir.getName();
        try {
            try {
                if (ConnectorsUtil.isEmbedded((DeploymentContext)context)) {
                    String applicationName = ConnectorsUtil.getApplicationName((DeploymentContext)context);
                    moduleName = ConnectorsUtil.getEmbeddedRarModuleName((String)applicationName, (String)moduleName);
                }
                this.runtime.destroyActiveResourceAdapter(moduleName);
            }
            catch (ConnectorRuntimeException e) {
                Object[] params = new Object[]{moduleName, e};
                _logger.log(Level.WARNING, "unable.to.unload.ra", params);
                Object var8_8 = null;
                if (!ConnectorsUtil.isEmbedded((DeploymentContext)context)) {
                    DelegatingClassLoader dcl = this.clh.getConnectorClassLoader(null);
                    for (DelegatingClassLoader.ClassFinder cf : dcl.getDelegates()) {
                        ConnectorClassFinder ccf = (ConnectorClassFinder)cf;
                        if (!ccf.getResourceAdapterName().equals(moduleName)) continue;
                        dcl.removeDelegate((DelegatingClassLoader.ClassFinder)ccf);
                        break;
                    }
                }
                this.unregisterBeanValidator(moduleName);
                return;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (!ConnectorsUtil.isEmbedded((DeploymentContext)context)) {
                DelegatingClassLoader dcl = this.clh.getConnectorClassLoader(null);
                for (DelegatingClassLoader.ClassFinder cf : dcl.getDelegates()) {
                    ConnectorClassFinder ccf = (ConnectorClassFinder)cf;
                    if (!ccf.getResourceAdapterName().equals(moduleName)) continue;
                    dcl.removeDelegate((DelegatingClassLoader.ClassFinder)ccf);
                    break;
                }
            }
            this.unregisterBeanValidator(moduleName);
            throw throwable;
        }
        if (!ConnectorsUtil.isEmbedded((DeploymentContext)context)) {
            DelegatingClassLoader dcl = this.clh.getConnectorClassLoader(null);
            for (DelegatingClassLoader.ClassFinder cf : dcl.getDelegates()) {
                ConnectorClassFinder ccf = (ConnectorClassFinder)cf;
                if (!ccf.getResourceAdapterName().equals(moduleName)) continue;
                dcl.removeDelegate((DelegatingClassLoader.ClassFinder)ccf);
                break;
            }
        }
        this.unregisterBeanValidator(moduleName);
    }

    public void clean(DeploymentContext dc) {
        super.clean(dc);
        UndeployCommandParameters dcp = (UndeployCommandParameters)dc.getCommandParameters(UndeployCommandParameters.class);
        if (dcp != null && dcp.origin == OpsParams.Origin.undeploy && dcp.cascade != null && dcp.cascade.booleanValue()) {
            File sourceDir = dc.getSourceDir();
            String moduleName = sourceDir.getName();
            if (ConnectorsUtil.isEmbedded((DeploymentContext)dc)) {
                String applicationName = ConnectorsUtil.getApplicationName((DeploymentContext)dc);
                moduleName = ConnectorsUtil.getEmbeddedRarModuleName((String)applicationName, (String)moduleName);
            }
            this.deleteAllResources(moduleName, dcp.target);
        }
    }

    private void deleteAllResources(String moduleName, String targetServer) {
        Collection conPools = ConnectorsUtil.getAllPoolsOfModule((String)moduleName, (Resources)this.resources);
        Collection poolNames = ConnectorsUtil.getAllPoolNames((Collection)conPools);
        Collection connectorResources = ConnectorsUtil.getAllResources((Collection)poolNames, (Resources)this.resources);
        AdminObjectResource[] adminObjectResources = ResourcesUtil.createInstance().getEnabledAdminObjectResources(moduleName);
        Collection securityMaps = ConnectorsUtil.getAllWorkSecurityMaps((Resources)this.resources, (String)moduleName);
        ResourceAdapterConfig rac = ConnectorsUtil.getRAConfig((String)moduleName, (Resources)this.resources);
        this.deleteConnectorResources(connectorResources, targetServer, moduleName);
        this.deleteConnectionPools(conPools, moduleName);
        this.deleteAdminObjectResources(adminObjectResources, targetServer, moduleName);
        this.deleteWorkSecurityMaps(securityMaps, moduleName);
        this.deleteRAConfig(rac);
    }

    private void deleteRAConfig(final ResourceAdapterConfig rac) {
        if (rac != null) {
            try {
                if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                    public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                        return param.getResources().remove(rac);
                    }
                }, (ConfigBeanProxy)this.resources) == null) {
                    _logger.log(Level.WARNING, "unable.to.delete.rac", rac.getResourceAdapterName());
                }
            }
            catch (TransactionFailure tfe) {
                Object[] params = new Object[]{rac.getResourceAdapterName(), tfe};
                _logger.log(Level.WARNING, "unable.to.delete.rac.exception", params);
            }
        }
    }

    private void deleteWorkSecurityMaps(final Collection<WorkSecurityMap> workSecurityMaps, String raName) {
        if (workSecurityMaps.size() > 0) {
            try {
                if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                    public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                        for (WorkSecurityMap resource : workSecurityMaps) {
                            param.getResources().remove(resource);
                        }
                        return true;
                    }
                }, (ConfigBeanProxy)this.resources) == null) {
                    _logger.log(Level.WARNING, "unable.to.delete.work.security.map", raName);
                }
            }
            catch (TransactionFailure tfe) {
                Object[] params = new Object[]{raName, tfe};
                _logger.log(Level.WARNING, "unable.to.delete.work.security.map.exception", params);
            }
        }
    }

    private void deleteAdminObjectResources(final AdminObjectResource[] adminObjectResources, String target, String raName) {
        if (adminObjectResources != null && adminObjectResources.length > 0) {
            try {
                final Server targetServer = this.domain.getServerNamed(target);
                if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                    public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                        for (AdminObjectResource resource : adminObjectResources) {
                            param.getResources().remove(resource);
                            targetServer.deleteResourceRef(resource.getJndiName());
                        }
                        return true;
                    }
                }, (ConfigBeanProxy)this.resources) == null) {
                    _logger.log(Level.WARNING, "unable.to.delete.admin.object", raName);
                }
            }
            catch (TransactionFailure tfe) {
                Object[] params = new Object[]{raName, tfe};
                _logger.log(Level.WARNING, "unable.to.delete.admin.object.exception", params);
            }
        }
    }

    private void deleteConnectorResources(final Collection<Resource> connectorResources, String target, String raName) {
        if (connectorResources.size() > 0) {
            try {
                final Server targetServer = this.domain.getServerNamed(target);
                if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                    public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                        for (Resource resource : connectorResources) {
                            param.getResources().remove(resource);
                            targetServer.deleteResourceRef(((ConnectorResource)resource).getJndiName());
                        }
                        return true;
                    }
                }, (ConfigBeanProxy)this.resources) == null) {
                    _logger.log(Level.WARNING, "unable.to.delete.connector.resource", raName);
                }
            }
            catch (TransactionFailure tfe) {
                Object[] params = new Object[]{raName, tfe};
                _logger.log(Level.WARNING, "unable.to.delete.connector.resource.exception", params);
            }
        }
    }

    private void deleteConnectionPools(final Collection<ConnectorConnectionPool> conPools, String raName) {
        if (conPools.size() > 0) {
            try {
                if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                    public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                        Iterator i$ = conPools.iterator();
                        if (i$.hasNext()) {
                            ConnectorConnectionPool cp = (ConnectorConnectionPool)i$.next();
                            return param.getResources().remove(cp);
                        }
                        return null;
                    }
                }, (ConfigBeanProxy)this.resources) == null) {
                    _logger.log(Level.WARNING, "unable.to.delete.connector.connection.pool", raName);
                }
            }
            catch (TransactionFailure tfe) {
                Object[] params = new Object[]{raName, tfe};
                _logger.log(Level.WARNING, "unable.to.delete.connector.connection.pool.exception", params);
            }
        }
    }

    protected String getModuleType() {
        return "connector";
    }

    public void postConstruct() {
    }

    public void logFine(String message) {
        _logger.log(Level.FINE, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void registerBeanValidator(String rarName, ReadableArchive archive, ClassLoader classLoader) {
        ClassLoader contextCL = null;
        try {
            ValidatorFactory validatorFactory;
            Validator beanValidator;
            block17: {
                contextCL = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(classLoader);
                beanValidator = null;
                validatorFactory = null;
                try {
                    List<String> mappingsList = this.getValidationMappingDescriptors(archive);
                    if (mappingsList.size() <= 0) break block17;
                    GenericBootstrap bootstrap = Validation.byDefaultProvider();
                    Configuration config = bootstrap.configure();
                    InputStream inputStream = null;
                    for (String fileName : mappingsList) {
                        inputStream = archive.getEntry(fileName);
                        config.addMapping(inputStream);
                    }
                    validatorFactory = config.buildValidatorFactory();
                    ValidatorContext validatorContext = validatorFactory.usingContext();
                    beanValidator = validatorContext.getValidator();
                    Object var14_16 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block17;
                    }
                    catch (Exception e2) {}
                    break block17;
                    {
                        catch (IOException e) {
                            _logger.log(Level.FINE, "Exception while processing xml files for detecting bean-validation-mapping", e);
                            Object var14_17 = null;
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                                break block17;
                            }
                            catch (Exception e2) {}
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_18 = null;
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    Object[] params = new Object[]{rarName, e};
                    _logger.log(Level.WARNING, "error.processing.xml.for.bean.validation.mapping", params);
                }
            }
            if (beanValidator == null) {
                validatorFactory = Validation.byDefaultProvider().configure().buildValidatorFactory();
                beanValidator = validatorFactory.getValidator();
            }
            ConnectorRegistry registry = ConnectorRegistry.getInstance();
            registry.addBeanValidator(rarName, beanValidator);
            Object var17_23 = null;
            Thread.currentThread().setContextClassLoader(contextCL);
        }
        catch (Throwable throwable) {
            Object var17_24 = null;
            Thread.currentThread().setContextClassLoader(contextCL);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getValidationMappingDescriptors(ReadableArchive archive) {
        validationMappingNSName = "jboss.org/xml/ns/javax/validation/mapping";
        entries = archive.entries();
        mappingList = new ArrayList<String>();
        while (entries.hasMoreElements() != false) {
            fileName = (String)entries.nextElement();
            if (!fileName.toUpperCase().endsWith(".XML")) continue;
            reader = null;
            try {
                try {
                    is = archive.getEntry(fileName);
                    reader = new BufferedReader(new InputStreamReader(is));
                    while ((line = reader.readLine()) != null) {
                        if (!line.contains(validationMappingNSName)) continue;
                        mappingList.add(fileName);
                        break;
                    }
                }
                catch (IOException e) {
                    ConnectorDeployer._logger.log(Level.FINE, "Exception while processing xml file [ " + fileName + " ] " + "for detecting bean-validation-mapping", e);
                    var10_10 = null;
                    if (reader == null) continue;
                    try {
                        reader.close();
                    }
                    catch (Exception e) {}
                    continue;
                }
                var10_10 = null;
                if (reader == null) continue;
                {
                }
            }
            catch (Throwable var9_12) {
                var10_10 = null;
                if (reader == null) throw var9_12;
                ** try [egrp 2[TRYBLOCK] [4 : 186->194)] { 
lbl37:
                // 1 sources

                reader.close();
                throw var9_12;
lbl39:
                // 1 sources

                catch (Exception e) {
                    // empty catch block
                }
                throw var9_12;
            }
            try {}
            catch (Exception e) {}
            reader.close();
        }
        return mappingList;
    }

    private void unregisterBeanValidator(String rarName) {
        ConnectorRegistry registry = ConnectorRegistry.getInstance();
        registry.removeBeanValidator(rarName);
    }
}

