/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.appserv.connectors.internal.spi.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.resource.common.PoolInfo;
import org.glassfish.resource.common.ResourceInfo;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class ConnectorResourceDeployer
implements ResourceDeployer {
    @Inject
    private ConnectorRuntime runtime;
    private static Logger _logger = LogDomains.getLogger(ConnectorResourceDeployer.class, (String)"javax.enterprise.resource.resourceadapter");

    public synchronized void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
        ConnectorResource domainResource = (ConnectorResource)resource;
        ResourceInfo resourceInfo = new ResourceInfo(domainResource.getJndiName(), applicationName, moduleName);
        PoolInfo poolInfo = new PoolInfo(domainResource.getPoolName(), applicationName, moduleName);
        this.createConnectorResource(domainResource, resourceInfo, poolInfo);
    }

    public void deployResource(Object resource) throws Exception {
        ConnectorResource domainResource = (ConnectorResource)resource;
        String poolName = domainResource.getPoolName();
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)domainResource);
        PoolInfo poolInfo = new PoolInfo(poolName, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
        this.createConnectorResource(domainResource, resourceInfo, poolInfo);
    }

    private void createConnectorResource(ConnectorResource connectorResource, ResourceInfo resourceInfo, PoolInfo poolInfo) throws ConnectorRuntimeException {
        if (ResourcesUtil.createInstance().isEnabled((BindableResource)connectorResource, resourceInfo)) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Calling backend to add connector resource", resourceInfo);
            }
            this.runtime.createConnectorResource(resourceInfo, poolInfo, null);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Added connector resource in backend", resourceInfo);
            }
        } else {
            _logger.log(Level.INFO, "core.resource_disabled", new Object[]{connectorResource.getJndiName(), "cr"});
        }
    }

    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
        ConnectorResource domainResource = (ConnectorResource)resource;
        ResourceInfo resourceInfo = new ResourceInfo(domainResource.getJndiName(), applicationName, moduleName);
        this.deleteConnectorResource(domainResource, resourceInfo);
    }

    public synchronized void undeployResource(Object resource) throws Exception {
        ConnectorResource domainResource = (ConnectorResource)resource;
        ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)domainResource);
        this.deleteConnectorResource(domainResource, resourceInfo);
    }

    private void deleteConnectorResource(ConnectorResource domainResource, ResourceInfo resourceInfo) throws Exception {
        this.runtime.deleteConnectorResource(resourceInfo);
        this.checkAndDeletePool(domainResource);
    }

    public void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    public synchronized void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    public synchronized void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public boolean handles(Object resource) {
        return resource instanceof ConnectorResource;
    }

    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    private void checkAndDeletePool(ConnectorResource cr) throws Exception {
        String poolName = cr.getPoolName();
        try {
            ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)cr);
            ConnectorConnectionPool ccp = ResourcesUtil.createInstance().getConnectorConnectionPoolOfResource(resourceInfo);
            PoolInfo poolInfo = ConnectorsUtil.getPoolInfo((ResourcePool)ccp);
            boolean poolReferred = ResourcesUtil.createInstance().isPoolReferredInServerInstance(poolInfo);
            if (!poolReferred) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Deleting pool [" + poolName + "] as there are no more " + "resource-refs to the pool in this server instance");
                }
                this.runtime.getResourceDeployer(ccp).undeployResource((Object)ccp);
            }
        }
        catch (Exception ce) {
            _logger.warning(ce.getMessage());
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Exception while deleting pool [ " + poolName + " ] : " + ce);
            }
            throw ce;
        }
    }
}

