/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.module;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.WorkSecurityMap;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.module.ConnectorApplication;
import com.sun.enterprise.connectors.module.ConnectorContainer;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.Configuration;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import javax.validation.bootstrap.GenericBootstrap;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.Container;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.ConnectorClassFinder;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.glassfish.internal.api.Target;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.javaee.core.deployment.JavaEEDeployer;
import org.glassfish.javaee.services.ApplicationScopedResourcesManager;
import org.glassfish.javaee.services.ResourceManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ConnectorDeployer
extends JavaEEDeployer<ConnectorContainer, ConnectorApplication>
implements PostConstruct,
PreDestroy,
EventListener {
    @Inject
    private ConnectorRuntime runtime;
    @Inject
    private ClassLoaderHierarchy clh;
    @Inject
    private ResourceManager resourceManager;
    @Inject
    private ApplicationScopedResourcesManager asrManager;
    @Inject
    private Domain domain;
    @Inject
    private ServerEnvironment env;
    private Resources resources;
    @Inject
    private Events events;
    private static Logger _logger = LogDomains.getLogger(ConnectorDeployer.class, (String)"javax.enterprise.resource.resourceadapter");
    private static StringManager localStrings = StringManager.getManager(ConnectorRuntime.class);
    private static final String DOMAIN = "domain";
    private static final String EAR = "ear";

    public MetaData getMetaData() {
        return new MetaData(false, null, new Class[]{Application.class});
    }

    public <T> T loadMetaData(Class<T> type, DeploymentContext context) {
        return null;
    }

    public ConnectorApplication load(ConnectorContainer container, DeploymentContext context) {
        super.load((Container)container, context);
        File sourceDir = context.getSourceDir();
        String sourcePath = sourceDir.getAbsolutePath();
        String moduleName = sourceDir.getName();
        ConnectorDescriptor connDesc = (ConnectorDescriptor)context.getModuleMetaData(ConnectorDescriptor.class);
        if (connDesc != null) {
            connDesc.setClassLoader(context.getClassLoader());
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("connector-descriptor during load : " + connDesc);
        }
        boolean isEmbedded = ConnectorsUtil.isEmbedded((DeploymentContext)context);
        ConnectorClassFinder ccf = null;
        ClassLoader classLoader = null;
        if (!ConnectorsUtil.belongsToSystemRA((String)moduleName)) {
            try {
                classLoader = context.getClassLoader();
                if (isEmbedded) {
                    moduleName = ConnectorsUtil.getEmbeddedRarModuleName((String)ConnectorsUtil.getApplicationName((DeploymentContext)context), (String)moduleName);
                }
                if (!isEmbedded) {
                    ccf = (ConnectorClassFinder)context.getClassLoader();
                    this.clh.getConnectorClassLoader(null).addDelegate((DelegatingClassLoader.ClassFinder)ccf);
                }
                this.registerBeanValidator(moduleName, context.getSource(), classLoader);
                this.runtime.createActiveResourceAdapter(connDesc, moduleName, sourcePath, classLoader);
            }
            catch (Exception cre) {
                Object[] params = new Object[]{moduleName, cre};
                _logger.log(Level.WARNING, "unable.to.load.ra", params);
                if (!isEmbedded && ccf != null) {
                    this.clh.getConnectorClassLoader(null).removeDelegate((DelegatingClassLoader.ClassFinder)ccf);
                }
                this.unregisterBeanValidator(moduleName);
                throw new RuntimeException(cre.getMessage(), cre);
            }
        }
        return new ConnectorApplication(moduleName, ConnectorsUtil.getApplicationName((DeploymentContext)context), this.resourceManager, this.asrManager, classLoader, this.runtime, this.events, connDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(ConnectorApplication appContainer, DeploymentContext context) {
        String moduleName = appContainer.getModuleName();
        try {
            this.runtime.destroyActiveResourceAdapter(moduleName);
        }
        catch (ConnectorRuntimeException e) {
            Object[] params = new Object[]{moduleName, e};
            _logger.log(Level.WARNING, "unable.to.unload.ra", params);
        }
        finally {
            if (!ConnectorsUtil.isEmbedded((DeploymentContext)context)) {
                DelegatingClassLoader dcl = this.clh.getConnectorClassLoader(null);
                for (DelegatingClassLoader.ClassFinder cf : dcl.getDelegates()) {
                    ConnectorClassFinder ccf = (ConnectorClassFinder)cf;
                    if (!ccf.getResourceAdapterName().equals(moduleName)) continue;
                    dcl.removeDelegate((DelegatingClassLoader.ClassFinder)ccf);
                    break;
                }
            }
            this.unregisterBeanValidator(moduleName);
        }
    }

    public void clean(DeploymentContext dc) {
        super.clean(dc);
        UndeployCommandParameters dcp = (UndeployCommandParameters)dc.getCommandParameters(UndeployCommandParameters.class);
        if (dcp != null && dcp.origin == OpsParams.Origin.undeploy && dcp.cascade != null && dcp.cascade.booleanValue()) {
            File sourceDir = dc.getSourceDir();
            String moduleName = sourceDir.getName();
            if (ConnectorsUtil.isEmbedded((DeploymentContext)dc)) {
                String applicationName = ConnectorsUtil.getApplicationName((DeploymentContext)dc);
                moduleName = ConnectorsUtil.getEmbeddedRarModuleName((String)applicationName, (String)moduleName);
            }
            this.deleteAllResources(moduleName, dcp.target);
        }
    }

    private void deleteAllResources(String moduleName, String targetServer) {
        Collection conPools = ConnectorsUtil.getAllPoolsOfModule((String)moduleName, (Resources)this.resources);
        Collection poolNames = ConnectorsUtil.getAllPoolNames((Collection)conPools);
        Collection connectorResources = ConnectorsUtil.getAllResources((Collection)poolNames, (Resources)this.resources);
        Collection<AdminObjectResource> adminObjectResources = ResourcesUtil.createInstance().getEnabledAdminObjectResources(moduleName);
        Collection securityMaps = ConnectorsUtil.getAllWorkSecurityMaps((Resources)this.resources, (String)moduleName);
        ResourceAdapterConfig rac = ConnectorsUtil.getRAConfig((String)moduleName, (Resources)this.resources);
        this.deleteConnectorResources(connectorResources, targetServer, moduleName);
        this.deleteConnectionPools(conPools, moduleName);
        this.deleteAdminObjectResources(adminObjectResources, targetServer, moduleName);
        this.deleteWorkSecurityMaps(securityMaps, moduleName);
        this.deleteRAConfig(rac);
    }

    private void deleteRAConfig(final ResourceAdapterConfig rac) {
        if (rac != null) {
            try {
                if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                    public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                        return param.getResources().remove(rac);
                    }
                }, (ConfigBeanProxy)this.resources) == null) {
                    _logger.log(Level.WARNING, "unable.to.delete.rac", rac.getResourceAdapterName());
                }
            }
            catch (TransactionFailure tfe) {
                Object[] params = new Object[]{rac.getResourceAdapterName(), tfe};
                _logger.log(Level.WARNING, "unable.to.delete.rac.exception", params);
            }
        }
    }

    private void deleteWorkSecurityMaps(final Collection<WorkSecurityMap> workSecurityMaps, String raName) {
        if (workSecurityMaps.size() > 0) {
            try {
                if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                    public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                        for (WorkSecurityMap resource : workSecurityMaps) {
                            param.getResources().remove(resource);
                        }
                        return true;
                    }
                }, (ConfigBeanProxy)this.resources) == null) {
                    _logger.log(Level.WARNING, "unable.to.delete.work.security.map", raName);
                }
            }
            catch (TransactionFailure tfe) {
                Object[] params = new Object[]{raName, tfe};
                _logger.log(Level.WARNING, "unable.to.delete.work.security.map.exception", params);
            }
        }
    }

    private void deleteAdminObjectResources(final Collection<AdminObjectResource> adminObjectResources, String target, String raName) {
        if (adminObjectResources != null && adminObjectResources.size() > 0) {
            try {
                for (AdminObjectResource resource : adminObjectResources) {
                    String jndiName = resource.getJndiName();
                    this.deleteResourceRef(jndiName, target);
                }
                if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                    public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                        for (AdminObjectResource resource : adminObjectResources) {
                            param.getResources().remove(resource);
                        }
                        return true;
                    }
                }, (ConfigBeanProxy)this.resources) == null) {
                    _logger.log(Level.WARNING, "unable.to.delete.admin.object", raName);
                }
            }
            catch (TransactionFailure tfe) {
                Object[] params = new Object[]{raName, tfe};
                _logger.log(Level.WARNING, "unable.to.delete.admin.object.exception", params);
            }
        }
    }

    private void deleteConnectorResources(final Collection<Resource> connectorResources, String target, String raName) {
        if (connectorResources.size() > 0) {
            try {
                for (Resource resource : connectorResources) {
                    String jndiName = ((ConnectorResource)resource).getJndiName();
                    this.deleteResourceRef(jndiName, target);
                }
                if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                    public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                        for (Resource resource : connectorResources) {
                            param.getResources().remove(resource);
                        }
                        return true;
                    }
                }, (ConfigBeanProxy)this.resources) == null) {
                    _logger.log(Level.WARNING, "unable.to.delete.connector.resource", raName);
                }
            }
            catch (TransactionFailure tfe) {
                Object[] params = new Object[]{raName, tfe};
                _logger.log(Level.WARNING, "unable.to.delete.connector.resource.exception", params);
            }
        }
    }

    private void deleteResourceRef(String jndiName, String target) throws TransactionFailure {
        if (target.equals(DOMAIN)) {
            return;
        }
        if (this.domain.getConfigNamed(target) != null) {
            return;
        }
        Server server = ConfigBeansUtilities.getServerNamed((String)target);
        if (server != null) {
            if (server.isResourceRefExists(jndiName)) {
                server.deleteResourceRef(jndiName);
            }
        } else {
            Cluster cluster = this.domain.getClusterNamed(target);
            if (cluster != null && cluster.isResourceRefExists(jndiName)) {
                cluster.deleteResourceRef(jndiName);
                Target tgt = (Target)this.habitat.getComponent(Target.class);
                List instances = tgt.getInstances(target);
                for (Server svr : instances) {
                    if (!svr.isResourceRefExists(jndiName)) continue;
                    svr.deleteResourceRef(jndiName);
                }
            }
        }
    }

    private void deleteConnectionPools(final Collection<ConnectorConnectionPool> conPools, String raName) {
        if (conPools.size() > 0) {
            try {
                if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                    public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                        Iterator i$ = conPools.iterator();
                        if (i$.hasNext()) {
                            ConnectorConnectionPool cp = (ConnectorConnectionPool)i$.next();
                            return param.getResources().remove(cp);
                        }
                        return null;
                    }
                }, (ConfigBeanProxy)this.resources) == null) {
                    _logger.log(Level.WARNING, "unable.to.delete.connector.connection.pool", raName);
                }
            }
            catch (TransactionFailure tfe) {
                Object[] params = new Object[]{raName, tfe};
                _logger.log(Level.WARNING, "unable.to.delete.connector.connection.pool.exception", params);
            }
        }
    }

    protected String getModuleType() {
        return "connector";
    }

    public void postConstruct() {
        this.resources = this.domain.getResources();
        this.events.register((EventListener)this);
    }

    public void logFine(String message) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerBeanValidator(String rarName, ReadableArchive archive, ClassLoader classLoader) {
        ClassLoader contextCL = null;
        try {
            ValidatorFactory validatorFactory;
            Validator beanValidator;
            block20: {
                contextCL = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(classLoader);
                beanValidator = null;
                validatorFactory = null;
                try {
                    List<String> mappingsList = this.getValidationMappingDescriptors(archive);
                    if (mappingsList.size() <= 0) break block20;
                    GenericBootstrap bootstrap = Validation.byDefaultProvider();
                    Configuration config = bootstrap.configure();
                    InputStream inputStream = null;
                    try {
                        for (String fileName : mappingsList) {
                            inputStream = archive.getEntry(fileName);
                            config.addMapping(inputStream);
                        }
                        validatorFactory = config.buildValidatorFactory();
                        ValidatorContext validatorContext = validatorFactory.usingContext();
                        beanValidator = validatorContext.getValidator();
                    }
                    catch (IOException e) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, "Exception while processing xml files for detecting bean-validation-mapping", e);
                        }
                    }
                    finally {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (Exception e) {}
                    }
                }
                catch (Exception e) {
                    Object[] params = new Object[]{rarName, e};
                    _logger.log(Level.WARNING, "error.processing.xml.for.bean.validation.mapping", params);
                }
            }
            if (beanValidator == null) {
                validatorFactory = Validation.byDefaultProvider().configure().buildValidatorFactory();
                beanValidator = validatorFactory.getValidator();
            }
            ConnectorRegistry registry = ConnectorRegistry.getInstance();
            registry.addBeanValidator(rarName, beanValidator);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getValidationMappingDescriptors(ReadableArchive archive) {
        String validationMappingNSName = "jboss.org/xml/ns/javax/validation/mapping";
        Enumeration entries = archive.entries();
        ArrayList<String> mappingList = new ArrayList<String>();
        block11: while (entries.hasMoreElements()) {
            String fileName = (String)entries.nextElement();
            if (!fileName.toUpperCase().endsWith(".XML")) continue;
            BufferedReader reader = null;
            try {
                String line;
                InputStream is = archive.getEntry(fileName);
                reader = new BufferedReader(new InputStreamReader(is));
                while ((line = reader.readLine()) != null) {
                    if (!line.contains(validationMappingNSName)) continue;
                    mappingList.add(fileName);
                    continue block11;
                }
            }
            catch (IOException e) {
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "Exception while processing xml file [ " + fileName + " ] " + "for detecting bean-validation-mapping", e);
            }
            finally {
                if (reader == null) continue;
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
        }
        return mappingList;
    }

    private void unregisterBeanValidator(String rarName) {
        ConnectorRegistry registry = ConnectorRegistry.getInstance();
        registry.removeBeanValidator(rarName);
    }

    public void event(EventListener.Event event) {
        if (Deployment.UNDEPLOYMENT_VALIDATION.equals((Object)event.type())) {
            DeploymentContext dc = (DeploymentContext)event.hook();
            UndeployCommandParameters dcp = (UndeployCommandParameters)dc.getCommandParameters(UndeployCommandParameters.class);
            String appName = dcp.name;
            Boolean cascade = dcp.cascade;
            Boolean ignoreCascade = dcp._ignoreCascade;
            if (cascade != null && ignoreCascade != null && (cascade.booleanValue() || ignoreCascade.booleanValue())) {
                return;
            }
            com.sun.enterprise.config.serverbeans.Application app = this.domain.getApplications().getApplication(appName);
            boolean isRAR = false;
            if (app != null && Boolean.valueOf(app.getEnabled()).booleanValue()) {
                isRAR = app.containsSnifferType("connector");
            }
            if (!isRAR) {
                return;
            }
            boolean isAppRefEnabled = false;
            Server server = this.domain.getServers().getServer(this.env.getInstanceName());
            ApplicationRef appRef = server.getApplicationRef(appName);
            if (appRef != null && Boolean.valueOf(appRef.getEnabled()).booleanValue()) {
                isAppRefEnabled = true;
            }
            if (isAppRefEnabled) {
                return;
            }
            boolean isEAR = app.containsSnifferType(EAR);
            String moduleName = appName;
            ResourcesUtil resourcesUtil = ResourcesUtil.createInstance();
            if (isEAR) {
                List modules = app.getModule();
                for (Module module : modules) {
                    moduleName = module.getName();
                    if (module.getEngine("connector") == null || !(moduleName = appName + "#" + moduleName).toLowerCase().endsWith(".rar")) continue;
                    int index = moduleName.lastIndexOf(".rar");
                    moduleName = moduleName.substring(0, index);
                    if (resourcesUtil.filterConnectorResources(this.resourceManager.getAllResources(), moduleName, true).size() <= 0) continue;
                    this.setFailureStatus(dc, moduleName);
                    return;
                }
            } else if (resourcesUtil.filterConnectorResources(this.resourceManager.getAllResources(), moduleName, true).size() > 0) {
                this.setFailureStatus(dc, moduleName);
            }
        }
    }

    private void setFailureStatus(DeploymentContext dc, String moduleName) {
        String message = localStrings.getString("con.deployer.resources.exist", (Object)moduleName);
        _logger.log(Level.WARNING, "resources.of.rar.exist", moduleName);
        ActionReport report = dc.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        report.setMessage(message);
    }

    public void preDestroy() {
        this.events.unregister((EventListener)this);
    }
}

