/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work;

import com.sun.enterprise.connectors.work.WorkManagerFactory;
import com.sun.enterprise.connectors.work.monitor.MonitorableWorkManager;
import com.sun.logging.LogDomains;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.logging.Logger;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;

public class WorkManagerProxy
implements WorkManager,
Externalizable,
MonitorableWorkManager {
    private transient WorkManager wm;
    private String moduleName;
    private boolean monitorableInstance;
    private static Logger _logger = LogDomains.getLogger(WorkManagerProxy.class, (String)"javax.enterprise.resource.resourceadapter");

    public WorkManagerProxy(WorkManager wm, String moduleName) {
        this.wm = wm;
        this.moduleName = moduleName;
        this.monitorableInstance = this.isMonitorableInstance(wm);
    }

    public WorkManagerProxy() {
    }

    public void doWork(Work work) throws WorkException {
        this.wm.doWork(work);
    }

    public void doWork(Work work, long startTimeout, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        this.wm.doWork(work, startTimeout, executionContext, workListener);
    }

    public long startWork(Work work) throws WorkException {
        return this.wm.startWork(work);
    }

    public long startWork(Work work, long startTimeout, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        return this.wm.startWork(work, startTimeout, executionContext, workListener);
    }

    public void scheduleWork(Work work) throws WorkException {
        this.wm.scheduleWork(work);
    }

    public void scheduleWork(Work work, long startTimeout, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        this.wm.scheduleWork(work, startTimeout, executionContext, workListener);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.moduleName);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.moduleName = in.readUTF();
        this.wm = WorkManagerFactory.retrieveWorkManager(this.moduleName);
        this.monitorableInstance = this.isMonitorableInstance(this.wm);
        _logger = LogDomains.getLogger(WorkManagerProxy.class, (String)"javax.enterprise.resource.resourceadapter");
    }

    public boolean equals(Object o) {
        boolean equal = false;
        if (o instanceof WorkManagerProxy) {
            WorkManagerProxy wmp = (WorkManagerProxy)o;
            equal = wmp.wm.equals(this.wm);
        }
        return equal;
    }

    public int hashCode() {
        return this.wm.hashCode();
    }

    private boolean isMonitorableInstance(WorkManager wm) {
        boolean isMonitorable = wm instanceof MonitorableWorkManager;
        if (!isMonitorable) {
            _logger.warning("Monitoring information cannot be collected for this WorkManager [ " + wm.getClass().getName() + " ] as it is not of type " + MonitorableWorkManager.class.getName());
        }
        return isMonitorable;
    }

    public boolean isMonitoringEnabled() {
        if (this.monitorableInstance) {
            return ((MonitorableWorkManager)this.wm).isMonitoringEnabled();
        }
        return false;
    }

    public void setMonitoringEnabled(boolean isEnabled) {
        if (this.monitorableInstance) {
            ((MonitorableWorkManager)this.wm).setMonitoringEnabled(isEnabled);
        }
    }

    public long getCurrentActiveWorkCount() {
        if (this.monitorableInstance) {
            return ((MonitorableWorkManager)this.wm).getCurrentActiveWorkCount();
        }
        return -1L;
    }

    public long getMaxActiveWorkCount() {
        if (this.monitorableInstance) {
            return ((MonitorableWorkManager)this.wm).getMaxActiveWorkCount();
        }
        return -1L;
    }

    public long getMinActiveWorkCount() {
        if (this.monitorableInstance) {
            return ((MonitorableWorkManager)this.wm).getMinActiveWorkCount();
        }
        return -1L;
    }

    public long getWaitQueueLength() {
        if (this.monitorableInstance) {
            return ((MonitorableWorkManager)this.wm).getWaitQueueLength();
        }
        return -1L;
    }

    public long getMaxWaitQueueLength() {
        if (this.monitorableInstance) {
            return ((MonitorableWorkManager)this.wm).getMaxWaitQueueLength();
        }
        return -1L;
    }

    public long getMinWaitQueueLength() {
        if (this.monitorableInstance) {
            return ((MonitorableWorkManager)this.wm).getMinWaitQueueLength();
        }
        return -1L;
    }

    public long getSubmittedWorkCount() {
        if (this.monitorableInstance) {
            return ((MonitorableWorkManager)this.wm).getSubmittedWorkCount();
        }
        return -1L;
    }

    public long getRejectedWorkCount() {
        if (this.monitorableInstance) {
            return ((MonitorableWorkManager)this.wm).getRejectedWorkCount();
        }
        return -1L;
    }

    public long getCompletedWorkCount() {
        if (this.monitorableInstance) {
            return ((MonitorableWorkManager)this.wm).getCompletedWorkCount();
        }
        return -1L;
    }

    public long getMaxWorkRequestWaitTime() {
        if (this.monitorableInstance) {
            return ((MonitorableWorkManager)this.wm).getMaxWorkRequestWaitTime();
        }
        return -1L;
    }

    public long getMinWorkRequestWaitTime() {
        if (this.monitorableInstance) {
            return ((MonitorableWorkManager)this.wm).getMinWorkRequestWaitTime();
        }
        return -1L;
    }
}

