/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work.context;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.config.serverbeans.GroupMap;
import com.sun.enterprise.config.serverbeans.PrincipalMap;
import com.sun.enterprise.config.serverbeans.WorkSecurityMap;
import com.sun.enterprise.connectors.work.WorkCoordinator;
import com.sun.enterprise.connectors.work.context.ConnectorCallbackHandler;
import com.sun.enterprise.connectors.work.context.CustomWorkContext_A;
import com.sun.enterprise.connectors.work.context.CustomWorkContext_B;
import com.sun.enterprise.connectors.work.context.CustomWorkContext_D;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.HintsContext;
import javax.resource.spi.work.SecurityContext;
import javax.resource.spi.work.TransactionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkContext;
import javax.resource.spi.work.WorkContextLifecycleListener;
import javax.resource.spi.work.WorkContextProvider;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkRejectedException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.PrincipalImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=PerLookup.class)
public class WorkContextHandler
implements com.sun.appserv.connectors.internal.api.WorkContextHandler {
    private static final List<Class<? extends WorkContext>> containerSupportedContexts = new ArrayList<Class<? extends WorkContext>>();
    private static final Logger logger = LogDomains.getLogger(WorkCoordinator.class, (String)"LogStrings");
    @Inject
    private ConnectorRuntime runtime = null;
    private Set<WorkContext> validContexts = new HashSet<WorkContext>();

    public WorkContextHandler() {
    }

    public WorkContextHandler(ConnectorRuntime runtime) {
        this.runtime = runtime;
    }

    public boolean isContextSupported(boolean strict, String workContextClassName) {
        boolean result = false;
        result = strict ? this.canContainerHandleSameContextType(workContextClassName) : this.canContainerHandleContext(workContextClassName);
        return result;
    }

    private boolean canContainerHandleSameContextType(String workContextClassName) {
        boolean result = false;
        for (Class<? extends WorkContext> workContextClass : containerSupportedContexts) {
            Class clz = null;
            try {
                clz = this.loadClass(workContextClassName);
            }
            catch (ClassNotFoundException cnfe) {
                WorkContextHandler.debug(cnfe.toString());
                Object[] params = new Object[]{workContextClassName, cnfe};
                logger.log(Level.WARNING, "workcontext.context_class_not_found", params);
                break;
            }
            if (!workContextClass.equals(clz)) continue;
            result = true;
            WorkContextHandler.debug("Container can handle the context [Strict] : " + workContextClassName);
            break;
        }
        return result;
    }

    public boolean canContainerHandleContext(String contextClassName) {
        boolean result = false;
        if (!this.canContainerHandleSameContextType(contextClassName)) {
            Class context = null;
            try {
                context = this.loadClass(contextClassName);
            }
            catch (ClassNotFoundException e) {
                WorkContextHandler.debug("Container cannot load the context class [isAssignable] : " + contextClassName + " ");
            }
            for (Class<? extends WorkContext> workContextClass : containerSupportedContexts) {
                if (!workContextClass.isAssignableFrom(context)) continue;
                result = true;
                WorkContextHandler.debug("Container can handle the context [isAssignable] : " + contextClassName);
                break;
            }
        } else {
            result = true;
        }
        return result;
    }

    private Class loadClass(String contextClassName) throws ClassNotFoundException {
        return this.runtime.getConnectorClassLoader().loadClass(contextClassName);
    }

    public void validateWork(Work work, ExecutionContext ec) throws WorkCompletedException, WorkRejectedException {
        if (work instanceof WorkContextProvider) {
            if (ec != null && WorkContextHandler.getExecutionContext(work) != ec) {
                WorkRejectedException wre = new WorkRejectedException();
                Object[] params = new Object[]{ec, wre};
                logger.log(Level.WARNING, "workcontext.context_is_context_provider_and_execcontext", params);
                throw wre;
            }
            WorkContextProvider icp = (WorkContextProvider)work;
            List contexts = icp.getWorkContexts();
            for (WorkContext ic : contexts) {
                WorkContextLifecycleListener listener = this.getListener(ic);
                if (this.isContextSupported(false, ic.getClass().getName())) {
                    if (this.isUniqueSubmission(ic, this.validContexts)) {
                        this.validContexts.add(ic);
                        continue;
                    }
                    WorkCompletedException wce = new WorkCompletedException();
                    wce.setErrorCode("2");
                    logger.log(Level.WARNING, "workcontext.duplicate_work_context", ic.getClass().getName());
                    this.notifyContextSetupFailure(listener, "2");
                    throw wce;
                }
                WorkCompletedException wce = new WorkCompletedException();
                Object[] params = new Object[]{ic.getClass().getName(), wce};
                wce.setErrorCode("1");
                logger.log(Level.WARNING, "workcontext.cannot_handle_context", params);
                this.notifyContextSetupFailure(listener, "1");
                throw wce;
            }
        }
    }

    private boolean isUniqueSubmission(WorkContext ic, Collection<WorkContext> supportedContexts) {
        for (WorkContext workContext : supportedContexts) {
            String icName;
            String workContextName = workContext.getClass().getName().toLowerCase();
            if (!workContextName.equalsIgnoreCase(icName = ic.getClass().getName().toLowerCase())) continue;
            WorkContextHandler.debug("Not a unique workContext submission : " + workContext.getClass().getName());
            return false;
        }
        return true;
    }

    public void setupContext(ExecutionContext ec, WorkCoordinator wc) {
        boolean useExecutionContext = true;
        for (WorkContext ic : this.validContexts) {
            WorkContextLifecycleListener listener = this.getListener(ic);
            if (ic instanceof TransactionContext) {
                useExecutionContext = false;
                this.setupTransactionWorkContext((TransactionContext)ic, listener);
                continue;
            }
            if (ic instanceof SecurityContext) {
                this.setupSecurityWorkContext((SecurityContext)ic, listener, wc.getRAName());
                continue;
            }
            if (ic instanceof HintsContext) continue;
            Class<? extends WorkContext> claz = null;
            String className = ic.getClass().getName();
            if (!this.isContextSupported(true, className) && (claz = this.getMostSpecificWorkContextSupported(ic)) == null) {
                WorkContextHandler.debug("Cannot handle work context [ " + className + " ]");
                continue;
            }
            this.setupCustomWorkContext(ic, listener, claz);
        }
        if (useExecutionContext) {
            try {
                this.setupExecutionContext(ec);
            }
            catch (WorkException we) {
                wc.setException(we);
            }
            catch (Exception e) {
                wc.setException(e);
            }
        }
    }

    private WorkContextLifecycleListener getListener(WorkContext wc) {
        WorkContextLifecycleListener listener = null;
        if (wc instanceof WorkContextLifecycleListener) {
            listener = (WorkContextLifecycleListener)wc;
        }
        return listener;
    }

    private void setupCustomWorkContext(WorkContext ic, WorkContextLifecycleListener listener, Class<? extends WorkContext> claz) {
        if (claz != null) {
            Object[] params = new Object[]{ic.getClass().getName(), claz.getName()};
            logger.log(Level.INFO, "workcontext.setting_most_specific_context", params);
        } else {
            WorkContextHandler.debug("setting exact customWorkContext for WorkContext [ " + ic.getClass().getName() + " ]  ");
        }
        this.notifyContextSetupComplete(listener);
    }

    private Class<? extends WorkContext> getMostSpecificWorkContextSupported(WorkContext ic) {
        List<Class> assignableClasses = new ArrayList<Class>();
        for (Class<? extends WorkContext> icClass : containerSupportedContexts) {
            if (!icClass.isAssignableFrom(ic.getClass())) continue;
            assignableClasses.add(icClass);
        }
        assignableClasses = this.sortBasedOnInheritence(assignableClasses);
        Object[] params = new Object[]{ic.getClass().getName(), assignableClasses.get(0).getName()};
        logger.log(Level.INFO, "workcontext.most_specific_work_context_supported", params);
        return assignableClasses.get(0);
    }

    private List<Class> sortBasedOnInheritence(List<Class> assignableClasses) {
        int size = assignableClasses.size();
        Class[] sortedClassesArray = new Class[size];
        for (Class claz : assignableClasses) {
            int count = this.getNumberOfAssignableClasses(claz, assignableClasses);
            sortedClassesArray[count - 1] = claz;
        }
        return Arrays.asList(sortedClassesArray);
    }

    private int getNumberOfAssignableClasses(Class claz, List<Class> assignableClasses) {
        int count = 0;
        for (Class assignableClass : assignableClasses) {
            if (!claz.isAssignableFrom(assignableClass)) continue;
            ++count;
        }
        return count;
    }

    private void setupSecurityWorkContext(SecurityContext securityWorkContext, WorkContextLifecycleListener listener, String raName) {
        try {
            Subject executionSubject = new Subject();
            Subject serviceSubject = new Subject();
            Map securityMap = this.getWorkContextMap(raName);
            ConnectorCallbackHandler handler = new ConnectorCallbackHandler(executionSubject, this.runtime.getCallbackHandler(), securityMap);
            securityWorkContext.setupSecurityContext((CallbackHandler)handler, executionSubject, serviceSubject);
            this.notifyContextSetupComplete(listener);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "workcontext.security_context_setup_failure", e);
            this.notifyContextSetupFailure(listener, "3");
        }
    }

    private Map getSecurityWorkContextMap(String raName) {
        String groupsMap;
        HashMap<Object, Object> eisASMap = new HashMap<Object, Object>();
        String principalsMap = System.getProperty(raName + "-principals-map");
        if (principalsMap != null) {
            StringTokenizer tokenizer = new StringTokenizer(principalsMap, ",");
            while (tokenizer.hasMoreElements()) {
                String nameValue = (String)tokenizer.nextElement();
                if (nameValue == null || !nameValue.contains("=")) continue;
                int delimiterLocation = nameValue.indexOf("=");
                String eisPrincipal = nameValue.substring(0, delimiterLocation);
                String appserverPrincipal = nameValue.substring(delimiterLocation + 1);
                eisASMap.put(new PrincipalImpl(eisPrincipal), new PrincipalImpl(appserverPrincipal));
            }
        }
        if ((groupsMap = System.getProperty(raName + "-groups-map")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(groupsMap, ",");
            while (tokenizer.hasMoreElements()) {
                String nameValue = (String)tokenizer.nextElement();
                if (nameValue == null || !nameValue.contains("=")) continue;
                int delimiterLocation = nameValue.indexOf("=");
                String eisGroup = nameValue.substring(0, delimiterLocation);
                String appserverGroup = nameValue.substring(delimiterLocation + 1);
                eisASMap.put(new Group(eisGroup), new Group(appserverGroup));
            }
            return eisASMap;
        }
        return null;
    }

    private Map getWorkContextMap(String raName) {
        List maps = this.runtime.getWorkSecurityMap(raName);
        List<PrincipalMap> principalsMap = this.getPrincipalsMap(maps);
        List<GroupMap> groupsMap = this.getGroupsMap(maps);
        HashMap<Object, Object> eisASMap = new HashMap<Object, Object>();
        for (PrincipalMap principalMap : principalsMap) {
            eisASMap.put(new PrincipalImpl(principalMap.getEisPrincipal()), new PrincipalImpl(principalMap.getMappedPrincipal()));
        }
        for (GroupMap groupMap : groupsMap) {
            eisASMap.put(new Group(groupMap.getEisGroup()), new Group(groupMap.getMappedGroup()));
        }
        return eisASMap;
    }

    private List<PrincipalMap> getPrincipalsMap(List<WorkSecurityMap> maps) {
        ArrayList<PrincipalMap> principalsMap = new ArrayList<PrincipalMap>();
        for (WorkSecurityMap map : maps) {
            List principalMap = map.getPrincipalMap();
            if (principalMap == null || principalMap.size() <= 0) continue;
            principalsMap.addAll(principalMap);
        }
        return principalsMap;
    }

    private List<GroupMap> getGroupsMap(List<WorkSecurityMap> maps) {
        ArrayList<GroupMap> groupsMap = new ArrayList<GroupMap>();
        for (WorkSecurityMap map : maps) {
            List groupMap = map.getGroupMap();
            if (groupMap == null || groupMap.size() <= 0) continue;
            groupsMap.addAll(groupMap);
        }
        return groupsMap;
    }

    private void notifyContextSetupFailure(WorkContextLifecycleListener listener, String errorCode) {
        if (listener != null) {
            WorkContextHandler.debug("notifying context setup failure");
            listener.contextSetupFailed(errorCode);
        }
    }

    private void notifyContextSetupComplete(WorkContextLifecycleListener listener) {
        if (listener != null) {
            WorkContextHandler.debug("notifying context setup complete");
            listener.contextSetupComplete();
        }
    }

    private void setupTransactionWorkContext(TransactionContext tic, WorkContextLifecycleListener listener) {
        try {
            this.setupExecutionContext((ExecutionContext)tic);
            this.notifyContextSetupComplete(listener);
        }
        catch (Exception e) {
            this.notifyContextSetupFailure(listener, "3");
        }
    }

    private void setupExecutionContext(ExecutionContext ec) throws WorkException {
        JavaEETransactionManager tm = this.runtime.getTransactionManager();
        if (ec != null && ec.getXid() != null) {
            tm.recreate(ec.getXid(), ec.getTransactionTimeout());
        }
    }

    public static void debug(String message) {
        logger.finest(message);
    }

    public static ExecutionContext getExecutionContext(Work work) {
        TransactionContext ec = null;
        if (work instanceof WorkContextProvider) {
            WorkContextProvider icp = (WorkContextProvider)work;
            List icList = icp.getWorkContexts();
            for (WorkContext ic : icList) {
                if (!(ic instanceof TransactionContext)) continue;
                ec = (TransactionContext)ic;
                break;
            }
        }
        return ec;
    }

    public boolean isContextSupported(Class contextClass) {
        return this.canContainerHandleSameContextType(contextClass.getClass().getName());
    }

    static {
        containerSupportedContexts.add(TransactionContext.class);
        containerSupportedContexts.add(SecurityContext.class);
        containerSupportedContexts.add(HintsContext.class);
        containerSupportedContexts.add(CustomWorkContext_A.class);
        containerSupportedContexts.add(CustomWorkContext_B.class);
        containerSupportedContexts.add(CustomWorkContext_D.class);
    }
}

