/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.copyright;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import org.glassfish.copyright.AbstractCopyright;
import org.glassfish.copyright.Copyright;

public class MarkdownCopyright
extends AbstractCopyright {
    protected String commentPrefix = "[//]: # \" ";
    protected String commentSuffix = " \"";

    public MarkdownCopyright(Copyright c) {
        super(c);
    }

    @Override
    protected boolean supports(File file) {
        String fname = file.getName();
        return fname.endsWith(".md") || fname.endsWith(".md.vm");
    }

    @Override
    protected String readComment(BufferedReader r) throws IOException {
        int len;
        String line;
        StringBuilder comment = new StringBuilder();
        while ((line = r.readLine()) != null && (line = MarkdownCopyright.strip(line)).length() == 0) {
        }
        if (line == null || !line.startsWith(this.commentPrefix)) {
            return null;
        }
        while (line.length() != 0 && line.startsWith(this.commentPrefix)) {
            if ((line = line.substring(this.commentPrefix.length())).endsWith(this.commentSuffix)) {
                line = line.substring(0, line.length() - this.commentSuffix.length());
            }
            comment.append(MarkdownCopyright.strip(line).replace("''", "\"")).append('\n');
            line = r.readLine();
            if (line != null) continue;
        }
        if ((len = comment.length()) >= 2 && comment.charAt(len - 1) == '\n' && comment.charAt(len - 2) == '\n') {
            comment.setLength(len - 1);
        }
        return comment.toString();
    }

    @Override
    protected void replaceCopyright(BufferedReader in, BufferedWriter out, String comment, String lastChanged) throws IOException {
        String line;
        while ((line = in.readLine()) != null && (line = MarkdownCopyright.strip(line)).length() == 0) {
        }
        if (comment != null && line != null && line.startsWith(this.commentPrefix)) {
            boolean sawCopyright = false;
            while (line.length() != 0 && line.startsWith(this.commentPrefix)) {
                Matcher m;
                if (!sawCopyright && line.indexOf("Copyright") >= 0 && (m = ypat.matcher(line)).find()) {
                    lastChanged = this.addCopyrightDate(m.group(2), lastChanged);
                    sawCopyright = true;
                }
                if ((line = in.readLine()) != null) continue;
            }
        }
        this.writeCopyright(out, lastChanged, comment);
        if (line != null) {
            if (line.length() > 0) {
                out.write(line);
                out.write(10);
            }
            this.copy(in, out, false);
        }
    }

    @Override
    protected void updateCopyright(BufferedReader in, BufferedWriter out, String lastChanged) throws IOException {
        String line;
        while ((line = in.readLine()) != null && (line = MarkdownCopyright.strip(line)).length() == 0) {
        }
        if (line == null) {
            throw new IOException("NO CONTENT, repair failed");
        }
        if (line.startsWith(this.commentPrefix)) {
            boolean updated = false;
            while (line.startsWith(this.commentPrefix)) {
                Matcher m;
                if (!updated && line.indexOf("Copyright") >= 0 && (m = ypat.matcher(line)).find()) {
                    String y = this.addCopyrightDate(m.group(2), lastChanged);
                    line = line.substring(0, m.start(2)) + y + line.substring(m.end(2));
                    updated = true;
                }
                out.write(line);
                out.write(10);
                line = in.readLine();
                if (line != null) continue;
            }
        }
        if (line != null) {
            if (line.length() != 0) {
                out.write(10);
            }
            out.write(line);
            out.write(10);
            this.copy(in, out, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String toComment(String comment) {
        BufferedReader r = new BufferedReader(new StringReader(comment));
        StringBuilder out = new StringBuilder();
        try {
            String line;
            while ((line = r.readLine()) != null) {
                out.append(this.commentPrefix).append(MarkdownCopyright.strip(line).replace("\"", "''")).append(this.commentSuffix).append('\n');
            }
            out.append("\n");
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                r.close();
            }
            catch (IOException iOException) {}
        }
        return out.toString();
    }
}

