/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.copyright;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.FileResourceCreationException;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.FileUtils;
import org.glassfish.copyright.Copyright;

public abstract class AbstractCopyrightMojo
extends AbstractMojo {
    protected String excludeFile;
    protected String[] exclude;
    protected File baseDirectory;
    protected File sourceDirectory;
    protected ArrayList<Resource> resources;
    protected boolean mavenOnly;
    protected String scm;
    protected boolean debug;
    protected boolean warn = true;
    protected boolean ignoreYear;
    protected boolean normalize;
    protected boolean useComma;
    protected boolean scmOnly;
    protected boolean doHidden;
    protected String templateFile;
    protected String alternateTemplateFile;
    protected Log log;
    private ResourceManager resourceManager;

    protected void initializeOptions(Copyright c) {
        if (this.excludeFile != null) {
            String[] files;
            String[] stringArray = files = this.excludeFile.split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String file = stringArray[i];
                this.log.debug((CharSequence)("copyright: exclude file: " + file));
                String rfile = this.getResourceFile(file).getPath();
                try {
                    c.addExcludes(rfile);
                    continue;
                }
                catch (IOException ex) {
                    this.log.warn((CharSequence)("Failed to add excludes from file: " + file), (Throwable)ex);
                }
            }
        }
        if (this.exclude != null) {
            for (String ex : this.exclude) {
                this.log.debug((CharSequence)("copyright: exclude pattern: " + ex));
                c.addExclude(ex);
            }
        }
        if (this.scm != null && !this.scm.equalsIgnoreCase("svn")) {
            if (this.scm.equalsIgnoreCase("mercurial") || this.scm.equalsIgnoreCase("hg")) {
                c.mercurial = true;
            } else if (this.scm.equalsIgnoreCase("git")) {
                c.git = true;
            } else {
                this.log.warn((CharSequence)("Unknown SCM system ignored: " + this.scm));
            }
        }
        c.debug = this.debug;
        c.warn = this.warn;
        c.ignoreYear = this.ignoreYear;
        c.normalize = this.normalize;
        c.useComma = this.useComma;
        c.skipNoSVN = this.scmOnly;
        c.doHidden = this.doHidden;
        if (this.templateFile != null) {
            c.correctTemplate = new File(this.getResourceFile(this.templateFile).getPath());
        }
        if (this.alternateTemplateFile != null) {
            c.alternateTemplate = new File(this.getResourceFile(this.alternateTemplateFile).getPath());
        }
    }

    protected void check(Copyright c) throws MojoExecutionException {
        try {
            if (this.mavenOnly) {
                this.checkMaven(c);
            } else {
                this.checkAll(c);
            }
        }
        catch (IOException ioex) {
            this.log.error((CharSequence)("IOException: " + ioex));
            throw new MojoExecutionException("IOException while checking copyrights", (Exception)ioex);
        }
    }

    private void checkMaven(Copyright c) throws IOException {
        this.log.debug((CharSequence)("copyright: base directory: " + this.baseDirectory));
        if (this.baseDirectory.exists()) {
            File pom = new File(this.baseDirectory, "pom.xml");
            c.check(pom);
        }
        this.log.debug((CharSequence)("copyright: source directory: " + this.sourceDirectory));
        if (this.sourceDirectory.exists()) {
            c.check(this.sourceDirectory);
        }
        if (this.resources != null) {
            for (Resource r : this.resources) {
                File dir = new File(r.getDirectory());
                List incl = r.getIncludes();
                List excl = r.getExcludes();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("copyright: resource directory: " + dir));
                    this.log.debug((CharSequence)("copyright:   includes: " + incl));
                    this.log.debug((CharSequence)("copyright:   excludes: " + excl));
                }
                for (String ig : Copyright.ignoredDirs) {
                    excl.add("**/" + ig + "/**");
                }
                if (!dir.exists()) continue;
                List files = FileUtils.getFiles((File)dir, (String)AbstractCopyrightMojo.commaSeparated(incl), (String)AbstractCopyrightMojo.commaSeparated(excl), (boolean)true);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("copyright:   files: " + files));
                }
                for (File f : files) {
                    c.check(f);
                }
            }
        }
    }

    private void checkAll(Copyright c) throws IOException {
        this.log.debug((CharSequence)("copyright: base directory: " + this.baseDirectory));
        if (this.baseDirectory.exists()) {
            c.checkMaven(this.baseDirectory);
        }
    }

    protected File getResourceFile(String resource) {
        assert (resource != null);
        this.log.debug((CharSequence)("resource is " + resource));
        try {
            File resourceFile = this.resourceManager.getResourceAsFile(resource);
            this.log.debug((CharSequence)("copyright: location of file is " + resourceFile));
            return resourceFile;
        }
        catch (ResourceNotFoundException ex) {
            return new File(resource);
        }
        catch (FileResourceCreationException ex) {
            return new File(resource);
        }
    }

    private static String commaSeparated(List<String> l) {
        if (l == null || l.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : l) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(s);
        }
        return sb.toString();
    }
}

