/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.copyright;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.copyright.Copyright;

public abstract class AbstractCopyright {
    protected Copyright c;
    private String correctCopyright;
    private String correctBSDCopyright;
    private Pattern cpat;
    private Pattern bpat;
    private List<Pattern> acpatlist = new ArrayList<Pattern>();
    private List<Pattern> dcpatlist = new ArrayList<Pattern>();
    private static Pattern apat;
    private static Pattern anpat;
    private static Pattern oapat;
    private static Pattern sunpat;
    private static Pattern sunapat;
    private static Pattern sunanewpat;
    private static Pattern sunbpat;
    private static Pattern cnocepat;
    private static Pattern ocpat;
    private static Pattern oc2pat;
    private static final String COPYRIGHT_STRING = "Copyright (\\(c\\) )?([-0-9, ]+) (by )?([A-Za-z].*)";
    private static final String COPYRIGHT_LINE = "^Copyright (\\(c\\) )?([-0-9, ]+) (by )?([A-Za-z].*)$";
    private static final String COPYRIGHT_LINE_TEMPLATE = "^Copyright (\\(c\\) )?YYYY (by )?([A-Za-z].*)$\n";
    private static final String derivedCopyrightIntro = "\n\nThis file incorporates work covered by the following copyright and\npermission notice:\n\n";
    private static final String DEFAULT_CORRECT = "cddl+gpl+ce-copyright.txt";
    private static final String DEFAULT_ALTERNATE = "cddl+gpl+ce-java.net-copyright.txt";
    private static final String DEFAULT_BSD = "bsd-copyright.txt";
    protected static Pattern ypat;
    protected static Pattern ylpat;
    protected static Pattern ytpat;
    private static Pattern endPat;
    private static Pattern secLicPat;
    private static Pattern crpat;
    private static Pattern cspat;
    private static Pattern bsdpat;
    protected static final String licensor = "Oracle and/or its affiliates";
    protected static final String allrights = "All rights reserved.";
    protected static final String thisYear;

    public AbstractCopyright(Copyright c) {
        this.c = c;
        try {
            if (c.correctTemplate != null) {
                this.correctCopyright = AbstractCopyright.getCopyrightText(c.correctTemplate);
                this.cpat = AbstractCopyright.getCopyrightPattern(c.correctTemplate);
                this.dcpatlist.add(AbstractCopyright.getDerivedCopyrightPattern(c.correctTemplate, "apacheold-copyright.txt"));
                this.dcpatlist.add(AbstractCopyright.getDerivedCopyrightPattern(c.correctTemplate, "apache-copyright.txt"));
                this.dcpatlist.add(AbstractCopyright.getDerivedCopyrightPattern(c.correctTemplate, "mitsallings-copyright.txt"));
                this.dcpatlist.add(AbstractCopyright.getDerivedCopyrightPattern(c.correctTemplate, "w3c-copyright.txt"));
            } else {
                this.correctCopyright = AbstractCopyright.getCopyrightText(DEFAULT_CORRECT);
                this.cpat = AbstractCopyright.getCopyrightPattern(DEFAULT_CORRECT);
                this.dcpatlist.add(AbstractCopyright.getDerivedCopyrightPattern(DEFAULT_CORRECT, "apacheold-copyright.txt"));
                this.dcpatlist.add(AbstractCopyright.getDerivedCopyrightPattern(DEFAULT_CORRECT, "apache-copyright.txt"));
                this.dcpatlist.add(AbstractCopyright.getDerivedCopyrightPattern(DEFAULT_CORRECT, "mitsallings-copyright.txt"));
                this.dcpatlist.add(AbstractCopyright.getDerivedCopyrightPattern(DEFAULT_CORRECT, "w3c-copyright.txt"));
                if (c.alternateTemplate == null) {
                    this.acpatlist.add(AbstractCopyright.getCopyrightPattern(DEFAULT_ALTERNATE));
                    this.acpatlist.add(AbstractCopyright.getDerivedCopyrightPattern(DEFAULT_ALTERNATE, "apacheold-copyright.txt"));
                    this.acpatlist.add(AbstractCopyright.getDerivedCopyrightPattern(DEFAULT_ALTERNATE, "apache-copyright.txt"));
                    this.acpatlist.add(AbstractCopyright.getDerivedCopyrightPattern(DEFAULT_ALTERNATE, "mitsallings-copyright.txt"));
                    this.acpatlist.add(AbstractCopyright.getDerivedCopyrightPattern(DEFAULT_ALTERNATE, "w3c-copyright.txt"));
                }
            }
            if (c.alternateTemplate != null) {
                this.acpatlist.add(AbstractCopyright.getCopyrightPattern(c.alternateTemplate));
                this.acpatlist.add(AbstractCopyright.getDerivedCopyrightPattern(c.alternateTemplate, "apacheold-copyright.txt"));
                this.acpatlist.add(AbstractCopyright.getDerivedCopyrightPattern(c.alternateTemplate, "apache-copyright.txt"));
                this.acpatlist.add(AbstractCopyright.getDerivedCopyrightPattern(c.alternateTemplate, "mitsallings-copyright.txt"));
                this.acpatlist.add(AbstractCopyright.getDerivedCopyrightPattern(c.alternateTemplate, "w3c-copyright.txt"));
            }
            if (c.correctBSDTemplate != null) {
                this.correctBSDCopyright = AbstractCopyright.getCopyrightText(c.correctBSDTemplate);
                this.bpat = AbstractCopyright.getCopyrightPattern(c.correctBSDTemplate);
            } else {
                this.correctBSDCopyright = AbstractCopyright.getCopyrightText(DEFAULT_BSD);
                this.bpat = AbstractCopyright.getCopyrightPattern(DEFAULT_BSD);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't load copyright template", ex);
        }
    }

    protected abstract boolean supports(File var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCopyright(File file) throws IOException {
        String lc = null;
        if (this.c.skipNoSVN && !this.isModified(file.getPath()) && (lc = this.lastChanged(file.getPath())).length() == 0) {
            if (this.c.verbose) {
                System.out.println("Not under version control, skipped: " + file);
            }
            return;
        }
        BufferedReader r = null;
        String comment = null;
        try {
            r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "iso-8859-1"));
            comment = this.readComment(r);
            if (this.c.debug) {
                System.out.println("Comment for: " + file);
                System.out.println("---");
                System.out.println(comment);
                System.out.println("---");
            }
            if (this.c.warn && !this.c.quiet) {
                this.warnCopyright(file, r);
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
        if (comment == null) {
            this.err(file + ": No copyright");
            ++this.c.nMissing;
            if (this.c.doRepair) {
                this.repair(file, comment, RepairType.MISSING);
            }
            return;
        }
        if (comment.trim().length() == 0) {
            this.err(file + ": Empty copyright");
            ++this.c.nEmpty;
            if (this.c.doRepair) {
                this.repair(file, comment, RepairType.MISSING);
            }
            return;
        }
        if (!cspat.matcher(comment).find()) {
            this.err(file + ": No copyright");
            ++this.c.nMissing;
            if (this.c.doRepair) {
                this.repair(file, comment, RepairType.MISSING);
            }
            return;
        }
        if (!(this.matches(this.cpat, comment) || !this.c.normalize && this.matches(this.dcpatlist, comment) || !this.c.normalize && this.matches(this.acpatlist, comment) || this.matches(this.bpat, comment) || this.matches(apat, comment) || this.matches(anpat, comment) || this.matches(oapat, comment))) {
            if (this.matches(sunpat, comment)) {
                this.err(file + ": Sun copyright");
                ++this.c.nSun;
            } else if (this.matches(sunapat, comment) || this.matches(sunanewpat, comment)) {
                this.err(file + ": Sun+Apache copyright");
                ++this.c.nSunApache;
            } else if (this.matches(sunbpat, comment)) {
                this.err(file + ": Sun BSD copyright");
                ++this.c.nSunBSD;
            } else if (this.matches(ocpat, comment) || this.matches(oc2pat, comment)) {
                this.err(file + ": Old CDDL copyright");
                ++this.c.nOldCDDL;
            } else if (this.matches(cnocepat, comment)) {
                this.err(file + ": CDDL+GPL-CE copyright");
                ++this.c.nNoCE;
            } else {
                this.err(file + ": Wrong copyright");
                ++this.c.nWrong;
            }
            if (this.c.doRepair) {
                this.repair(file, comment, RepairType.WRONG);
            }
            return;
        }
        if (this.matches(anpat, comment)) {
            return;
        }
        Matcher m = ypat.matcher(comment);
        if (!m.find()) {
            this.err(file + ": No copyright year");
            ++this.c.nNoYear;
            return;
        }
        if (this.c.ignoreYear) {
            if (this.c.verbose) {
                System.out.println("Ignoring year check: " + file);
            }
            return;
        }
        String year = m.group(2);
        int lastYearIndex = year.length() - 4;
        if (year.endsWith(",")) {
            --lastYearIndex;
        }
        String lastYear = year.substring(lastYearIndex, lastYearIndex + 4);
        if (this.isModified(file.getPath())) {
            lc = thisYear;
        } else if (lc == null) {
            lc = this.lastChanged(file.getPath());
        }
        if (!lastYear.equals(lc)) {
            this.err(file + ": Copyright year is wrong; is " + lastYear + ", should be " + lc);
            ++this.c.nDate;
            if (this.c.doRepair) {
                this.repair(file, comment, RepairType.DATE);
            }
            return;
        }
        if (this.c.verbose) {
            System.out.println("No errors: " + file);
        }
    }

    protected boolean matches(Pattern pat, String s) {
        return pat.matcher(s).matches();
    }

    protected boolean matches(List<Pattern> patlist, String s) {
        for (Pattern pat : patlist) {
            if (!pat.matcher(s).matches()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void repair(File file, String comment, RepairType type) throws IOException {
        File newfile = new File(file.getParent(), file.getName() + ".new");
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "iso-8859-1"));
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newfile), "iso-8859-1"));
            switch (type) {
                case MISSING: {
                    this.replaceCopyright(in, out, null, thisYear);
                    break;
                }
                case WRONG: {
                    this.replaceCopyright(in, out, comment, thisYear);
                    break;
                }
                case DATE: {
                    if (this.c.normalize) {
                        this.replaceCopyright(in, out, comment, thisYear);
                        break;
                    }
                    this.updateCopyright(in, out, thisYear);
                }
            }
            this.copy(in, out, true);
            if (!this.c.dontUpdate) {
                in.close();
                out.close();
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(newfile), "iso-8859-1"));
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "iso-8859-1"));
                this.copy(in, out, false);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
            if (!this.c.dontUpdate) {
                newfile.delete();
            }
        }
    }

    protected void writeCopyright(BufferedWriter out, String year, String comment) throws IOException {
        String copyright = this.correctCopyright;
        String secondaryLicense = null;
        boolean preserve = this.c.preserveCopyrights;
        if (comment != null) {
            if (bsdpat.matcher(comment).find()) {
                copyright = this.correctBSDCopyright;
            } else {
                Matcher m = secLicPat.matcher(comment);
                if (m.find()) {
                    secondaryLicense = comment.substring(m.start());
                    if (secondaryLicense.length() > 0) {
                        copyright = copyright + "\n\n" + secondaryLicense;
                    }
                    if (secondaryLicense.indexOf("Apache") >= 0) {
                        Matcher y;
                        int nl = secondaryLicense.indexOf("\n\n");
                        if (nl > 0 && (y = ypat.matcher(copyright = secondaryLicense.substring(nl + 2))).find()) {
                            copyright = copyright.substring(0, y.start(2)) + "YYYY" + copyright.substring(y.end(2));
                        }
                        preserve = true;
                    } else {
                        comment = comment.substring(0, m.start() - 1);
                    }
                } else if (comment.contains("Apache")) {
                    copyright = comment;
                    Matcher y = ypat.matcher(copyright);
                    if (y.find()) {
                        copyright = copyright.substring(0, y.start(2)) + "YYYY" + copyright.substring(y.end(2));
                    }
                    preserve = true;
                }
            }
            copyright = preserve ? this.fixCopyright(copyright, this.getCopyrights(comment), year, licensor) : this.fixCopyright(copyright, year, licensor);
        } else {
            copyright = this.fixCopyright(copyright, year, licensor);
        }
        out.write(this.toComment(copyright));
    }

    protected abstract void replaceCopyright(BufferedReader var1, BufferedWriter var2, String var3, String var4) throws IOException;

    protected abstract void updateCopyright(BufferedReader var1, BufferedWriter var2, String var3) throws IOException;

    protected abstract String toComment(String var1);

    protected abstract String readComment(BufferedReader var1) throws IOException;

    protected void warnCopyright(File file, BufferedReader in) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            Matcher m = ypat.matcher(line);
            if (!m.find() || line.indexOf(licensor) >= 0) continue;
            System.out.println(file + ": WARNING: extra copyright: " + line);
        }
    }

    protected void copy(BufferedReader in, BufferedWriter out, boolean skipBlanks) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            if (skipBlanks) {
                if (line.trim().length() == 0) continue;
                skipBlanks = false;
            }
            out.write(line);
            out.write(10);
        }
    }

    protected String addCopyrightDate(String date, String lastChanged) {
        if (date.endsWith(",")) {
            date = date.substring(0, date.length() - 1);
        }
        if (date.length() == 4) {
            if (!date.equals(lastChanged)) {
                date = this.c.useComma ? date + ", " + lastChanged : date + "-" + lastChanged;
            }
        } else {
            char sep;
            String lastDate = date.substring(date.length() - 4, date.length());
            char c = sep = this.c.useComma ? (char)',' : '-';
            if (!(lastDate.equals(lastChanged) && date.charAt(5) == sep || (date = date.substring(0, 4)).equals(lastChanged))) {
                date = this.c.useComma ? date + ", " + lastChanged : date + "-" + lastChanged;
            }
        }
        return date;
    }

    protected List<String> getCopyrights(String s) {
        ArrayList<String> ret = new ArrayList<String>();
        Matcher m = ylpat.matcher(s);
        while (m.find()) {
            String cline = m.group();
            ret.add(cline);
        }
        return ret;
    }

    protected String fixCopyright(String cr, String date, String lic) {
        Matcher m = crpat.matcher(cr);
        return m.replaceFirst(date + " " + lic + ". " + allrights);
    }

    protected String fixCopyright(String cr, List<String> crs, String date, String lic) {
        StringBuffer sb = new StringBuffer();
        Matcher m = ytpat.matcher(cr);
        boolean needBlank = true;
        if (m.find()) {
            m.appendReplacement(sb, "");
            needBlank = false;
        }
        boolean found = false;
        for (String s : crs) {
            if (s.indexOf(lic) < 0) continue;
            found = true;
            break;
        }
        if (!found && !crs.isEmpty()) {
            crs.add(0, "Copyright (c) " + date + " " + lic + ". " + allrights);
        }
        found = false;
        for (String s : crs) {
            if (!found && s.indexOf(lic) >= 0) {
                found = true;
                Matcher m2 = ylpat.matcher(s);
                if (m2.find()) {
                    sb.append(s.substring(0, m2.start(2)));
                    sb.append(date);
                    sb.append(s.substring(m2.end(2)));
                    sb.append('\n');
                    continue;
                }
                sb.append(s).append('\n');
                continue;
            }
            if (found && s.contains("Sun Microsystems")) continue;
            sb.append(s).append('\n');
        }
        if (needBlank) {
            sb.append('\n');
        }
        m.appendTail(sb);
        return sb.toString();
    }

    protected static String strip(String line) {
        for (int i = line.length() - 1; i >= 0; --i) {
            char c = line.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return line.substring(0, i + 1);
        }
        return "";
    }

    protected static String findPrefix(String line) {
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '\"' && c != '[' && c != '(') continue;
            return line.substring(0, i);
        }
        return "";
    }

    protected static boolean startsWith(String s, String prefix) {
        return s.trim().regionMatches(true, 0, prefix, 0, prefix.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean startsWith(File file, String prefix) {
        boolean bl;
        BufferedReader r = null;
        try {
            r = new BufferedReader(new FileReader(file));
            int len = prefix.length();
            for (int i = 0; i < len; ++i) {
                int c;
                while ((c = r.read()) == 13) {
                }
                if (c == prefix.charAt(i)) continue;
                boolean bl2 = false;
                return bl2;
            }
            bl = true;
            return bl;
        }
        catch (IOException ex) {
            bl = false;
            return bl;
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static Pattern getCopyrightPattern(String name) throws IOException {
        return AbstractCopyright.copyrightToPattern(AbstractCopyright.readCopyright(name, true, false));
    }

    private static Pattern getCopyrightPattern(File file) throws IOException {
        return AbstractCopyright.copyrightToPattern(AbstractCopyright.readCopyright(file, true, false));
    }

    private static Pattern getDerivedCopyrightPattern(String base, String file) throws IOException {
        return AbstractCopyright.copyrightToPattern(AbstractCopyright.readCopyright(base, true, false) + derivedCopyrightIntro + AbstractCopyright.readCopyright(file, true, true));
    }

    private static Pattern getDerivedCopyrightPattern(File base, String file) throws IOException {
        return AbstractCopyright.copyrightToPattern(AbstractCopyright.readCopyright(base, true, false) + derivedCopyrightIntro + AbstractCopyright.readCopyright(file, true, true));
    }

    private static Pattern copyrightToPattern(String comment) {
        StringBuilder copyright = new StringBuilder();
        copyright.append("(\\QTo change this template, choose Tools | Templates\nand open the template in the editor.\n\n\\E)?");
        copyright.append(comment);
        return Pattern.compile(copyright.toString(), 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readCopyright(String name, boolean pattern, boolean secondary) throws IOException {
        BufferedReader r = null;
        try {
            InputStream is = Copyright.class.getResourceAsStream("/META-INF/copyright-templates/" + name);
            if (is == null) {
                is = Copyright.class.getResourceAsStream(name);
            }
            r = new BufferedReader(new InputStreamReader(is));
            String string = AbstractCopyright.readCopyrightStream(r, pattern, secondary);
            return string;
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readCopyright(File file, boolean pattern, boolean secondary) throws IOException {
        BufferedReader r = null;
        try {
            r = new BufferedReader(new FileReader(file));
            String string = AbstractCopyright.readCopyrightStream(r, pattern, secondary);
            return string;
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }

    private static String readCopyrightStream(BufferedReader r, boolean pattern, boolean secondary) throws IOException {
        int len;
        StringBuilder copyright = new StringBuilder();
        String line = r.readLine();
        boolean sawCopyright = false;
        while ((line = r.readLine()) != null && !line.equals(" */")) {
            line = line.length() > 2 ? line.substring(3) : "";
            if (pattern && (line = Pattern.quote(line)).indexOf("YYYY") >= 0) {
                sawCopyright = true;
                line = line.replace("YYYY", "\\E[-0-9, ]+\\Q");
                if (!secondary) {
                    line = line.contains(licensor) ? line + "(\n" + COPYRIGHT_LINE + ")*" : "(^Copyright (\\(c\\) )?([-0-9, ]+) (by )?([A-Za-z].*)$\n)*" + line;
                }
            }
            copyright.append(line).append('\n');
        }
        if (!sawCopyright && pattern && !secondary) {
            copyright.insert(0, "((^Copyright (\\(c\\) )?([-0-9, ]+) (by )?([A-Za-z].*)$\n)+\n)?");
        }
        if ((len = copyright.length()) >= 2 && copyright.charAt(len - 1) == '\n' && copyright.charAt(len - 2) == '\n') {
            copyright.setLength(len - 1);
        }
        return copyright.toString();
    }

    private static String getCopyrightText(String name) throws IOException {
        return AbstractCopyright.readCopyright(name, false, false);
    }

    private static String getCopyrightText(File file) throws IOException {
        return AbstractCopyright.readCopyright(file, false, false);
    }

    protected String lastChanged(String file) throws IOException {
        if (this.c.mercurial) {
            return AbstractCopyright.lastChangedHg(file);
        }
        if (this.c.git) {
            return AbstractCopyright.lastChangedGit(file);
        }
        return AbstractCopyright.lastChangedSvn(file);
    }

    private static String lastChangedSvn(String file) throws IOException {
        String line;
        String lastChangedDate = "Last Changed Date: ";
        String addedFile = "Schedule: add";
        ProcessBuilder pb = new ProcessBuilder("svn", "info", file);
        pb.redirectErrorStream(true);
        Process p = pb.start();
        p.getOutputStream().close();
        BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String lcd = "";
        while ((line = r.readLine()) != null) {
            if (line.equals("Schedule: add")) {
                lcd = thisYear;
            }
            if (!line.startsWith("Last Changed Date: ")) continue;
            lcd = line.substring("Last Changed Date: ".length(), "Last Changed Date: ".length() + 4);
        }
        p.getInputStream().close();
        try {
            p.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return lcd;
    }

    private static String lastChangedHg(String file) throws IOException {
        String line;
        ProcessBuilder pb = new ProcessBuilder("hg", "log", "--limit", "1", "--template", "{date|shortdate}", file);
        pb.redirectErrorStream(true);
        Process p = pb.start();
        p.getOutputStream().close();
        BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String lcd = "";
        while ((line = r.readLine()) != null) {
            if (line.length() != 10 || !Character.isDigit(line.charAt(0))) continue;
            lcd = line.substring(0, 4);
        }
        p.getInputStream().close();
        try {
            p.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return lcd;
    }

    private static String lastChangedGit(String file) throws IOException {
        String line;
        ProcessBuilder pb = new ProcessBuilder("git", "log", "-n", "1", "--date=local", file);
        pb.redirectErrorStream(true);
        Process p = pb.start();
        p.getOutputStream().close();
        BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String lcd = "";
        while ((line = r.readLine()) != null) {
            if (!line.startsWith("Date:")) continue;
            String[] split = line.split(" ");
            lcd = split[split.length - 1];
        }
        p.getInputStream().close();
        try {
            p.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return lcd;
    }

    protected boolean isModified(String file) throws IOException {
        String line;
        ProcessBuilder pb = this.c.mercurial ? new ProcessBuilder("hg", "status", file) : (this.c.git ? new ProcessBuilder("git", "status", "-s", file) : new ProcessBuilder("svn", "status", file));
        pb.redirectErrorStream(true);
        Process p = pb.start();
        p.getOutputStream().close();
        BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
        boolean modified = false;
        while ((line = r.readLine()) != null) {
            if (!(line = line.trim()).startsWith("M") && !line.startsWith("A")) continue;
            modified = true;
        }
        p.getInputStream().close();
        try {
            p.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return modified;
    }

    protected void err(String s) {
        if (!this.c.quiet) {
            System.out.println(s);
        }
        ++this.c.errors;
    }

    static {
        ypat = Pattern.compile(COPYRIGHT_STRING);
        ylpat = Pattern.compile(COPYRIGHT_LINE, 8);
        ytpat = Pattern.compile(COPYRIGHT_LINE_TEMPLATE, 8);
        endPat = Pattern.compile(" *\\*/");
        secLicPat = Pattern.compile("^.*This file incorporates work covered by", 8);
        crpat = Pattern.compile("YYYY.*$", 8);
        cspat = Pattern.compile("(\\b[Cc]opyright\\b|\\([Cc]\\))", 8);
        bsdpat = Pattern.compile("(THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS)|(SPDX-License-Identifier: BSD-3-Clause)", 8);
        thisYear = "" + Calendar.getInstance().get(1);
        try {
            apat = AbstractCopyright.getCopyrightPattern("apacheold-copyright.txt");
            anpat = AbstractCopyright.getCopyrightPattern("apache-copyright.txt");
            oapat = AbstractCopyright.getCopyrightPattern("oracle-apache-copyright.txt");
            sunpat = AbstractCopyright.getCopyrightPattern("sun-cddl+gpl+ce-copyright.txt");
            sunapat = AbstractCopyright.getCopyrightPattern("sun-cddl+gpl+ce+apache-copyright.txt");
            sunanewpat = AbstractCopyright.getCopyrightPattern("sun-cddl+gpl+ce+apachenew-copyright.txt");
            sunbpat = AbstractCopyright.getCopyrightPattern("sun-bsd-copyright.txt");
            cnocepat = AbstractCopyright.getCopyrightPattern("cddl+gpl-copyright.txt");
            ocpat = AbstractCopyright.getCopyrightPattern("cddl-copyright.txt");
            oc2pat = AbstractCopyright.getCopyrightPattern("cddl2-copyright.txt");
        }
        catch (IOException ex) {
            throw new RuntimeException("Copyright resource missing", ex);
        }
    }

    static enum RepairType {
        MISSING,
        WRONG,
        DATE;

    }
}

