/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.copyright;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.glassfish.copyright.AbstractCopyright;
import org.glassfish.copyright.AsciidocCopyright;
import org.glassfish.copyright.BatCopyright;
import org.glassfish.copyright.JavaCopyright;
import org.glassfish.copyright.JspCopyright;
import org.glassfish.copyright.MarkdownCopyright;
import org.glassfish.copyright.PropertiesCopyright;
import org.glassfish.copyright.SigCopyright;
import org.glassfish.copyright.TextCopyright;
import org.glassfish.copyright.Version;
import org.glassfish.copyright.XmlCopyright;

public class Copyright {
    public boolean debug = false;
    public boolean warn = true;
    public boolean ignoreYear = false;
    public boolean useDash = false;
    public boolean doRepair = false;
    public boolean dontUpdate = false;
    public boolean normalize = false;
    public boolean skipNoSVN = false;
    public boolean doHidden = false;
    public boolean mercurial = false;
    public boolean git = true;
    public static boolean count = false;
    public boolean quiet = false;
    public boolean doJava = false;
    public boolean doXml = false;
    public boolean doProps = false;
    public boolean doText = false;
    public boolean preserveCopyrights = false;
    public boolean verbose = false;
    public File correctTemplate;
    public List<File> alternateTemplates = new ArrayList<File>();
    public File correctBSDTemplate;
    public int nMissing;
    public int nEmpty;
    public int nSun;
    public int nSunApache;
    public int nSunBSD;
    public int nOldBSD;
    public int nOldCDDL;
    public int nCDDLGPLCE;
    public int nNoCE;
    public int nWrong;
    public int nNoYear;
    public int nDate;
    public int errors;
    public List<String> excludes = new ArrayList<String>();
    private AbstractCopyright javaCopyright;
    private AbstractCopyright xmlCopyright;
    private AbstractCopyright textCopyright;
    private AbstractCopyright sigCopyright;
    private AbstractCopyright propsCopyright;
    private AbstractCopyright batCopyright;
    private AbstractCopyright mdCopyright;
    private AbstractCopyright adCopyright;
    private AbstractCopyright jspCopyright;
    public static final List<String> ignoredDirs = Collections.unmodifiableList(Arrays.asList(".m2", ".svn", ".hg", ".git", "target"));

    private void init() {
        if (this.javaCopyright == null) {
            this.javaCopyright = new JavaCopyright(this);
            this.xmlCopyright = new XmlCopyright(this);
            this.textCopyright = new TextCopyright(this);
            this.sigCopyright = new SigCopyright(this);
            this.propsCopyright = new PropertiesCopyright(this);
            this.batCopyright = new BatCopyright(this);
            this.mdCopyright = new MarkdownCopyright(this);
            this.adCopyright = new AsciidocCopyright(this);
            this.jspCopyright = new JspCopyright(this);
            if (!(this.doJava || this.doXml || this.doProps || this.doText)) {
                this.doText = true;
                this.doProps = true;
                this.doXml = true;
                this.doJava = true;
            }
        }
    }

    public void check(File file) throws IOException {
        this.init();
        this.check(file, false);
    }

    public void checkMaven(File file) throws IOException {
        this.init();
        if (!file.exists()) {
            System.out.println(file + ": doesn't exist");
            return;
        }
        if (!file.canRead()) {
            System.out.println(file + ": can't read");
            return;
        }
        if (!this.doHidden && file.isHidden() && !file.getName().equals(".")) {
            return;
        }
        if (file.isDirectory()) {
            File[] files;
            String name = file.getName();
            if (ignoredDirs.contains(name)) {
                return;
            }
            for (File f : files = file.listFiles()) {
                this.check(f, true);
            }
        } else {
            this.checkFile(file);
        }
    }

    private void check(File file, boolean skipMavenDir) throws IOException {
        if (!file.exists()) {
            System.out.println(file + ": doesn't exist");
            return;
        }
        if (!file.canRead()) {
            System.out.println(file + ": can't read");
            return;
        }
        if (!this.doHidden && file.isHidden() && !file.getName().equals(".")) {
            if (this.verbose) {
                System.out.println("Hidden file skipped: " + file);
            }
            return;
        }
        if (file.isDirectory()) {
            File[] files;
            File pom;
            String name = file.getName();
            if (ignoredDirs.contains(name)) {
                if (this.verbose) {
                    System.out.println("Ignored directory skipped: " + file);
                }
                return;
            }
            if (skipMavenDir && (pom = new File(file, "pom.xml")).exists()) {
                if (this.verbose) {
                    System.out.println("Maven subproject skipped: " + file);
                }
                return;
            }
            for (File f : files = file.listFiles()) {
                this.check(f);
            }
        } else {
            this.checkFile(file);
        }
    }

    private void checkFile(File file) throws IOException {
        if (file.length() == 0L) {
            if (this.verbose) {
                System.out.println("Empty file, skipped: " + file);
            }
            return;
        }
        String pname = file.getPath();
        for (String ex : this.excludes) {
            if (pname.indexOf(ex) < 0) continue;
            if (this.verbose) {
                System.out.println("Excluded by pattern \"" + ex + "\": " + pname);
            }
            return;
        }
        if (this.javaCopyright.supports(file)) {
            if (this.debug) {
                System.out.println("File " + file + " is a Java file");
            }
            if (this.doJava) {
                this.javaCopyright.checkCopyright(file);
            }
        } else if (this.jspCopyright.supports(file)) {
            if (this.debug) {
                System.out.println("File " + file + " is a JSP file");
            }
            if (this.doXml) {
                this.jspCopyright.checkCopyright(file);
            }
        } else if (this.xmlCopyright.supports(file)) {
            if (this.debug) {
                System.out.println("File " + file + " is an XML file");
            }
            if (this.doXml) {
                this.xmlCopyright.checkCopyright(file);
            }
        } else if (this.batCopyright.supports(file)) {
            if (this.debug) {
                System.out.println("File " + file + " is a BAT file");
            }
            if (this.doText) {
                this.batCopyright.checkCopyright(file);
            }
        } else if (this.mdCopyright.supports(file)) {
            if (this.debug) {
                System.out.println("File " + file + " is a markdown file");
            }
            if (this.doText) {
                this.mdCopyright.checkCopyright(file);
            }
        } else if (this.adCopyright.supports(file)) {
            if (this.debug) {
                System.out.println("File " + file + " is an asciidoc file");
            }
            if (this.doText) {
                this.adCopyright.checkCopyright(file);
            }
        } else if (this.sigCopyright.supports(file)) {
            if (this.debug) {
                System.out.println("File " + file + " is a signature file");
            }
            if (this.doProps) {
                this.sigCopyright.checkCopyright(file);
            }
        } else if (this.propsCopyright.supports(file)) {
            if (this.debug) {
                System.out.println("File " + file + " is a properties file");
            }
            if (this.doProps) {
                this.propsCopyright.checkCopyright(file);
            }
        } else {
            if (this.debug) {
                System.out.println("File " + file + " is a text file");
            }
            if (this.doText) {
                this.textCopyright.checkCopyright(file);
            }
        }
    }

    public void addExclude(String ex) {
        if (ex == null || ex.length() == 0) {
            return;
        }
        if (this.debug) {
            System.out.println("Add exclude: " + ex);
        }
        this.excludes.add(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExcludes(String file) throws IOException {
        BufferedReader r = null;
        try {
            String line;
            r = new BufferedReader(new FileReader(file));
            while ((line = r.readLine()) != null) {
                if (line.trim().startsWith("#")) continue;
                this.addExclude(line);
            }
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void main(String[] argv) throws Exception {
        int optind;
        Copyright c = new Copyright();
        for (optind = 0; optind < argv.length; ++optind) {
            if (argv[optind].equals("-d")) {
                c.debug = true;
                continue;
            }
            if (argv[optind].equals("-w")) {
                c.warn = false;
                continue;
            }
            if (argv[optind].equals("-y")) {
                c.ignoreYear = true;
                continue;
            }
            if (argv[optind].equals("-N")) {
                c.normalize = true;
                continue;
            }
            if (argv[optind].equals("-D")) {
                c.useDash = true;
                continue;
            }
            if (argv[optind].equals("-r")) {
                c.doRepair = true;
                continue;
            }
            if (argv[optind].equals("-n")) {
                c.dontUpdate = true;
                continue;
            }
            if (argv[optind].equals("-s")) {
                c.skipNoSVN = true;
                continue;
            }
            if (argv[optind].equals("-h")) {
                c.doHidden = true;
                continue;
            }
            if (argv[optind].equals("-m")) {
                c.mercurial = true;
                continue;
            }
            if (argv[optind].equals("-g")) {
                c.git = true;
                continue;
            }
            if (argv[optind].equals("-S")) {
                c.git = false;
                continue;
            }
            if (argv[optind].equals("-c")) {
                count = true;
                continue;
            }
            if (argv[optind].equals("-q")) {
                c.quiet = true;
                continue;
            }
            if (argv[optind].equals("-j")) {
                c.doJava = true;
                continue;
            }
            if (argv[optind].equals("-x")) {
                c.doXml = true;
                continue;
            }
            if (argv[optind].equals("-p")) {
                c.doProps = true;
                continue;
            }
            if (argv[optind].equals("-t")) {
                c.doText = true;
                continue;
            }
            if (argv[optind].equals("-X")) {
                String ex;
                if ((ex = argv[++optind]).startsWith("@")) {
                    c.addExcludes(ex.substring(1));
                    continue;
                }
                c.addExclude(ex);
                continue;
            }
            if (argv[optind].equals("-C")) {
                c.correctTemplate = new File(argv[++optind]);
                continue;
            }
            if (argv[optind].equals("-A")) {
                for (String alt : argv[++optind].split(File.pathSeparator)) {
                    c.alternateTemplates.add(new File(alt));
                }
                continue;
            }
            if (argv[optind].equals("-B")) {
                c.correctBSDTemplate = new File(argv[++optind]);
                continue;
            }
            if (argv[optind].equals("-P")) {
                c.preserveCopyrights = true;
                continue;
            }
            if (argv[optind].equals("-v")) {
                c.verbose = true;
                continue;
            }
            if (argv[optind].equals("-V")) {
                System.out.println("Version: " + Version.getVersion());
                System.exit(0);
                continue;
            }
            if (argv[optind].equals("--")) {
                ++optind;
                break;
            }
            if (!argv[optind].startsWith("-")) break;
            System.out.println("Usage: copyright [-w] [-y] [-r] [-n] [-s] [-h] [-m] [-c] [-S] [-q] [-j] [-x] [-p] [-t] [-N] [-D] [-V] [-X pat] [-C file] [-A file(s)] [-B file] [-P] [-v] [files...]");
            System.out.println("\t-w\tsuppress warnings");
            System.out.println("\t-y\tdon't check that year is correct (much faster)");
            System.out.println("\t-r\trepair files that are wrong");
            System.out.println("\t-n\twith -r, leave the updated file in file.new");
            System.out.println("\t-s\tskip files not under source control (slower)");
            System.out.println("\t-h\tcheck hidden files too");
            System.out.println("\t-m\tuse Mercurial");
            System.out.println("\t-g\tuse Git (default)");
            System.out.println("\t-S\tuse SVN");
            System.out.println("\t-c\tcount errors and print summary");
            System.out.println("\t-q\tdon't print errors for each file");
            System.out.println("\t-j\tcheck Java syntax files");
            System.out.println("\t-x\tcheck XML syntax files");
            System.out.println("\t-p\tcheck properties syntax files");
            System.out.println("\t-t\tcheck other text files");
            System.out.println("\t-N\tnormalize format of repaired copyright to match template");
            System.out.println("\t-D\tdash instead of comma between years");
            System.out.println("\t-X\texclude files matching pat (substring only)");
            System.out.println("\t-C\tfile containing correct copyright template, using Java syntax");
            System.out.println("\t-A\tfile(s) containing alternate correct copyright template(s)");
            System.out.println("\t-B\tfile containing correct BSD copyright template");
            System.out.println("\t-P\tpreserve original copyrights");
            System.out.println("\t-v\tverbose output");
            System.out.println("\t-V\tprint version number");
            System.exit(-1);
        }
        if (optind >= argv.length) {
            c.check(new File("."));
        } else {
            while (optind < argv.length) {
                c.check(new File(argv[optind++]));
            }
        }
        if (count) {
            Copyright.summary(c);
        }
        System.exit(c.errors);
    }

    private static void summary(Copyright c) {
        if (c.errors == 0) {
            System.out.println("No errors");
            return;
        }
        if (!c.quiet) {
            System.out.println();
        }
        if (c.nMissing > 0) {
            System.out.println("No Copyright:\t\t" + c.nMissing);
        }
        if (c.nEmpty > 0) {
            System.out.println("Empty Copyright:\t" + c.nEmpty);
        }
        if (c.nSun > 0) {
            System.out.println("Sun Copyright:\t" + c.nSun);
        }
        if (c.nSunApache > 0) {
            System.out.println("Sun+Apache Copyright:\t" + c.nSunApache);
        }
        if (c.nSunBSD > 0) {
            System.out.println("Sun BSD Copyright:\t" + c.nSunBSD);
        }
        if (c.nOldBSD > 0) {
            System.out.println("Old BSD Copyright:\t" + c.nOldBSD);
        }
        if (c.nOldCDDL > 0) {
            System.out.println("Old CDDL Copyright:\t" + c.nOldCDDL);
        }
        if (c.nCDDLGPLCE > 0) {
            System.out.println("CDL+GPL+CE Copyright:\t" + c.nCDDLGPLCE);
        }
        if (c.nNoCE > 0) {
            System.out.println("Copyright without CE:\t" + c.nNoCE);
        }
        if (c.nWrong > 0) {
            System.out.println("Wrong Copyright:\t" + c.nWrong);
        }
        if (c.nNoYear > 0) {
            System.out.println("No Copyright Year:\t" + c.nNoYear);
        }
        if (!c.ignoreYear && c.nDate > 0) {
            System.out.println("Wrong Copyright Date:\t" + c.nDate);
        }
    }
}

