/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.copyright;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.copyright.AbstractCopyright;
import org.glassfish.copyright.Copyright;

public class TextCopyright
extends AbstractCopyright {
    public TextCopyright(Copyright c) {
        super(c);
    }

    @Override
    protected boolean supports(File file) {
        return true;
    }

    @Override
    protected String readComment(BufferedReader r) throws IOException {
        String line;
        StringBuilder comment = new StringBuilder();
        int nlines = 0;
        while ((line = r.readLine()) != null) {
            String cline = TextCopyright.canon(line);
            if (comment.length() == 0 && (line.startsWith("#!") || cline.length() == 0)) continue;
            comment.append(cline).append('\n');
            if (++nlines < 100) continue;
            break;
        }
        return comment.toString();
    }

    @Override
    protected boolean matches(Pattern pat, String s) {
        Matcher m = pat.matcher(s);
        return m.find() && m.start() == 0;
    }

    @Override
    protected void repair(File file, String comment, AbstractCopyright.RepairType type) throws IOException {
    }

    @Override
    protected void replaceCopyright(BufferedReader in, BufferedWriter out, String comment, String lastChanged) throws IOException {
    }

    @Override
    protected void updateCopyright(BufferedReader in, BufferedWriter out, String lastChanged) throws IOException {
    }

    @Override
    protected String toComment(String comment) {
        return comment;
    }

    private static String canon(String line) {
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '\"' && c != '[' && c != '(') continue;
            return line.substring(i).trim();
        }
        return "";
    }
}

