/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import sun.tools.java.ClassFile;

final class PathClassFile
extends ClassFile {
    private final Path path;
    private final BasicFileAttributes attrs;

    public PathClassFile(Path path) {
        this.path = path;
        try {
            this.attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException ioExp) {
            throw new UncheckedIOException(ioExp);
        }
    }

    @Override
    public boolean isZipped() {
        return false;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        return this.attrs.isDirectory();
    }

    @Override
    public long lastModified() {
        return this.attrs.lastModifiedTime().toMillis();
    }

    @Override
    public String getPath() {
        return this.path.toUri().toString();
    }

    @Override
    public String getName() {
        return this.path.getFileName().toString();
    }

    @Override
    public String getAbsoluteName() {
        return this.path.toAbsolutePath().toUri().toString();
    }

    @Override
    public long length() {
        return this.attrs.size();
    }

    public String toString() {
        return this.path.toString();
    }
}

