/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.tools.asm.Assembler;
import sun.tools.asm.CatchData;
import sun.tools.asm.Label;
import sun.tools.asm.TryData;
import sun.tools.java.ClassDefinition;
import sun.tools.java.Environment;
import sun.tools.java.Type;
import sun.tools.tree.CheckContext;
import sun.tools.tree.CodeContext;
import sun.tools.tree.Context;
import sun.tools.tree.LocalMember;
import sun.tools.tree.Statement;
import sun.tools.tree.Vset;

public class FinallyStatement
extends Statement {
    Statement body;
    Statement finalbody;
    boolean finallyCanFinish;
    boolean needReturnSlot;
    Statement init;
    LocalMember tryTemp;

    public FinallyStatement(long where, Statement body, Statement finalbody) {
        super(103, where);
        this.body = body;
        this.finalbody = finalbody;
    }

    @Override
    Vset check(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        vset = this.reach(env, vset);
        Hashtable<Object, Object> newexp = new Hashtable<Object, Object>();
        CheckContext newctx1 = new CheckContext(ctx, this);
        Vset vset1 = this.body.check(env, newctx1, vset.copy(), newexp).join(newctx1.vsBreak);
        CheckContext newctx2 = new CheckContext(ctx, this);
        newctx2.vsContinue = null;
        Vset vset2 = this.finalbody.check(env, newctx2, vset, exp);
        this.finallyCanFinish = !vset2.isDeadEnd();
        vset2 = vset2.join(newctx2.vsBreak);
        if (this.finallyCanFinish) {
            Enumeration<Object> e = newexp.keys();
            while (e.hasMoreElements()) {
                Object def = e.nextElement();
                exp.put(def, newexp.get(def));
            }
        }
        return ctx.removeAdditionalVars(vset1.addDAandJoinDU(vset2));
    }

    @Override
    public Statement inline(Environment env, Context ctx) {
        if (this.tryTemp != null) {
            ctx = new Context(ctx, this);
            ctx.declare(env, this.tryTemp);
        }
        if (this.init != null) {
            this.init = this.init.inline(env, ctx);
        }
        if (this.body != null) {
            this.body = this.body.inline(env, ctx);
        }
        if (this.finalbody != null) {
            this.finalbody = this.finalbody.inline(env, ctx);
        }
        if (this.body == null) {
            return this.eliminate(env, this.finalbody);
        }
        if (this.finalbody == null) {
            return this.eliminate(env, this.body);
        }
        return this;
    }

    @Override
    public Statement copyInline(Context ctx, boolean valNeeded) {
        FinallyStatement s = (FinallyStatement)this.clone();
        if (this.tryTemp != null) {
            s.tryTemp = this.tryTemp.copyInline(ctx);
        }
        if (this.init != null) {
            s.init = this.init.copyInline(ctx, valNeeded);
        }
        if (this.body != null) {
            s.body = this.body.copyInline(ctx, valNeeded);
        }
        if (this.finalbody != null) {
            s.finalbody = this.finalbody.copyInline(ctx, valNeeded);
        }
        return s;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        int cost = 4;
        if (this.init != null && (cost += this.init.costInline(thresh, env, ctx)) >= thresh) {
            return cost;
        }
        if (this.body != null && (cost += this.body.costInline(thresh, env, ctx)) >= thresh) {
            return cost;
        }
        if (this.finalbody != null) {
            cost += this.finalbody.costInline(thresh, env, ctx);
        }
        return cost;
    }

    @Override
    public void code(Environment env, Context ctx, Assembler asm) {
        ctx = new Context(ctx);
        Integer num1 = null;
        Integer num2 = null;
        Label endLabel = new Label();
        if (this.tryTemp != null) {
            ctx.declare(env, this.tryTemp);
        }
        if (this.init != null) {
            CodeContext exprctx = new CodeContext(ctx, this);
            this.init.code(env, exprctx, asm);
        }
        if (this.finallyCanFinish) {
            ClassDefinition thisClass = ctx.field.getClassDefinition();
            if (this.needReturnSlot) {
                Type returnType = ctx.field.getType().getReturnType();
                LocalMember localfield = new LocalMember(0L, thisClass, 0, returnType, idFinallyReturnValue);
                ctx.declare(env, localfield);
                Environment.debugOutput("Assigning return slot to " + localfield.number);
            }
            LocalMember f1 = new LocalMember(this.where, thisClass, 0, Type.tObject, null);
            LocalMember f2 = new LocalMember(this.where, thisClass, 0, Type.tInt, null);
            num1 = ctx.declare(env, f1);
            num2 = ctx.declare(env, f2);
        }
        TryData td = new TryData();
        td.add(null);
        CodeContext bodyctx = new CodeContext(ctx, this);
        asm.add(this.where, -3, td);
        this.body.code(env, bodyctx, asm);
        asm.add(bodyctx.breakLabel);
        asm.add(td.getEndLabel());
        if (this.finallyCanFinish) {
            asm.add(this.where, 168, bodyctx.contLabel);
            asm.add(this.where, 167, endLabel);
        } else {
            asm.add(this.where, 167, bodyctx.contLabel);
        }
        CatchData cd = td.getCatch(0);
        asm.add(cd.getLabel());
        if (this.finallyCanFinish) {
            asm.add(this.where, 58, num1);
            asm.add(this.where, 168, bodyctx.contLabel);
            asm.add(this.where, 25, num1);
            asm.add(this.where, 191);
        } else {
            asm.add(this.where, 87);
        }
        asm.add(bodyctx.contLabel);
        bodyctx.contLabel = null;
        bodyctx.breakLabel = endLabel;
        if (this.finallyCanFinish) {
            asm.add(this.where, 58, num2);
            this.finalbody.code(env, bodyctx, asm);
            asm.add(this.where, 169, num2);
        } else {
            this.finalbody.code(env, bodyctx, asm);
        }
        asm.add(endLabel);
    }

    @Override
    public void print(PrintStream out, int indent) {
        super.print(out, indent);
        out.print("try ");
        if (this.body != null) {
            this.body.print(out, indent);
        } else {
            out.print("<empty>");
        }
        out.print(" finally ");
        if (this.finalbody != null) {
            this.finalbody.print(out, indent);
        } else {
            out.print("<empty>");
        }
    }
}

