/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import sun.rmi.rmic.iiop.ClassType;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.IDLNames;
import sun.rmi.rmic.iiop.Type;
import sun.tools.java.ClassDefinition;
import sun.tools.java.CompilerError;
import sun.tools.java.Identifier;

public class SpecialClassType
extends ClassType {
    public static SpecialClassType forSpecial(ClassDefinition theClass, ContextStack stack) {
        if (stack.anyErrors()) {
            return null;
        }
        sun.tools.java.Type type = theClass.getType();
        String typeKey = type.toString() + stack.getContextCodeString();
        Type existing = SpecialClassType.getType(typeKey, stack);
        if (existing != null) {
            if (!(existing instanceof SpecialClassType)) {
                return null;
            }
            return (SpecialClassType)existing;
        }
        int typeCode = SpecialClassType.getTypeCode(type, theClass, stack);
        if (typeCode != 0) {
            SpecialClassType result = new SpecialClassType(stack, typeCode, theClass);
            SpecialClassType.putType(typeKey, (Type)result, stack);
            stack.push(result);
            stack.pop(true);
            return result;
        }
        return null;
    }

    @Override
    public String getTypeDescription() {
        return "Special class";
    }

    private SpecialClassType(ContextStack stack, int typeCode, ClassDefinition theClass) {
        super(stack, typeCode | 0x10000000 | 0x4000000 | 0x2000000, theClass);
        Identifier id = theClass.getName();
        String idlName = null;
        String[] idlModuleName = null;
        boolean constant = stack.size() > 0 && stack.getContext().isConstant();
        switch (typeCode) {
            case 512: {
                idlName = IDLNames.getTypeName(typeCode, constant);
                if (constant) break;
                idlModuleName = IDL_CORBA_MODULE;
                break;
            }
            case 1024: {
                idlName = "_Object";
                idlModuleName = IDL_JAVA_LANG_MODULE;
            }
        }
        this.setNames(id, idlModuleName, idlName);
        if (!this.initParents(stack)) {
            throw new CompilerError("SpecialClassType found invalid parent.");
        }
        this.initialize(null, null, null, stack, false);
    }

    private static int getTypeCode(sun.tools.java.Type type, ClassDefinition theClass, ContextStack stack) {
        if (type.isType(10)) {
            Identifier id = type.getClassName();
            if (id == idJavaLangString) {
                return 512;
            }
            if (id == idJavaLangObject) {
                return 1024;
            }
        }
        return 0;
    }
}

