/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import com.sun.corba.se.impl.util.PackagePrefixChecker;
import com.sun.corba.se.impl.util.Utility;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.Main;
import sun.rmi.rmic.iiop.AbstractType;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.ClassType;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.Generator;
import sun.rmi.rmic.iiop.IDLNames;
import sun.rmi.rmic.iiop.ImplementationType;
import sun.rmi.rmic.iiop.InterfaceType;
import sun.rmi.rmic.iiop.RemoteType;
import sun.rmi.rmic.iiop.StaticStringsHash;
import sun.rmi.rmic.iiop.StringComparator;
import sun.rmi.rmic.iiop.Type;
import sun.rmi.rmic.iiop.UserExceptionComparator;
import sun.rmi.rmic.iiop.Util;
import sun.rmi.rmic.iiop.ValueType;
import sun.tools.java.ClassDefinition;
import sun.tools.java.CompilerError;
import sun.tools.java.Identifier;

public class StubGenerator
extends Generator {
    private static final String DEFAULT_STUB_CLASS = "javax.rmi.CORBA.Stub";
    private static final String DEFAULT_TIE_CLASS = "org.omg.CORBA_2_3.portable.ObjectImpl";
    private static final String DEFAULT_POA_TIE_CLASS = "org.omg.PortableServer.Servant";
    protected boolean reverseIDs = false;
    protected boolean localStubs = true;
    protected boolean standardPackage = false;
    protected boolean useHash = true;
    protected String stubBaseClass = "javax.rmi.CORBA.Stub";
    protected String tieBaseClass = "org.omg.CORBA_2_3.portable.ObjectImpl";
    protected HashSet namesInUse = new HashSet();
    protected Hashtable classesInUse = new Hashtable();
    protected Hashtable imports = new Hashtable();
    protected int importCount = 0;
    protected String currentPackage = null;
    protected String currentClass = null;
    protected boolean castArray = false;
    protected Hashtable transactionalObjects = new Hashtable();
    protected boolean POATie = false;
    protected boolean emitPermissionCheck = false;
    private static final String NO_IMPORT = new String();
    static final String SINGLE_SLASH = "\\";
    static final String DOUBLE_SLASH = "\\\\";

    @Override
    public void generate(sun.rmi.rmic.BatchEnvironment env, ClassDefinition cdef, File destDir) {
        ((BatchEnvironment)env).setStandardPackage(this.standardPackage);
        super.generate(env, cdef, destDir);
    }

    @Override
    protected boolean requireNewInstance() {
        return false;
    }

    @Override
    protected boolean parseNonConforming(ContextStack stack) {
        return stack.getEnv().getParseNonConforming();
    }

    @Override
    protected CompoundType getTopType(ClassDefinition cdef, ContextStack stack) {
        CompoundType result = null;
        if (cdef.isInterface()) {
            result = AbstractType.forAbstract(cdef, stack, true);
            if (result == null) {
                result = RemoteType.forRemote(cdef, stack, false);
            }
        } else {
            result = ImplementationType.forImplementation(cdef, stack, false);
        }
        return result;
    }

    @Override
    public boolean parseArgs(String[] argv, Main main) {
        Object marker = new Object();
        this.reverseIDs = false;
        this.localStubs = true;
        this.useHash = true;
        this.stubBaseClass = DEFAULT_STUB_CLASS;
        this.transactionalObjects = new Hashtable();
        boolean result = super.parseArgs(argv, main);
        if (result) {
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i] == null) continue;
                String arg = argv[i].toLowerCase();
                if (arg.equals("-iiop")) {
                    argv[i] = null;
                    continue;
                }
                if (arg.equals("-xreverseids")) {
                    this.reverseIDs = true;
                    argv[i] = null;
                    continue;
                }
                if (arg.equals("-nolocalstubs")) {
                    this.localStubs = false;
                    argv[i] = null;
                    continue;
                }
                if (arg.equals("-xnohash")) {
                    this.useHash = false;
                    argv[i] = null;
                    continue;
                }
                if (argv[i].equals("-standardPackage")) {
                    this.standardPackage = true;
                    argv[i] = null;
                    continue;
                }
                if (argv[i].equals("-emitPermissionCheck")) {
                    this.emitPermissionCheck = true;
                    argv[i] = null;
                    continue;
                }
                if (arg.equals("-xstubbase")) {
                    argv[i] = null;
                    if (++i < argv.length && argv[i] != null && !argv[i].startsWith("-")) {
                        this.stubBaseClass = argv[i];
                        argv[i] = null;
                        continue;
                    }
                    main.error("rmic.option.requires.argument", "-Xstubbase");
                    result = false;
                    continue;
                }
                if (arg.equals("-xtiebase")) {
                    argv[i] = null;
                    if (++i < argv.length && argv[i] != null && !argv[i].startsWith("-")) {
                        this.tieBaseClass = argv[i];
                        argv[i] = null;
                        continue;
                    }
                    main.error("rmic.option.requires.argument", "-Xtiebase");
                    result = false;
                    continue;
                }
                if (arg.equals("-transactional")) {
                    for (int ctr = i + 1; ctr < argv.length; ++ctr) {
                        if (argv[ctr].charAt(1) == '-') continue;
                        this.transactionalObjects.put(argv[ctr], marker);
                        break;
                    }
                    argv[i] = null;
                    continue;
                }
                if (!arg.equals("-poa")) continue;
                this.POATie = true;
                argv[i] = null;
            }
        }
        this.tieBaseClass = this.POATie ? DEFAULT_POA_TIE_CLASS : DEFAULT_TIE_CLASS;
        return result;
    }

    @Override
    protected Generator.OutputType[] getOutputTypesFor(CompoundType topType, HashSet alreadyChecked) {
        int filter = 69632;
        Type[] genTypes = topType.collectMatching(filter, alreadyChecked);
        int count = genTypes.length;
        Vector<Generator.OutputType> list = new Vector<Generator.OutputType>(count + 5);
        BatchEnvironment theEnv = topType.getEnv();
        for (int i = 0; i < genTypes.length; ++i) {
            Type type = genTypes[i];
            String typeName = type.getName();
            boolean createStub = true;
            if (type instanceof ImplementationType) {
                list.addElement(new Generator.OutputType(Utility.tieNameForCompiler((String)typeName), type));
                int remoteInterfaceCount = 0;
                InterfaceType[] interfaces = ((CompoundType)type).getInterfaces();
                for (int j = 0; j < interfaces.length; ++j) {
                    if (!interfaces[j].isType(4096) || interfaces[j].isType(8192)) continue;
                    ++remoteInterfaceCount;
                }
                if (remoteInterfaceCount <= 1) {
                    createStub = false;
                }
            }
            if (type instanceof AbstractType) {
                createStub = false;
            }
            if (!createStub) continue;
            list.addElement(new Generator.OutputType(Utility.stubNameForCompiler((String)typeName), type));
        }
        Object[] outputTypes = new Generator.OutputType[list.size()];
        list.copyInto(outputTypes);
        return outputTypes;
    }

    @Override
    protected String getFileNameExtensionFor(Generator.OutputType outputType) {
        return ".java";
    }

    @Override
    protected void writeOutputFor(Generator.OutputType outputType, HashSet alreadyChecked, IndentingWriter writer) throws IOException {
        String fileName = outputType.getName();
        CompoundType theType = (CompoundType)outputType.getType();
        if (fileName.endsWith("_Stub")) {
            this.writeStub(outputType, writer);
        } else {
            this.writeTie(outputType, writer);
        }
    }

    protected void writeStub(Generator.OutputType outputType, IndentingWriter p) throws IOException {
        CompoundType theType = (CompoundType)outputType.getType();
        RemoteType[] remoteInterfaces = this.getDirectRemoteInterfaces(theType);
        p.pln("// Stub class generated by rmic, do not edit.");
        p.pln("// Contents subject to change without notice.");
        p.pln();
        this.setStandardClassesInUse(theType, true);
        this.addClassesInUse(theType, remoteInterfaces);
        this.writePackageAndImports(p);
        if (this.emitPermissionCheck) {
            p.pln("import java.security.AccessController;");
            p.pln("import java.security.PrivilegedAction;");
            p.pln("import java.io.SerializablePermission;");
            p.pln();
            p.pln();
        }
        p.p("public class " + this.currentClass);
        p.p(" extends " + this.getName(this.stubBaseClass));
        p.p(" implements ");
        if (remoteInterfaces.length > 0) {
            for (int i = 0; i < remoteInterfaces.length; ++i) {
                if (i > 0) {
                    p.pln(",");
                }
                String objName = this.testUtil(this.getName(remoteInterfaces[i]), theType);
                p.p(objName);
            }
        }
        if (!this.implementsRemote(theType)) {
            p.pln(",");
            p.p(this.getName("java.rmi.Remote"));
        }
        p.plnI(" {");
        p.pln();
        this.writeIds(p, theType, false);
        p.pln();
        if (this.emitPermissionCheck) {
            p.pln();
            p.plnI("private transient boolean _instantiated = false;");
            p.pln();
            p.pO();
            p.plnI("private static Void checkPermission() {");
            p.plnI("SecurityManager sm = System.getSecurityManager();");
            p.pln("if (sm != null) {");
            p.pI();
            p.plnI("sm.checkPermission(new SerializablePermission(");
            p.plnI("\"enableSubclassImplementation\"));");
            p.pO();
            p.pO();
            p.pOln("}");
            p.pln("return null;");
            p.pO();
            p.pOln("}");
            p.pln();
            p.pO();
            p.pI();
            p.plnI("private " + this.currentClass + "(Void ignore) {  }");
            p.pln();
            p.pO();
            p.plnI("public " + this.currentClass + "() { ");
            p.pln("this(checkPermission());");
            p.pln("_instantiated = true;");
            p.pOln("}");
            p.pln();
            p.plnI("private void readObject(java.io.ObjectInputStream s) throws IOException, ClassNotFoundException {");
            p.plnI("checkPermission();");
            p.pO();
            p.pln("s.defaultReadObject();");
            p.pln("_instantiated = true;");
            p.pOln("}");
            p.pln();
        }
        if (!this.emitPermissionCheck) {
            p.pI();
        }
        p.plnI("public String[] _ids() { ");
        p.pln("return (String[]) _type_ids.clone();");
        p.pOln("}");
        CompoundType.Method[] remoteMethods = theType.getMethods();
        int methodCount = remoteMethods.length;
        if (methodCount > 0) {
            boolean writeHeader = true;
            for (int i = 0; i < methodCount; ++i) {
                if (remoteMethods[i].isConstructor()) continue;
                if (writeHeader) {
                    writeHeader = false;
                }
                p.pln();
                this.writeStubMethod(p, remoteMethods[i], theType);
            }
        }
        this.writeCastArray(p);
        p.pOln("}");
    }

    void addClassInUse(String qualifiedName) {
        String unqualifiedName = qualifiedName;
        String packageName = null;
        int index = qualifiedName.lastIndexOf(46);
        if (index > 0) {
            unqualifiedName = qualifiedName.substring(index + 1);
            packageName = qualifiedName.substring(0, index);
        }
        this.addClassInUse(unqualifiedName, qualifiedName, packageName);
    }

    void addClassInUse(Type type) {
        if (!type.isPrimitive()) {
            Identifier id = type.getIdentifier();
            String name = IDLNames.replace(id.getName().toString(), ". ", ".");
            String packageName = type.getPackageName();
            String qualifiedName = packageName != null ? packageName + "." + name : name;
            this.addClassInUse(name, qualifiedName, packageName);
        }
    }

    void addClassInUse(Type[] types) {
        for (int i = 0; i < types.length; ++i) {
            this.addClassInUse(types[i]);
        }
    }

    void addStubInUse(Type type) {
        if (type.getIdentifier() != idCorbaObject && type.isType(2048)) {
            String stubName = this.getStubNameFor(type, false);
            String packageName = type.getPackageName();
            String fullName = packageName == null ? stubName : packageName + "." + stubName;
            this.addClassInUse(stubName, fullName, packageName);
        }
        if (type.isType(4096) || type.isType(524288)) {
            this.addClassInUse("javax.rmi.PortableRemoteObject");
        }
    }

    String getStubNameFor(Type type, boolean qualified) {
        String className = qualified ? type.getQualifiedName() : type.getName();
        String stubName = ((CompoundType)type).isCORBAObject() ? Utility.idlStubName((String)className) : Utility.stubNameForCompiler((String)className);
        return stubName;
    }

    void addStubInUse(Type[] types) {
        for (int i = 0; i < types.length; ++i) {
            this.addStubInUse(types[i]);
        }
    }

    void addClassInUse(String unqualifiedName, String qualifiedName, String packageName) {
        String currentName = (String)this.classesInUse.get(qualifiedName);
        if (currentName == null) {
            String importName = (String)this.imports.get(unqualifiedName);
            String nameToUse = null;
            if (packageName == null) {
                nameToUse = unqualifiedName;
            } else if (packageName.equals("java.lang")) {
                nameToUse = unqualifiedName;
                if (nameToUse.endsWith("_Stub")) {
                    nameToUse = Util.packagePrefix() + qualifiedName;
                }
            } else if (this.currentPackage != null && packageName.equals(this.currentPackage)) {
                nameToUse = unqualifiedName;
                if (importName != null) {
                    nameToUse = qualifiedName;
                }
            } else if (importName != null) {
                nameToUse = qualifiedName;
            } else if (qualifiedName.equals("org.omg.CORBA.Object")) {
                nameToUse = qualifiedName;
            } else if (unqualifiedName.indexOf(46) != -1) {
                nameToUse = qualifiedName;
            } else {
                nameToUse = unqualifiedName;
                this.imports.put(unqualifiedName, qualifiedName);
                ++this.importCount;
            }
            this.classesInUse.put(qualifiedName, nameToUse);
        }
    }

    String getName(Type type) {
        if (type.isPrimitive()) {
            return type.getName() + type.getArrayBrackets();
        }
        Identifier id = type.getIdentifier();
        String name = IDLNames.replace(id.toString(), ". ", ".");
        return this.getName(name) + type.getArrayBrackets();
    }

    String getExceptionName(Type type) {
        Identifier id = type.getIdentifier();
        return IDLNames.replace(id.toString(), ". ", ".");
    }

    String getName(String qualifiedName) {
        return (String)this.classesInUse.get(qualifiedName);
    }

    String getName(Identifier id) {
        return this.getName(id.toString());
    }

    String getStubName(Type type) {
        String stubName = this.getStubNameFor(type, true);
        return this.getName(stubName);
    }

    void setStandardClassesInUse(CompoundType type, boolean stub) throws IOException {
        this.currentPackage = type.getPackageName();
        this.imports.clear();
        this.classesInUse.clear();
        this.namesInUse.clear();
        this.importCount = 0;
        this.castArray = false;
        this.addClassInUse(type);
        this.currentClass = stub ? Utility.stubNameForCompiler((String)type.getName()) : Utility.tieNameForCompiler((String)type.getName());
        if (this.currentPackage == null) {
            this.addClassInUse(this.currentClass, this.currentClass, this.currentPackage);
        } else {
            this.addClassInUse(this.currentClass, this.currentPackage + "." + this.currentClass, this.currentPackage);
        }
        this.addClassInUse("javax.rmi.CORBA.Util");
        this.addClassInUse(idRemote.toString());
        this.addClassInUse(idRemoteException.toString());
        this.addClassInUse(idOutputStream.toString());
        this.addClassInUse(idInputStream.toString());
        this.addClassInUse(idSystemException.toString());
        this.addClassInUse(idJavaIoSerializable.toString());
        this.addClassInUse(idCorbaORB.toString());
        this.addClassInUse(idReplyHandler.toString());
        if (stub) {
            this.addClassInUse(this.stubBaseClass);
            this.addClassInUse("java.rmi.UnexpectedException");
            this.addClassInUse(idRemarshalException.toString());
            this.addClassInUse(idApplicationException.toString());
            if (this.localStubs) {
                this.addClassInUse("org.omg.CORBA.portable.ServantObject");
            }
        } else {
            this.addClassInUse(type);
            this.addClassInUse(this.tieBaseClass);
            this.addClassInUse(idTieInterface.toString());
            this.addClassInUse(idBadMethodException.toString());
            this.addClassInUse(idPortableUnknownException.toString());
            this.addClassInUse(idJavaLangThrowable.toString());
        }
    }

    void addClassesInUse(CompoundType type, RemoteType[] interfaces) {
        CompoundType.Method[] methods = type.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            this.addClassInUse(methods[i].getReturnType());
            this.addStubInUse(methods[i].getReturnType());
            this.addClassInUse(methods[i].getArguments());
            this.addStubInUse(methods[i].getArguments());
            this.addClassInUse(methods[i].getExceptions());
            this.addClassInUse(methods[i].getImplExceptions());
        }
        if (interfaces != null) {
            this.addClassInUse(interfaces);
        }
    }

    void writePackageAndImports(IndentingWriter p) throws IOException {
        if (this.currentPackage != null) {
            p.pln("package " + Util.correctPackageName(this.currentPackage, false, this.standardPackage) + ";");
            p.pln();
        }
        String[] names = new String[this.importCount];
        int index = 0;
        Enumeration e = this.imports.elements();
        while (e.hasMoreElements()) {
            String it = (String)e.nextElement();
            if (it == NO_IMPORT) continue;
            names[index++] = it;
        }
        Arrays.sort(names, new StringComparator());
        for (int i = 0; i < this.importCount; ++i) {
            if (Util.isOffendingPackage(names[i]) && names[i].endsWith("_Stub") && String.valueOf(names[i].charAt(names[i].lastIndexOf(".") + 1)).equals("_")) {
                p.pln("import " + PackagePrefixChecker.packagePrefix() + names[i] + ";");
                continue;
            }
            p.pln("import " + names[i] + ";");
        }
        p.pln();
        if (this.currentPackage != null && Util.isOffendingPackage(this.currentPackage)) {
            p.pln("import " + this.currentPackage + ".*  ;");
        }
        p.pln();
    }

    boolean implementsRemote(CompoundType theType) {
        boolean result;
        boolean bl = result = theType.isType(4096) && !theType.isType(8192);
        if (!result) {
            InterfaceType[] interfaces = theType.getInterfaces();
            for (int i = 0; i < interfaces.length && !(result = this.implementsRemote(interfaces[i])); ++i) {
            }
        }
        return result;
    }

    void writeStubMethod(IndentingWriter p, CompoundType.Method method, CompoundType theType) throws IOException {
        int i;
        String methodName = method.getName();
        String methodIDLName = method.getIDLName();
        Type[] paramTypes = method.getArguments();
        String[] paramNames = method.getArgumentNames();
        Type returnType = method.getReturnType();
        ValueType[] exceptions = this.getStubExceptions(method, false);
        boolean hasIOException = false;
        this.addNamesInUse(method);
        this.addNameInUse("_type_ids");
        String objName = this.testUtil(this.getName(returnType), returnType);
        p.p("public " + objName + " " + methodName + "(");
        for (i = 0; i < paramTypes.length; ++i) {
            if (i > 0) {
                p.p(", ");
            }
            p.p(this.getName(paramTypes[i]) + " " + paramNames[i]);
        }
        p.p(")");
        if (exceptions.length > 0) {
            p.p(" throws ");
            for (i = 0; i < exceptions.length; ++i) {
                if (i > 0) {
                    p.p(", ");
                }
                p.p(this.getExceptionName(exceptions[i]));
            }
        }
        p.plnI(" {");
        if (this.emitPermissionCheck) {
            p.pln("if ((System.getSecurityManager() != null) && (!_instantiated)) {");
            p.plnI("    throw new java.io.IOError(new java.io.IOException(\"InvalidObject \"));");
            p.pOln("}");
            p.pln();
        }
        if (this.localStubs) {
            this.writeLocalStubMethodBody(p, method, theType);
        } else {
            this.writeNonLocalStubMethodBody(p, method, theType);
        }
        p.pOln("}");
    }

    void writeLocalStubMethodBody(IndentingWriter p, CompoundType.Method method, CompoundType theType) throws IOException {
        String objName;
        String[] paramNames = method.getArgumentNames();
        Type returnType = method.getReturnType();
        ValueType[] exceptions = this.getStubExceptions(method, false);
        String methodName = method.getName();
        String methodIDLName = method.getIDLName();
        p.plnI("if (!Util.isLocal(this)) {");
        this.writeNonLocalStubMethodBody(p, method, theType);
        p.pOlnI("} else {");
        String so = this.getVariableName("so");
        p.pln("ServantObject " + so + " = _servant_preinvoke(\"" + methodIDLName + "\"," + this.getName(theType) + ".class);");
        p.plnI("if (" + so + " == null) {");
        if (!returnType.isType(1)) {
            p.p("return ");
        }
        p.p(methodName + "(");
        for (int i = 0; i < paramNames.length; ++i) {
            if (i > 0) {
                p.p(", ");
            }
            p.p(paramNames[i]);
        }
        p.pln(");");
        if (returnType.isType(1)) {
            p.pln("return ;");
        }
        p.pOln("}");
        p.plnI("try {");
        String[] argNames = this.writeCopyArguments(method, p);
        boolean copyReturn = StubGenerator.mustCopy(returnType);
        String resultName = null;
        if (!returnType.isType(1)) {
            if (copyReturn) {
                resultName = this.getVariableName("result");
                objName = this.testUtil(this.getName(returnType), returnType);
                p.p(objName + " " + resultName + " = ");
            } else {
                p.p("return ");
            }
        }
        objName = this.testUtil(this.getName(theType), theType);
        p.p("((" + objName + ")" + so + ".servant)." + methodName + "(");
        for (int i = 0; i < argNames.length; ++i) {
            if (i > 0) {
                p.p(", ");
            }
            p.p(argNames[i]);
        }
        if (copyReturn) {
            p.pln(");");
            objName = this.testUtil(this.getName(returnType), returnType);
            p.pln("return (" + objName + ")Util.copyObject(" + resultName + ",_orb());");
        } else {
            p.pln(");");
        }
        String e1 = this.getVariableName("ex");
        String e2 = this.getVariableName("exCopy");
        p.pOlnI("} catch (Throwable " + e1 + ") {");
        p.pln("Throwable " + e2 + " = (Throwable)Util.copyObject(" + e1 + ",_orb());");
        for (int i = 0; i < exceptions.length; ++i) {
            if (exceptions[i].getIdentifier() == idRemoteException || !exceptions[i].isType(32768)) continue;
            p.plnI("if (" + e2 + " instanceof " + this.getExceptionName(exceptions[i]) + ") {");
            p.pln("throw (" + this.getExceptionName(exceptions[i]) + ")" + e2 + ";");
            p.pOln("}");
        }
        p.pln("throw Util.wrapException(" + e2 + ");");
        p.pOlnI("} finally {");
        p.pln("_servant_postinvoke(" + so + ");");
        p.pOln("}");
        p.pOln("}");
    }

    void writeNonLocalStubMethodBody(IndentingWriter p, CompoundType.Method method, CompoundType theType) throws IOException {
        int i;
        int i2;
        String methodName = method.getName();
        String methodIDLName = method.getIDLName();
        Type[] paramTypes = method.getArguments();
        String[] paramNames = method.getArgumentNames();
        Type returnType = method.getReturnType();
        ValueType[] exceptions = this.getStubExceptions(method, true);
        String in = this.getVariableName("in");
        String out = this.getVariableName("out");
        String ex = this.getVariableName("ex");
        boolean needNewReadStreamClass = false;
        for (i2 = 0; i2 < exceptions.length; ++i2) {
            if (exceptions[i2].getIdentifier() == idRemoteException || !exceptions[i2].isType(32768) || !StubGenerator.needNewReadStreamClass(exceptions[i2])) continue;
            needNewReadStreamClass = true;
            break;
        }
        if (!needNewReadStreamClass) {
            for (i2 = 0; i2 < paramTypes.length; ++i2) {
                if (!StubGenerator.needNewReadStreamClass(paramTypes[i2])) continue;
                needNewReadStreamClass = true;
                break;
            }
        }
        if (!needNewReadStreamClass) {
            needNewReadStreamClass = StubGenerator.needNewReadStreamClass(returnType);
        }
        boolean needNewWriteStreamClass = false;
        for (int i3 = 0; i3 < paramTypes.length; ++i3) {
            if (!StubGenerator.needNewWriteStreamClass(paramTypes[i3])) continue;
            needNewWriteStreamClass = true;
            break;
        }
        p.plnI("try {");
        if (needNewReadStreamClass) {
            p.pln(idExtInputStream + " " + in + " = null;");
        } else {
            p.pln(idInputStream + " " + in + " = null;");
        }
        p.plnI("try {");
        String argStream = "null";
        if (needNewWriteStreamClass) {
            p.plnI(idExtOutputStream + " " + out + " = ");
            p.pln("(" + idExtOutputStream + ")");
            p.pln("_request(\"" + methodIDLName + "\", true);");
            p.pO();
        } else {
            p.pln("OutputStream " + out + " = _request(\"" + methodIDLName + "\", true);");
        }
        if (paramTypes.length > 0) {
            this.writeMarshalArguments(p, out, paramTypes, paramNames);
            p.pln();
        }
        argStream = out;
        if (returnType.isType(1)) {
            p.pln("_invoke(" + argStream + ");");
        } else {
            if (needNewReadStreamClass) {
                p.plnI(in + " = (" + idExtInputStream + ")_invoke(" + argStream + ");");
                p.pO();
            } else {
                p.pln(in + " = _invoke(" + argStream + ");");
            }
            p.p("return ");
            this.writeUnmarshalArgument(p, in, returnType, null);
            p.pln();
        }
        p.pOlnI("} catch (" + this.getName(idApplicationException) + " " + ex + ") {");
        if (needNewReadStreamClass) {
            p.pln(in + " = (" + idExtInputStream + ") " + ex + ".getInputStream();");
        } else {
            p.pln(in + " = " + ex + ".getInputStream();");
        }
        boolean idRead = false;
        boolean idAllocated = false;
        for (i = 0; i < exceptions.length; ++i) {
            if (exceptions[i].getIdentifier() == idRemoteException) continue;
            if (exceptions[i].isIDLEntityException() && !exceptions[i].isCORBAUserException()) {
                if (!idAllocated && !idRead) {
                    p.pln("String $_id = " + ex + ".getId();");
                    idAllocated = true;
                }
                String helperName = IDLNames.replace(exceptions[i].getQualifiedIDLName(false), "::", ".");
                helperName = helperName + "Helper";
                p.plnI("if ($_id.equals(" + helperName + ".id())) {");
                p.pln("throw " + helperName + ".read(" + in + ");");
            } else {
                if (!idAllocated && !idRead) {
                    p.pln("String $_id = " + in + ".read_string();");
                    idAllocated = true;
                    idRead = true;
                } else if (idAllocated && !idRead) {
                    p.pln("$_id = " + in + ".read_string();");
                    idRead = true;
                }
                p.plnI("if ($_id.equals(\"" + this.getExceptionRepositoryID(exceptions[i]) + "\")) {");
                p.pln("throw (" + this.getExceptionName(exceptions[i]) + ") " + in + ".read_value(" + this.getExceptionName(exceptions[i]) + ".class);");
            }
            p.pOln("}");
        }
        if (!idAllocated && !idRead) {
            p.pln("String $_id = " + in + ".read_string();");
            idAllocated = true;
            idRead = true;
        } else if (idAllocated && !idRead) {
            p.pln("$_id = " + in + ".read_string();");
            idRead = true;
        }
        p.pln("throw new UnexpectedException($_id);");
        p.pOlnI("} catch (" + this.getName(idRemarshalException) + " " + ex + ") {");
        if (!returnType.isType(1)) {
            p.p("return ");
        }
        p.p(methodName + "(");
        for (i = 0; i < paramTypes.length; ++i) {
            if (i > 0) {
                p.p(",");
            }
            p.p(paramNames[i]);
        }
        p.pln(");");
        p.pOlnI("} finally {");
        p.pln("_releaseReply(" + in + ");");
        p.pOln("}");
        p.pOlnI("} catch (SystemException " + ex + ") {");
        p.pln("throw Util.mapSystemException(" + ex + ");");
        p.pOln("}");
    }

    void allocateResult(IndentingWriter p, Type returnType) throws IOException {
        if (!returnType.isType(1)) {
            String objName = this.testUtil(this.getName(returnType), returnType);
            p.p(objName + " result = ");
        }
    }

    int getTypeCode(Type type) {
        int typeCode = type.getTypeCode();
        if (type instanceof CompoundType && ((CompoundType)type).isAbstractBase()) {
            typeCode = 8192;
        }
        return typeCode;
    }

    void writeMarshalArgument(IndentingWriter p, String streamName, Type type, String name) throws IOException {
        int typeCode = this.getTypeCode(type);
        switch (typeCode) {
            case 2: {
                p.p(streamName + ".write_boolean(" + name + ");");
                break;
            }
            case 4: {
                p.p(streamName + ".write_octet(" + name + ");");
                break;
            }
            case 8: {
                p.p(streamName + ".write_wchar(" + name + ");");
                break;
            }
            case 16: {
                p.p(streamName + ".write_short(" + name + ");");
                break;
            }
            case 32: {
                p.p(streamName + ".write_long(" + name + ");");
                break;
            }
            case 64: {
                p.p(streamName + ".write_longlong(" + name + ");");
                break;
            }
            case 128: {
                p.p(streamName + ".write_float(" + name + ");");
                break;
            }
            case 256: {
                p.p(streamName + ".write_double(" + name + ");");
                break;
            }
            case 512: {
                p.p(streamName + ".write_value(" + name + "," + this.getName(type) + ".class);");
                break;
            }
            case 1024: {
                p.p("Util.writeAny(" + streamName + "," + name + ");");
                break;
            }
            case 2048: {
                p.p(streamName + ".write_Object(" + name + ");");
                break;
            }
            case 4096: {
                p.p("Util.writeRemoteObject(" + streamName + "," + name + ");");
                break;
            }
            case 8192: {
                p.p("Util.writeAbstractObject(" + streamName + "," + name + ");");
                break;
            }
            case 16384: {
                p.p(streamName + ".write_value((Serializable)" + name + "," + this.getName(type) + ".class);");
                break;
            }
            case 32768: {
                p.p(streamName + ".write_value(" + name + "," + this.getName(type) + ".class);");
                break;
            }
            case 65536: {
                p.p(streamName + ".write_value((Serializable)" + name + "," + this.getName(type) + ".class);");
                break;
            }
            case 131072: {
                p.p(streamName + ".write_value((Serializable)" + name + "," + this.getName(type) + ".class);");
                break;
            }
            case 262144: {
                this.castArray = true;
                p.p(streamName + ".write_value(cast_array(" + name + ")," + this.getName(type) + ".class);");
                break;
            }
            case 524288: {
                p.p("Util.writeRemoteObject(" + streamName + "," + name + ");");
                break;
            }
            default: {
                throw new Error("unexpected type code: " + typeCode);
            }
        }
    }

    void writeUnmarshalArgument(IndentingWriter p, String streamName, Type type, String name) throws IOException {
        int typeCode = this.getTypeCode(type);
        if (name != null) {
            p.p(name + " = ");
        }
        switch (typeCode) {
            case 2: {
                p.p(streamName + ".read_boolean();");
                break;
            }
            case 4: {
                p.p(streamName + ".read_octet();");
                break;
            }
            case 8: {
                p.p(streamName + ".read_wchar();");
                break;
            }
            case 16: {
                p.p(streamName + ".read_short();");
                break;
            }
            case 32: {
                p.p(streamName + ".read_long();");
                break;
            }
            case 64: {
                p.p(streamName + ".read_longlong();");
                break;
            }
            case 128: {
                p.p(streamName + ".read_float();");
                break;
            }
            case 256: {
                p.p(streamName + ".read_double();");
                break;
            }
            case 512: {
                p.p("(String) " + streamName + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 1024: {
                if (type.getIdentifier() != idJavaLangObject) {
                    p.p("(" + this.getName(type) + ") ");
                }
                p.p("Util.readAny(" + streamName + ");");
                break;
            }
            case 2048: {
                if (type.getIdentifier() == idCorbaObject) {
                    p.p("(" + this.getName(type) + ") " + streamName + ".read_Object();");
                    break;
                }
                p.p("(" + this.getName(type) + ") " + streamName + ".read_Object(" + this.getStubName(type) + ".class);");
                break;
            }
            case 4096: {
                String objName = this.testUtil(this.getName(type), type);
                p.p("(" + objName + ") " + "PortableRemoteObject.narrow(" + streamName + ".read_Object(), " + objName + ".class);");
                break;
            }
            case 8192: {
                p.p("(" + this.getName(type) + ") " + streamName + ".read_abstract_interface();");
                break;
            }
            case 16384: {
                p.p("(" + this.getName(type) + ") " + streamName + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 32768: {
                p.p("(" + this.getName(type) + ") " + streamName + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 65536: {
                p.p("(" + this.getName(type) + ") " + streamName + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 131072: {
                p.p("(" + this.getName(type) + ") " + streamName + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 262144: {
                p.p("(" + this.getName(type) + ") " + streamName + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 524288: {
                p.p("(" + this.getName(type) + ") " + "PortableRemoteObject.narrow(" + streamName + ".read_Object(), " + this.getName(type) + ".class);");
                break;
            }
            default: {
                throw new Error("unexpected type code: " + typeCode);
            }
        }
    }

    String[] getAllRemoteRepIDs(CompoundType theType) {
        Object temp;
        String[] result;
        Type[] types = this.collectAllRemoteInterfaces(theType);
        int length = types.length;
        boolean haveImpl = theType instanceof ImplementationType;
        Type[] interfaces = theType.getInterfaces();
        int remoteCount = this.countRemote(interfaces, false);
        int offset = 0;
        if (haveImpl && remoteCount > 1) {
            result = new String[length + 1];
            result[0] = this.getRepositoryID(theType);
            offset = 1;
        } else {
            result = new String[length];
            if (length > 1) {
                int i;
                String mostDerived = null;
                if (haveImpl) {
                    for (i = 0; i < interfaces.length; ++i) {
                        if (!interfaces[i].isType(4096)) continue;
                        mostDerived = interfaces[i].getRepositoryID();
                        break;
                    }
                } else {
                    mostDerived = theType.getRepositoryID();
                }
                for (i = 0; i < length; ++i) {
                    if (types[i].getRepositoryID() != mostDerived) continue;
                    if (i <= 0) break;
                    temp = types[0];
                    types[0] = types[i];
                    types[i] = temp;
                    break;
                }
            }
        }
        for (int i = 0; i < types.length; ++i) {
            result[offset++] = this.getRepositoryID(types[i]);
        }
        if (this.reverseIDs) {
            int start = 0;
            int end = result.length - 1;
            while (start < end) {
                temp = result[start];
                result[start++] = result[end];
                result[end--] = temp;
            }
        }
        return result;
    }

    Type[] collectAllRemoteInterfaces(CompoundType theType) {
        Vector list = new Vector();
        this.addRemoteInterfaces(list, theType);
        Object[] result = new Type[list.size()];
        list.copyInto(result);
        return result;
    }

    void addRemoteInterfaces(Vector list, CompoundType theType) {
        if (theType != null) {
            if (theType.isInterface() && !list.contains(theType)) {
                list.addElement(theType);
            }
            InterfaceType[] interfaces = theType.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!interfaces[i].isType(4096)) continue;
                this.addRemoteInterfaces(list, interfaces[i]);
            }
            this.addRemoteInterfaces(list, theType.getSuperclass());
        }
    }

    RemoteType[] getDirectRemoteInterfaces(CompoundType theType) {
        Type[] interfaces = theType.getInterfaces();
        Type[] list = theType instanceof ImplementationType ? interfaces : new InterfaceType[]{(InterfaceType)theType};
        int remoteCount = this.countRemote(list, false);
        if (remoteCount == 0) {
            throw new CompilerError("iiop.StubGenerator: No remote interfaces!");
        }
        RemoteType[] result = new RemoteType[remoteCount];
        int offset = 0;
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].isType(4096)) continue;
            result[offset++] = (RemoteType)list[i];
        }
        return result;
    }

    int countRemote(Type[] list, boolean includeAbstract) {
        int remoteCount = 0;
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].isType(4096) || !includeAbstract && list[i].isType(8192)) continue;
            ++remoteCount;
        }
        return remoteCount;
    }

    void writeCastArray(IndentingWriter p) throws IOException {
        if (this.castArray) {
            p.pln();
            p.pln("// This method is required as a work-around for");
            p.pln("// a bug in the JDK 1.1.6 verifier.");
            p.pln();
            p.plnI("private " + this.getName(idJavaIoSerializable) + " cast_array(Object obj) {");
            p.pln("return (" + this.getName(idJavaIoSerializable) + ")obj;");
            p.pOln("}");
        }
    }

    void writeIds(IndentingWriter p, CompoundType theType, boolean isTie) throws IOException {
        boolean isTransactional;
        p.plnI("private static final String[] _type_ids = {");
        String[] ids = this.getAllRemoteRepIDs(theType);
        if (ids.length > 0) {
            for (int i = 0; i < ids.length; ++i) {
                if (i > 0) {
                    p.pln(", ");
                }
                p.p("\"" + ids[i] + "\"");
            }
        } else {
            p.pln("\"\"");
        }
        String qname = theType.getQualifiedName();
        boolean bl = isTransactional = isTie && this.transactionalObjects.containsKey(qname);
        if (isTransactional) {
            p.pln(", ");
            p.pln("\"IDL:omg.org/CosTransactions/TransactionalObject:1.0\"");
        } else if (ids.length > 0) {
            p.pln();
        }
        p.pOln("};");
    }

    protected void writeTie(Generator.OutputType outputType, IndentingWriter p) throws IOException {
        CompoundType theType = (CompoundType)outputType.getType();
        RemoteType[] remoteInterfaces = null;
        p.pln("// Tie class generated by rmic, do not edit.");
        p.pln("// Contents subject to change without notice.");
        p.pln();
        this.setStandardClassesInUse(theType, false);
        this.addClassesInUse(theType, remoteInterfaces);
        this.writePackageAndImports(p);
        p.p("public class " + this.currentClass + " extends " + this.getName(this.tieBaseClass) + " implements Tie");
        if (!this.implementsRemote(theType)) {
            p.pln(",");
            p.p(this.getName("java.rmi.Remote"));
        }
        p.plnI(" {");
        p.pln();
        p.pln("volatile private " + this.getName(theType) + " target = null;");
        p.pln();
        this.writeIds(p, theType, true);
        p.pln();
        p.plnI("public void setTarget(Remote target) {");
        p.pln("this.target = (" + this.getName(theType) + ") target;");
        p.pOln("}");
        p.pln();
        p.plnI("public Remote getTarget() {");
        p.pln("return target;");
        p.pOln("}");
        p.pln();
        this.write_tie_thisObject_method(p, idCorbaObject);
        p.pln();
        this.write_tie_deactivate_method(p);
        p.pln();
        p.plnI("public ORB orb() {");
        p.pln("return _orb();");
        p.pOln("}");
        p.pln();
        this.write_tie_orb_method(p);
        p.pln();
        this.write_tie__ids_method(p);
        CompoundType.Method[] remoteMethods = theType.getMethods();
        this.addNamesInUse(remoteMethods);
        this.addNameInUse("target");
        this.addNameInUse("_type_ids");
        p.pln();
        String in = this.getVariableName("in");
        String _in = this.getVariableName("_in");
        String ex = this.getVariableName("ex");
        String method = this.getVariableName("method");
        String reply = this.getVariableName("reply");
        p.plnI("public OutputStream  _invoke(String " + method + ", InputStream " + _in + ", " + "ResponseHandler " + reply + ") throws SystemException {");
        if (remoteMethods.length > 0) {
            p.plnI("try {");
            p.pln(this.getName(theType) + " target = this.target;");
            p.plnI("if (target == null) {");
            p.pln("throw new java.io.IOException();");
            p.pOln("}");
            p.plnI(idExtInputStream + " " + in + " = ");
            p.pln("(" + idExtInputStream + ") " + _in + ";");
            p.pO();
            StaticStringsHash hash = this.getStringsHash(remoteMethods);
            if (hash != null) {
                p.plnI("switch (" + method + "." + hash.method + ") {");
                for (int i = 0; i < hash.buckets.length; ++i) {
                    p.plnI("case " + hash.keys[i] + ": ");
                    for (int j = 0; j < hash.buckets[i].length; ++j) {
                        CompoundType.Method current = remoteMethods[hash.buckets[i][j]];
                        if (j > 0) {
                            p.pO("} else ");
                        }
                        p.plnI("if (" + method + ".equals(\"" + current.getIDLName() + "\")) {");
                        this.writeTieMethod(p, theType, current);
                    }
                    p.pOln("}");
                    p.pO();
                }
            } else {
                for (int i = 0; i < remoteMethods.length; ++i) {
                    CompoundType.Method current = remoteMethods[i];
                    if (i > 0) {
                        p.pO("} else ");
                    }
                    p.plnI("if (" + method + ".equals(\"" + current.getIDLName() + "\")) {");
                    this.writeTieMethod(p, theType, current);
                }
            }
            if (hash != null) {
                p.pI();
            }
            if (hash != null) {
                p.pO();
            }
            p.pOln("}");
            p.pln("throw new " + this.getName(idBadMethodException) + "();");
            p.pOlnI("} catch (" + this.getName(idSystemException) + " " + ex + ") {");
            p.pln("throw " + ex + ";");
            p.pOlnI("} catch (" + this.getName(idJavaLangThrowable) + " " + ex + ") {");
            p.pln("throw new " + this.getName(idPortableUnknownException) + "(" + ex + ");");
            p.pOln("}");
        } else {
            p.pln("throw new " + this.getName(idBadMethodException) + "();");
        }
        p.pOln("}");
        this.writeCastArray(p);
        p.pOln("}");
    }

    public void catchWrongPolicy(IndentingWriter p) throws IOException {
        p.pln("");
    }

    public void catchServantNotActive(IndentingWriter p) throws IOException {
        p.pln("");
    }

    public void catchObjectNotActive(IndentingWriter p) throws IOException {
        p.pln("");
    }

    public void write_tie_thisObject_method(IndentingWriter p, Identifier idCorbaObject) throws IOException {
        if (this.POATie) {
            p.plnI("public " + idCorbaObject + " thisObject() {");
            p.pln("return _this_object();");
            p.pOln("}");
        } else {
            p.plnI("public " + idCorbaObject + " thisObject() {");
            p.pln("return this;");
            p.pOln("}");
        }
    }

    public void write_tie_deactivate_method(IndentingWriter p) throws IOException {
        if (this.POATie) {
            p.plnI("public void deactivate() {");
            p.pln("try{");
            p.pln("_poa().deactivate_object(_poa().servant_to_id(this));");
            p.pln("}catch (org.omg.PortableServer.POAPackage.WrongPolicy exception){");
            this.catchWrongPolicy(p);
            p.pln("}catch (org.omg.PortableServer.POAPackage.ObjectNotActive exception){");
            this.catchObjectNotActive(p);
            p.pln("}catch (org.omg.PortableServer.POAPackage.ServantNotActive exception){");
            this.catchServantNotActive(p);
            p.pln("}");
            p.pOln("}");
        } else {
            p.plnI("public void deactivate() {");
            p.pln("_orb().disconnect(this);");
            p.pln("_set_delegate(null);");
            p.pln("target = null;");
            p.pOln("}");
        }
    }

    public void write_tie_orb_method(IndentingWriter p) throws IOException {
        if (this.POATie) {
            p.plnI("public void orb(ORB orb) {");
            p.pln("try {");
            p.pln("    ((org.omg.CORBA_2_3.ORB)orb).set_delegate(this);");
            p.pln("}");
            p.pln("catch(ClassCastException e) {");
            p.pln("    throw new org.omg.CORBA.BAD_PARAM");
            p.pln("        (\"POA Servant requires an instance of org.omg.CORBA_2_3.ORB\");");
            p.pln("}");
            p.pOln("}");
        } else {
            p.plnI("public void orb(ORB orb) {");
            p.pln("orb.connect(this);");
            p.pOln("}");
        }
    }

    public void write_tie__ids_method(IndentingWriter p) throws IOException {
        if (this.POATie) {
            p.plnI("public String[] _all_interfaces(org.omg.PortableServer.POA poa, byte[] objectId){");
            p.pln("return (String[]) _type_ids.clone();");
            p.pOln("}");
        } else {
            p.plnI("public String[] _ids() { ");
            p.pln("return (String[]) _type_ids.clone();");
            p.pOln("}");
        }
    }

    StaticStringsHash getStringsHash(CompoundType.Method[] methods) {
        if (this.useHash && methods.length > 1) {
            String[] methodNames = new String[methods.length];
            for (int i = 0; i < methodNames.length; ++i) {
                methodNames[i] = methods[i].getIDLName();
            }
            return new StaticStringsHash(methodNames);
        }
        return null;
    }

    static boolean needNewReadStreamClass(Type type) {
        if (type.isType(8192)) {
            return true;
        }
        if (type instanceof CompoundType && ((CompoundType)type).isAbstractBase()) {
            return true;
        }
        return StubGenerator.needNewWriteStreamClass(type);
    }

    static boolean needNewWriteStreamClass(Type type) {
        switch (type.getTypeCode()) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 256: {
                return false;
            }
            case 512: {
                return true;
            }
            case 1024: {
                return false;
            }
            case 2048: {
                return false;
            }
            case 4096: {
                return false;
            }
            case 8192: {
                return false;
            }
            case 16384: {
                return true;
            }
            case 32768: {
                return true;
            }
            case 65536: {
                return true;
            }
            case 131072: {
                return true;
            }
            case 262144: {
                return true;
            }
            case 524288: {
                return false;
            }
        }
        throw new Error("unexpected type code: " + type.getTypeCode());
    }

    String[] writeCopyArguments(CompoundType.Method method, IndentingWriter p) throws IOException {
        int i;
        Type[] args = method.getArguments();
        String[] origNames = method.getArgumentNames();
        String[] result = new String[origNames.length];
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = origNames[i2];
        }
        boolean realCopy = false;
        boolean[] copyArg = new boolean[args.length];
        int copyCount = 0;
        int firstCopiedArg = 0;
        for (i = 0; i < args.length; ++i) {
            if (StubGenerator.mustCopy(args[i])) {
                copyArg[i] = true;
                ++copyCount;
                firstCopiedArg = i;
                if (args[i].getTypeCode() == 4096 || args[i].getTypeCode() == 65536) continue;
                realCopy = true;
                continue;
            }
            copyArg[i] = false;
        }
        if (copyCount > 0) {
            if (realCopy) {
                for (i = 0; i < args.length; ++i) {
                    if (args[i].getTypeCode() != 512) continue;
                    copyArg[i] = true;
                    ++copyCount;
                }
            }
            if (copyCount > 1) {
                String arrayName = this.getVariableName("copies");
                p.p("Object[] " + arrayName + " = Util.copyObjects(new Object[]{");
                boolean first = true;
                for (int i3 = 0; i3 < args.length; ++i3) {
                    if (!copyArg[i3]) continue;
                    if (!first) {
                        p.p(",");
                    }
                    first = false;
                    p.p(origNames[i3]);
                }
                p.pln("},_orb());");
                int copyIndex = 0;
                for (int i4 = 0; i4 < args.length; ++i4) {
                    if (!copyArg[i4]) continue;
                    result[i4] = this.getVariableName(result[i4] + "Copy");
                    p.pln(this.getName(args[i4]) + " " + result[i4] + " = (" + this.getName(args[i4]) + ") " + arrayName + "[" + copyIndex++ + "];");
                }
            } else {
                result[firstCopiedArg] = this.getVariableName(result[firstCopiedArg] + "Copy");
                p.pln(this.getName(args[firstCopiedArg]) + " " + result[firstCopiedArg] + " = (" + this.getName(args[firstCopiedArg]) + ") Util.copyObject(" + origNames[firstCopiedArg] + ",_orb());");
            }
        }
        return result;
    }

    String getRepositoryID(Type type) {
        return IDLNames.replace(type.getRepositoryID(), SINGLE_SLASH, DOUBLE_SLASH);
    }

    String getExceptionRepositoryID(Type type) {
        ClassType theType = (ClassType)type;
        return IDLNames.getIDLRepositoryID(theType.getQualifiedIDLExceptionName(false));
    }

    String getVariableName(String proposed) {
        while (this.namesInUse.contains(proposed)) {
            proposed = "$" + proposed;
        }
        return proposed;
    }

    void addNamesInUse(CompoundType.Method[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            this.addNamesInUse(methods[i]);
        }
    }

    void addNamesInUse(CompoundType.Method method) {
        String[] paramNames = method.getArgumentNames();
        for (int i = 0; i < paramNames.length; ++i) {
            this.addNameInUse(paramNames[i]);
        }
    }

    void addNameInUse(String name) {
        this.namesInUse.add(name);
    }

    static boolean mustCopy(Type type) {
        switch (type.getTypeCode()) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 256: 
            case 512: {
                return false;
            }
            case 1024: {
                return true;
            }
            case 2048: {
                return false;
            }
            case 4096: 
            case 8192: 
            case 16384: 
            case 32768: 
            case 65536: 
            case 131072: 
            case 262144: 
            case 524288: {
                return true;
            }
        }
        throw new Error("unexpected type code: " + type.getTypeCode());
    }

    ValueType[] getStubExceptions(CompoundType.Method method, boolean sort) {
        ValueType[] list = method.getFilteredStubExceptions(method.getExceptions());
        if (sort) {
            Arrays.sort(list, new UserExceptionComparator());
        }
        return list;
    }

    ValueType[] getTieExceptions(CompoundType.Method method) {
        return method.getUniqueCatchList(method.getImplExceptions());
    }

    void writeTieMethod(IndentingWriter p, CompoundType type, CompoundType.Method method) throws IOException {
        int i;
        boolean doReturn;
        String methodName = method.getName();
        Type[] paramTypes = method.getArguments();
        String[] paramNames = method.getArgumentNames();
        Type returnType = method.getReturnType();
        ValueType[] exceptions = this.getTieExceptions(method);
        String in = this.getVariableName("in");
        String ex = this.getVariableName("ex");
        String out = this.getVariableName("out");
        String reply = this.getVariableName("reply");
        for (int i2 = 0; i2 < paramTypes.length; ++i2) {
            p.p(this.getName(paramTypes[i2]) + " " + paramNames[i2] + " = ");
            this.writeUnmarshalArgument(p, in, paramTypes[i2], null);
            p.pln();
        }
        boolean handleExceptions = exceptions != null;
        boolean bl = doReturn = !returnType.isType(1);
        if (handleExceptions && doReturn) {
            String objName = this.testUtil(this.getName(returnType), returnType);
            p.pln(objName + " result;");
        }
        if (handleExceptions) {
            p.plnI("try {");
        }
        if (doReturn) {
            if (handleExceptions) {
                p.p("result = ");
            } else {
                p.p(this.getName(returnType) + " result = ");
            }
        }
        p.p("target." + methodName + "(");
        for (i = 0; i < paramNames.length; ++i) {
            if (i > 0) {
                p.p(", ");
            }
            p.p(paramNames[i]);
        }
        p.pln(");");
        if (handleExceptions) {
            for (i = 0; i < exceptions.length; ++i) {
                p.pOlnI("} catch (" + this.getName(exceptions[i]) + " " + ex + ") {");
                if (exceptions[i].isIDLEntityException() && !exceptions[i].isCORBAUserException()) {
                    String helperName = IDLNames.replace(exceptions[i].getQualifiedIDLName(false), "::", ".");
                    helperName = helperName + "Helper";
                    p.pln(idOutputStream + " " + out + " = " + reply + ".createExceptionReply();");
                    p.pln(helperName + ".write(" + out + "," + ex + ");");
                } else {
                    p.pln("String id = \"" + this.getExceptionRepositoryID(exceptions[i]) + "\";");
                    p.plnI(idExtOutputStream + " " + out + " = ");
                    p.pln("(" + idExtOutputStream + ") " + reply + ".createExceptionReply();");
                    p.pOln(out + ".write_string(id);");
                    p.pln(out + ".write_value(" + ex + "," + this.getName(exceptions[i]) + ".class);");
                }
                p.pln("return " + out + ";");
            }
            p.pOln("}");
        }
        if (StubGenerator.needNewWriteStreamClass(returnType)) {
            p.plnI(idExtOutputStream + " " + out + " = ");
            p.pln("(" + idExtOutputStream + ") " + reply + ".createReply();");
            p.pO();
        } else {
            p.pln("OutputStream " + out + " = " + reply + ".createReply();");
        }
        if (doReturn) {
            this.writeMarshalArgument(p, out, returnType, "result");
            p.pln();
        }
        p.pln("return " + out + ";");
    }

    void writeMarshalArguments(IndentingWriter p, String streamName, Type[] types, String[] names) throws IOException {
        if (types.length != names.length) {
            throw new Error("paramter type and name arrays different sizes");
        }
        for (int i = 0; i < types.length; ++i) {
            this.writeMarshalArgument(p, streamName, types[i], names[i]);
            if (i == types.length - 1) continue;
            p.pln();
        }
    }

    String testUtil(String objectName, Type ttype) {
        if (objectName.equals("Util")) {
            String correctedName = ttype.getPackageName() + "." + objectName;
            return correctedName;
        }
        return objectName;
    }
}

