/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.ProviderNotFoundException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassPathEntry;
import sun.tools.java.DirClassPathEntry;
import sun.tools.java.JrtClassPathEntry;
import sun.tools.java.ZipClassPathEntry;

public class ClassPath {
    static final char dirSeparator = File.pathSeparatorChar;
    String pathstr;
    private ClassPathEntry[] path;
    private final String fileSeparatorChar = "" + File.separatorChar;

    private FileSystem getJrtFileSystem() {
        return FileSystems.getFileSystem(URI.create("jrt:/"));
    }

    public ClassPath(String pathstr) {
        this.init(pathstr);
    }

    public ClassPath(String[] patharray) {
        this.init(patharray);
    }

    public ClassPath() {
        String syscp = System.getProperty("sun.boot.class.path");
        String envcp = System.getProperty("env.class.path");
        if (envcp == null) {
            envcp = ".";
        }
        String cp = syscp == null ? envcp : syscp + File.pathSeparator + envcp;
        this.init(cp);
    }

    private void init(String pathstr) {
        this.pathstr = pathstr;
        if (pathstr.length() == 0) {
            this.path = new ClassPathEntry[0];
        }
        int n = 0;
        int i = 0;
        while ((i = pathstr.indexOf(dirSeparator, i)) != -1) {
            ++n;
            ++i;
        }
        ClassPathEntry[] path = new ClassPathEntry[n + 1];
        int len = pathstr.length();
        n = 0;
        i = 0;
        while (i < len) {
            int j = pathstr.indexOf(dirSeparator, i);
            if (j == -1) {
                j = len;
            }
            if (i == j) {
                path[n++] = new DirClassPathEntry(new File("."));
            } else {
                String filename = pathstr.substring(i, j);
                File file = new File(filename);
                if (file.isFile()) {
                    try {
                        ZipFile zip = new ZipFile(file);
                        path[n++] = new ZipClassPathEntry(zip);
                    }
                    catch (ZipException e) {
                    }
                    catch (IOException e) {}
                } else {
                    path[n++] = new DirClassPathEntry(file);
                }
            }
            i = j + 1;
        }
        try {
            FileSystem fs = this.getJrtFileSystem();
            path[n++] = new JrtClassPathEntry(fs);
        }
        catch (ProviderNotFoundException ignored) {
            // empty catch block
        }
        this.path = new ClassPathEntry[n];
        System.arraycopy(path, 0, this.path, 0, n);
    }

    private void init(String[] patharray) {
        if (patharray.length == 0) {
            this.pathstr = "";
        } else {
            StringBuilder sb = new StringBuilder(patharray[0]);
            for (int i = 1; i < patharray.length; ++i) {
                sb.append(File.pathSeparatorChar);
                sb.append(patharray[i]);
            }
            this.pathstr = sb.toString();
        }
        ClassPathEntry[] path = new ClassPathEntry[patharray.length + 1];
        int n = 0;
        for (String name : patharray) {
            File file = new File(name);
            if (file.isFile()) {
                try {
                    ZipFile zip = new ZipFile(file);
                    path[n++] = new ZipClassPathEntry(zip);
                }
                catch (ZipException e) {
                }
                catch (IOException e) {}
                continue;
            }
            path[n++] = new DirClassPathEntry(file);
        }
        try {
            FileSystem fs = this.getJrtFileSystem();
            path[n++] = new JrtClassPathEntry(fs);
        }
        catch (ProviderNotFoundException ignored) {
            // empty catch block
        }
        this.path = new ClassPathEntry[n];
        System.arraycopy(path, 0, this.path, 0, n);
    }

    public ClassFile getDirectory(String name) {
        return this.getFile(name, true);
    }

    public ClassFile getFile(String name) {
        return this.getFile(name, false);
    }

    private ClassFile getFile(String name, boolean isDirectory) {
        int i;
        String subdir = name;
        String basename = "";
        if (!isDirectory) {
            i = name.lastIndexOf(File.separatorChar);
            subdir = name.substring(0, i + 1);
            basename = name.substring(i + 1);
        } else if (!subdir.equals("") && !subdir.endsWith(this.fileSeparatorChar)) {
            name = subdir = subdir + File.separatorChar;
        }
        for (i = 0; i < this.path.length; ++i) {
            ClassFile cf = this.path[i].getFile(name, subdir, basename, isDirectory);
            if (cf == null) continue;
            return cf;
        }
        return null;
    }

    public Enumeration<ClassFile> getFiles(String pkg, String ext) {
        Hashtable<String, ClassFile> files = new Hashtable<String, ClassFile>();
        int i = this.path.length;
        while (--i >= 0) {
            this.path[i].fillFiles(pkg, ext, files);
        }
        return files.elements();
    }

    public void close() throws IOException {
        int i = this.path.length;
        while (--i >= 0) {
            this.path[i].close();
        }
    }

    public String toString() {
        return this.pathstr;
    }
}

