/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import sun.tools.java.Type;

public final class MethodType
extends Type {
    Type returnType;
    Type[] argTypes;

    MethodType(String typeSig, Type returnType, Type[] argTypes) {
        super(12, typeSig);
        this.returnType = returnType;
        this.argTypes = argTypes;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public Type[] getArgumentTypes() {
        return this.argTypes;
    }

    @Override
    public boolean equalArguments(Type t) {
        if (t.typeCode != 12) {
            return false;
        }
        MethodType m = (MethodType)t;
        if (this.argTypes.length != m.argTypes.length) {
            return false;
        }
        for (int i = this.argTypes.length - 1; i >= 0; --i) {
            if (this.argTypes[i] == m.argTypes[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int stackSize() {
        int n = 0;
        for (int i = 0; i < this.argTypes.length; ++i) {
            n += this.argTypes[i].stackSize();
        }
        return n;
    }

    @Override
    public String typeString(String id, boolean abbrev, boolean ret) {
        StringBuilder sb = new StringBuilder();
        sb.append(id);
        sb.append('(');
        for (int i = 0; i < this.argTypes.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.argTypes[i].typeString("", abbrev, ret));
        }
        sb.append(')');
        return ret ? this.getReturnType().typeString(sb.toString(), abbrev, ret) : sb.toString();
    }
}

