/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import sun.tools.asm.Assembler;
import sun.tools.java.AmbiguousMember;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Environment;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;
import sun.tools.tree.BinaryArithmeticExpression;
import sun.tools.tree.Context;
import sun.tools.tree.DoubleExpression;
import sun.tools.tree.Expression;
import sun.tools.tree.FloatExpression;
import sun.tools.tree.IntExpression;
import sun.tools.tree.LongExpression;
import sun.tools.tree.StringExpression;

public class AddExpression
extends BinaryArithmeticExpression {
    public AddExpression(long where, Expression left, Expression right) {
        super(29, where, left, right);
    }

    @Override
    void selectType(Environment env, Context ctx, int tm) {
        if (this.left.type == Type.tString && !this.right.type.isType(11)) {
            this.type = Type.tString;
            return;
        }
        if (this.right.type == Type.tString && !this.left.type.isType(11)) {
            this.type = Type.tString;
            return;
        }
        super.selectType(env, ctx, tm);
    }

    @Override
    public boolean isNonNull() {
        return true;
    }

    @Override
    Expression eval(int a, int b) {
        return new IntExpression(this.where, a + b);
    }

    @Override
    Expression eval(long a, long b) {
        return new LongExpression(this.where, a + b);
    }

    @Override
    Expression eval(float a, float b) {
        return new FloatExpression(this.where, a + b);
    }

    @Override
    Expression eval(double a, double b) {
        return new DoubleExpression(this.where, a + b);
    }

    @Override
    Expression eval(String a, String b) {
        return new StringExpression(this.where, a + b);
    }

    @Override
    public Expression inlineValue(Environment env, Context ctx) {
        StringBuffer buffer;
        if (this.type == Type.tString && this.isConstant() && (buffer = this.inlineValueSB(env, ctx, new StringBuffer())) != null) {
            return new StringExpression(this.where, buffer.toString());
        }
        return super.inlineValue(env, ctx);
    }

    @Override
    protected StringBuffer inlineValueSB(Environment env, Context ctx, StringBuffer buffer) {
        if (this.type != Type.tString) {
            return super.inlineValueSB(env, ctx, buffer);
        }
        if ((buffer = this.left.inlineValueSB(env, ctx, buffer)) != null) {
            buffer = this.right.inlineValueSB(env, ctx, buffer);
        }
        return buffer;
    }

    @Override
    Expression simplify() {
        if (!this.type.isType(10)) {
            if (this.type.inMask(62)) {
                if (this.left.equals(0)) {
                    return this.right;
                }
                if (this.right.equals(0)) {
                    return this.left;
                }
            }
        } else if (this.right.type.isType(8)) {
            this.right = new StringExpression(this.right.where, "null");
        } else if (this.left.type.isType(8)) {
            this.left = new StringExpression(this.left.where, "null");
        }
        return this;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        return (this.type.isType(10) ? 12 : 1) + this.left.costInline(thresh, env, ctx) + this.right.costInline(thresh, env, ctx);
    }

    @Override
    void codeOperation(Environment env, Context ctx, Assembler asm) {
        asm.add(this.where, 96 + this.type.getTypeCodeOffset());
    }

    @Override
    void codeAppend(Environment env, Context ctx, Assembler asm, ClassDeclaration sbClass, boolean needBuffer) throws ClassNotFound, AmbiguousMember {
        if (this.type.isType(10)) {
            this.left.codeAppend(env, ctx, asm, sbClass, needBuffer);
            this.right.codeAppend(env, ctx, asm, sbClass, false);
        } else {
            super.codeAppend(env, ctx, asm, sbClass, needBuffer);
        }
    }

    @Override
    public void codeValue(Environment env, Context ctx, Assembler asm) {
        if (this.type.isType(10)) {
            try {
                if (this.left.equals("")) {
                    this.right.codeValue(env, ctx, asm);
                    this.right.ensureString(env, ctx, asm);
                    return;
                }
                if (this.right.equals("")) {
                    this.left.codeValue(env, ctx, asm);
                    this.left.ensureString(env, ctx, asm);
                    return;
                }
                ClassDeclaration sbClass = env.getClassDeclaration(idJavaLangStringBuffer);
                ClassDefinition sourceClass = ctx.field.getClassDefinition();
                this.codeAppend(env, ctx, asm, sbClass, true);
                MemberDefinition f = sbClass.getClassDefinition(env).matchMethod(env, sourceClass, idToString);
                asm.add(this.where, 182, f);
            }
            catch (ClassNotFound e) {
                throw new CompilerError(e);
            }
            catch (AmbiguousMember e) {
                throw new CompilerError(e);
            }
        } else {
            super.codeValue(env, ctx, asm);
        }
    }
}

