/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import sun.tools.asm.Assembler;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.tree.CheckContext;
import sun.tools.tree.CodeContext;
import sun.tools.tree.Context;
import sun.tools.tree.Statement;
import sun.tools.tree.Vset;

public class ContinueStatement
extends Statement {
    Identifier lbl;

    public ContinueStatement(long where, Identifier lbl) {
        super(99, where);
        this.lbl = lbl;
    }

    @Override
    Vset check(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        this.checkLabel(env, ctx);
        this.reach(env, vset);
        CheckContext destctx = (CheckContext)new CheckContext(ctx, this).getContinueContext(this.lbl);
        if (destctx != null) {
            switch (destctx.node.op) {
                case 92: 
                case 93: 
                case 94: {
                    if (destctx.frameNumber != ctx.frameNumber) {
                        env.error(this.where, "branch.to.uplevel", this.lbl);
                    }
                    destctx.vsContinue = destctx.vsContinue.join(vset);
                    break;
                }
                default: {
                    env.error(this.where, "invalid.continue");
                    break;
                }
            }
        } else if (this.lbl != null) {
            env.error(this.where, "label.not.found", this.lbl);
        } else {
            env.error(this.where, "invalid.continue");
        }
        CheckContext exitctx = ctx.getTryExitContext();
        if (exitctx != null) {
            exitctx.vsTryExit = exitctx.vsTryExit.join(vset);
        }
        return DEAD_END;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        return 1;
    }

    @Override
    public void code(Environment env, Context ctx, Assembler asm) {
        CodeContext destctx = (CodeContext)ctx.getContinueContext(this.lbl);
        this.codeFinally(env, ctx, asm, destctx, null);
        asm.add(this.where, 167, destctx.contLabel);
    }

    @Override
    public void print(PrintStream out, int indent) {
        super.print(out, indent);
        out.print("continue");
        if (this.lbl != null) {
            out.print(" " + this.lbl);
        }
        out.print(";");
    }
}

