/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.util.Hashtable;
import sun.tools.asm.Assembler;
import sun.tools.java.AmbiguousClass;
import sun.tools.java.AmbiguousMember;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.java.Type;
import sun.tools.tree.CommaExpression;
import sun.tools.tree.CompoundStatement;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.ExpressionStatement;
import sun.tools.tree.FieldExpression;
import sun.tools.tree.InlineNewInstanceExpression;
import sun.tools.tree.LocalMember;
import sun.tools.tree.MethodExpression;
import sun.tools.tree.NaryExpression;
import sun.tools.tree.Statement;
import sun.tools.tree.TypeExpression;
import sun.tools.tree.UnaryExpression;
import sun.tools.tree.UplevelReference;
import sun.tools.tree.VarDeclarationStatement;
import sun.tools.tree.Vset;

public class NewInstanceExpression
extends NaryExpression {
    MemberDefinition field;
    Expression outerArg;
    ClassDefinition body;
    MemberDefinition implMethod = null;
    final int MAXINLINECOST = Statement.MAXINLINECOST;

    public NewInstanceExpression(long where, Expression right, Expression[] args) {
        super(42, where, Type.tError, right, args);
    }

    public NewInstanceExpression(long where, Expression right, Expression[] args, Expression outerArg, ClassDefinition body) {
        this(where, right, args);
        this.outerArg = outerArg;
        this.body = body;
    }

    public Expression getOuterArg() {
        return this.outerArg;
    }

    @Override
    int precedence() {
        return 100;
    }

    @Override
    public Expression order() {
        if (this.outerArg != null && opPrecedence[46] > this.outerArg.precedence()) {
            UnaryExpression e = (UnaryExpression)this.outerArg;
            this.outerArg = e.right;
            e.right = this.order();
            return e;
        }
        return this;
    }

    @Override
    public Vset checkValue(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        int i;
        ClassDefinition def = null;
        Expression alreadyChecked = null;
        try {
            if (this.outerArg != null) {
                vset = this.outerArg.checkValue(env, ctx, vset, exp);
                alreadyChecked = this.outerArg;
                Identifier typeName = FieldExpression.toIdentifier(this.right);
                if (typeName != null && typeName.isQualified()) {
                    env.error(this.where, "unqualified.name.required", typeName);
                }
                if (typeName == null || !this.outerArg.type.isType(10)) {
                    if (!this.outerArg.type.isType(13)) {
                        env.error(this.where, "invalid.field.reference", idNew, this.outerArg.type);
                    }
                    this.outerArg = null;
                } else {
                    ClassDefinition oc = env.getClassDefinition(this.outerArg.type);
                    Identifier nm = oc.resolveInnerClass(env, typeName);
                    this.right = new TypeExpression(this.right.where, Type.tClass(nm));
                    env.resolve(this.right.where, ctx.field.getClassDefinition(), this.right.type);
                }
            }
            if (!(this.right instanceof TypeExpression)) {
                this.right = new TypeExpression(this.right.where, this.right.toType(env, ctx));
            }
            if (this.right.type.isType(10)) {
                def = env.getClassDefinition(this.right.type);
            }
        }
        catch (AmbiguousClass ee) {
            env.error(this.where, "ambig.class", ee.name1, ee.name2);
        }
        catch (ClassNotFound ee) {
            env.error(this.where, "class.not.found", ee.name, ctx.field);
        }
        Type t = this.right.type;
        boolean hasErrors = t.isType(13);
        if (!t.isType(10) && !hasErrors) {
            env.error(this.where, "invalid.arg.type", t, opNames[this.op]);
            hasErrors = true;
        }
        if (def == null) {
            this.type = Type.tError;
            return vset;
        }
        Expression[] args = this.args;
        if ((args = NewInstanceExpression.insertOuterLink(env, ctx, this.where, def, this.outerArg, args)).length > this.args.length) {
            this.outerArg = args[0];
        } else if (this.outerArg != null) {
            this.outerArg = new CommaExpression(this.outerArg.where, this.outerArg, null);
        }
        Type[] argTypes = new Type[args.length];
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (args[i2] != alreadyChecked) {
                vset = args[i2].checkValue(env, ctx, vset, exp);
            }
            argTypes[i2] = args[i2].type;
            hasErrors = hasErrors || argTypes[i2].isType(13);
        }
        try {
            ClassDefinition cdef;
            if (hasErrors) {
                this.type = Type.tError;
                return vset;
            }
            ClassDefinition sourceClass = ctx.field.getClassDefinition();
            ClassDeclaration c = env.getClassDeclaration(t);
            if (this.body != null) {
                Identifier packageName = sourceClass.getName().getQualifier();
                ClassDefinition superDef = null;
                superDef = def.isInterface() ? env.getClassDefinition(idJavaLangObject) : def;
                MemberDefinition constructor = superDef.matchAnonConstructor(env, packageName, argTypes);
                if (constructor != null) {
                    env.dtEvent("NewInstanceExpression.checkValue: ANON CLASS " + this.body + " SUPER " + def);
                    vset = this.body.checkLocalClass(env, ctx, vset, def, args, constructor.getType().getArgumentTypes());
                    t = this.body.getClassDeclaration().getType();
                    def = this.body;
                }
            } else {
                if (def.isInterface()) {
                    env.error(this.where, "new.intf", c);
                    return vset;
                }
                if (def.mustBeAbstract(env)) {
                    env.error(this.where, "new.abstract", c);
                    return vset;
                }
            }
            this.field = def.matchMethod(env, sourceClass, idInit, argTypes);
            if (this.field == null) {
                MemberDefinition anyInit = def.findAnyMethod(env, idInit);
                if (anyInit != null && new MethodExpression(this.where, this.right, anyInit, args).diagnoseMismatch(env, args, argTypes)) {
                    return vset;
                }
                String sig = c.getName().getName().toString();
                sig = Type.tMethod(Type.tError, argTypes).typeString(sig, false, false);
                env.error(this.where, "unmatched.constr", sig, c);
                return vset;
            }
            if (this.field.isPrivate() && (cdef = this.field.getClassDefinition()) != sourceClass) {
                this.implMethod = cdef.getAccessMember(env, ctx, this.field, false);
            }
            if (def.mustBeAbstract(env)) {
                env.error(this.where, "new.abstract", c);
                return vset;
            }
            if (this.field.reportDeprecated(env)) {
                env.error(this.where, "warn.constr.is.deprecated", this.field, this.field.getClassDefinition());
            }
            if (this.field.isProtected() && !sourceClass.getName().getQualifier().equals(this.field.getClassDeclaration().getName().getQualifier())) {
                env.error(this.where, "invalid.protected.constructor.use", sourceClass);
            }
        }
        catch (ClassNotFound ee) {
            env.error(this.where, "class.not.found", ee.name, opNames[this.op]);
            return vset;
        }
        catch (AmbiguousMember ee) {
            env.error(this.where, "ambig.constr", ee.field1, ee.field2);
            return vset;
        }
        argTypes = this.field.getType().getArgumentTypes();
        for (i = 0; i < args.length; ++i) {
            args[i] = this.convert(env, ctx, argTypes[i], args[i]);
        }
        if (args.length > this.args.length) {
            this.outerArg = args[0];
            for (i = 1; i < args.length; ++i) {
                this.args[i - 1] = args[i];
            }
        }
        ClassDeclaration[] exceptions = this.field.getExceptions(env);
        for (int i3 = 0; i3 < exceptions.length; ++i3) {
            if (exp.get(exceptions[i3]) != null) continue;
            exp.put(exceptions[i3], this);
        }
        this.type = t;
        return vset;
    }

    public static Expression[] insertOuterLink(Environment env, Context ctx, long where, ClassDefinition def, Expression outerArg, Expression[] args) {
        if (!def.isTopLevel() && !def.isLocal()) {
            Expression[] args2 = new Expression[1 + args.length];
            System.arraycopy(args, 0, args2, 1, args.length);
            try {
                if (outerArg == null) {
                    outerArg = ctx.findOuterLink(env, where, def.findAnyMethod(env, idInit));
                }
            }
            catch (ClassNotFound e) {
                // empty catch block
            }
            args2[0] = outerArg;
            args = args2;
        }
        return args;
    }

    @Override
    public Vset check(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        return this.checkValue(env, ctx, vset, exp);
    }

    @Override
    public Expression copyInline(Context ctx) {
        NewInstanceExpression e = (NewInstanceExpression)super.copyInline(ctx);
        if (this.outerArg != null) {
            e.outerArg = this.outerArg.copyInline(ctx);
        }
        return e;
    }

    Expression inlineNewInstance(Environment env, Context ctx, Statement s) {
        if (env.dump()) {
            System.out.println("INLINE NEW INSTANCE " + this.field + " in " + ctx.field);
        }
        LocalMember[] v = LocalMember.copyArguments(ctx, this.field);
        Statement[] body = new Statement[v.length + 2];
        int o = 1;
        if (this.outerArg != null && !this.outerArg.type.isType(11)) {
            o = 2;
            body[1] = new VarDeclarationStatement(this.where, v[1], this.outerArg);
        } else if (this.outerArg != null) {
            body[0] = new ExpressionStatement(this.where, this.outerArg);
        }
        for (int i = 0; i < this.args.length; ++i) {
            body[i + o] = new VarDeclarationStatement(this.where, v[i + o], this.args[i]);
        }
        body[body.length - 1] = s != null ? s.copyInline(ctx, false) : null;
        LocalMember.doneWithArguments(ctx, v);
        return new InlineNewInstanceExpression(this.where, this.type, this.field, new CompoundStatement(this.where, body)).inline(env, ctx);
    }

    @Override
    public Expression inline(Environment env, Context ctx) {
        return this.inlineValue(env, ctx);
    }

    @Override
    public Expression inlineValue(Environment env, Context ctx) {
        ClassDefinition refc;
        UplevelReference r;
        if (this.body != null) {
            this.body.inlineLocalClass(env);
        }
        if ((r = (refc = this.field.getClassDefinition()).getReferencesFrozen()) != null) {
            r.willCodeArguments(env, ctx);
        }
        try {
            if (this.outerArg != null) {
                this.outerArg = this.outerArg.type.isType(11) ? this.outerArg.inline(env, ctx) : this.outerArg.inlineValue(env, ctx);
            }
            for (int i = 0; i < this.args.length; ++i) {
                this.args[i] = this.args[i].inlineValue(env, ctx);
            }
        }
        catch (ClassNotFound e) {
            throw new CompilerError(e);
        }
        if (this.outerArg != null && this.outerArg.type.isType(11)) {
            Expression e = this.outerArg;
            this.outerArg = null;
            return new CommaExpression(this.where, e, this);
        }
        return this;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        if (this.body != null) {
            return thresh;
        }
        if (ctx == null) {
            return 2 + super.costInline(thresh, env, ctx);
        }
        ClassDefinition sourceClass = ctx.field.getClassDefinition();
        try {
            if (sourceClass.permitInlinedAccess(env, this.field.getClassDeclaration()) && sourceClass.permitInlinedAccess(env, this.field)) {
                return 2 + super.costInline(thresh, env, ctx);
            }
        }
        catch (ClassNotFound e) {
            // empty catch block
        }
        return thresh;
    }

    @Override
    public void code(Environment env, Context ctx, Assembler asm) {
        this.codeCommon(env, ctx, asm, false);
    }

    @Override
    public void codeValue(Environment env, Context ctx, Assembler asm) {
        this.codeCommon(env, ctx, asm, true);
    }

    private void codeCommon(Environment env, Context ctx, Assembler asm, boolean forValue) {
        ClassDefinition refc;
        UplevelReference r;
        asm.add(this.where, 187, this.field.getClassDeclaration());
        if (forValue) {
            asm.add(this.where, 89);
        }
        if ((r = (refc = this.field.getClassDefinition()).getReferencesFrozen()) != null) {
            r.codeArguments(env, ctx, asm, this.where, this.field);
        }
        if (this.outerArg != null) {
            this.outerArg.codeValue(env, ctx, asm);
            switch (this.outerArg.op) {
                case 49: 
                case 82: 
                case 83: {
                    break;
                }
                case 46: {
                    MemberDefinition f = ((FieldExpression)this.outerArg).field;
                    if (f != null && f.isNeverNull()) break;
                }
                default: {
                    try {
                        ClassDefinition c = env.getClassDefinition(idJavaLangObject);
                        MemberDefinition getc = c.getFirstMatch(idGetClass);
                        asm.add(this.where, 89);
                        asm.add(this.where, 182, getc);
                        asm.add(this.where, 87);
                        break;
                    }
                    catch (ClassNotFound e) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.implMethod != null) {
            asm.add(this.where, 1);
        }
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i].codeValue(env, ctx, asm);
        }
        asm.add(this.where, 183, this.implMethod != null ? this.implMethod : this.field);
    }
}

