/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import sun.tools.java.AmbiguousClass;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.IdentifierToken;
import sun.tools.java.ImportEnvironment;

public class Imports
implements Constants {
    Identifier currentPackage = idNull;
    long currentPackageWhere = 0L;
    Hashtable<Identifier, Identifier> classes = new Hashtable();
    Vector<IdentifierToken> packages = new Vector();
    Vector<IdentifierToken> singles = new Vector();
    protected int checked;

    public Imports(Environment env) {
        this.addPackage(idJavaLang);
    }

    public synchronized void resolve(Environment env) {
        long where;
        Identifier nm;
        IdentifierToken t;
        if (this.checked != 0) {
            return;
        }
        this.checked = -1;
        Vector<IdentifierToken> resolvedPackages = new Vector<IdentifierToken>();
        Enumeration<IdentifierToken> e = this.packages.elements();
        while (e.hasMoreElements()) {
            t = e.nextElement();
            nm = t.getName();
            where = t.getWhere();
            if (env.isExemptPackage(nm)) {
                resolvedPackages.addElement(t);
                continue;
            }
            try {
                Identifier rnm = env.resolvePackageQualifiedName(nm);
                if (Imports.importable(rnm, env)) {
                    if (env.getPackage(rnm.getTopName()).exists()) {
                        env.error(where, "class.and.package", rnm.getTopName());
                    }
                    if (!rnm.isInner()) {
                        rnm = Identifier.lookupInner(rnm, idNull);
                    }
                    nm = rnm;
                } else if (!env.getPackage(nm).exists()) {
                    env.error(where, "package.not.found", nm, "import");
                } else if (rnm.isInner()) {
                    env.error(where, "class.and.package", rnm.getTopName());
                }
                resolvedPackages.addElement(new IdentifierToken(where, nm));
            }
            catch (IOException ee) {
                env.error(where, "io.exception", "import");
            }
        }
        this.packages = resolvedPackages;
        e = this.singles.elements();
        block6: while (e.hasMoreElements()) {
            Identifier f2;
            Identifier f1;
            Identifier snm;
            Identifier className;
            t = e.nextElement();
            nm = t.getName();
            where = t.getWhere();
            Identifier pkg = nm.getQualifier();
            if (!env.classExists((nm = env.resolvePackageQualifiedName(nm)).getTopName())) {
                env.error(where, "class.not.found", nm, "import");
            }
            if ((className = this.classes.get(snm = nm.getFlatName().getName())) != null && !(f1 = Identifier.lookup(className.getQualifier(), className.getFlatName())).equals(f2 = Identifier.lookup(nm.getQualifier(), nm.getFlatName()))) {
                env.error(where, "ambig.class", nm, className);
            }
            this.classes.put(snm, nm);
            try {
                ClassDefinition def;
                ClassDeclaration decl = env.getClassDeclaration(nm);
                Identifier importedPackage = def.getName().getQualifier();
                for (def = decl.getClassDefinitionNoCheck(env); def != null; def = def.getOuterClass()) {
                    if (!def.isPrivate() && (def.isPublic() || importedPackage.equals(this.currentPackage))) continue;
                    env.error(where, "cant.access.class", def);
                    continue block6;
                }
            }
            catch (AmbiguousClass ee) {
                env.error(where, "ambig.class", ee.name1, ee.name2);
            }
            catch (ClassNotFound ee) {
                env.error(where, "class.not.found", ee.name, "import");
            }
        }
        this.checked = 1;
    }

    public synchronized Identifier resolve(Environment env, Identifier nm) throws ClassNotFound {
        Identifier className;
        env.dtEnter("Imports.resolve: " + nm);
        if (nm.hasAmbigPrefix()) {
            nm = nm.removeAmbigPrefix();
        }
        if (nm.isQualified()) {
            env.dtExit("Imports.resolve: QUALIFIED " + nm);
            return nm;
        }
        if (this.checked <= 0) {
            this.checked = 0;
            this.resolve(env);
        }
        if ((className = this.classes.get(nm)) != null) {
            env.dtExit("Imports.resolve: PREVIOUSLY IMPORTED " + nm);
            return className;
        }
        Identifier id = Identifier.lookup(this.currentPackage, nm);
        if (Imports.importable(id, env)) {
            className = id;
        } else {
            Enumeration<IdentifierToken> e = this.packages.elements();
            while (e.hasMoreElements()) {
                IdentifierToken t = e.nextElement();
                id = Identifier.lookup(t.getName(), nm);
                if (!Imports.importable(id, env)) continue;
                if (className == null) {
                    className = id;
                    continue;
                }
                env.dtExit("Imports.resolve: AMBIGUOUS " + nm);
                throw new AmbiguousClass(className, id);
            }
        }
        if (className == null) {
            env.dtExit("Imports.resolve: NOT FOUND " + nm);
            throw new ClassNotFound(nm);
        }
        this.classes.put(nm, className);
        env.dtExit("Imports.resolve: FIRST IMPORT " + nm);
        return className;
    }

    public static boolean importable(Identifier id, Environment env) {
        if (!id.isInner()) {
            return env.classExists(id);
        }
        if (!env.classExists(id.getTopName())) {
            return false;
        }
        try {
            ClassDeclaration decl = env.getClassDeclaration(id.getTopName());
            ClassDefinition c = decl.getClassDefinitionNoCheck(env);
            return c.innerClassExists(id.getFlatName().getTail());
        }
        catch (ClassNotFound ee) {
            return false;
        }
    }

    public synchronized Identifier forceResolve(Environment env, Identifier nm) {
        if (nm.isQualified()) {
            return nm;
        }
        Identifier className = this.classes.get(nm);
        if (className != null) {
            return className;
        }
        className = Identifier.lookup(this.currentPackage, nm);
        this.classes.put(nm, className);
        return className;
    }

    public synchronized void addClass(IdentifierToken t) {
        this.singles.addElement(t);
    }

    public void addClass(Identifier nm) throws AmbiguousClass {
        this.addClass(new IdentifierToken(nm));
    }

    public synchronized void addPackage(IdentifierToken t) {
        Identifier name = t.getName();
        if (name == this.currentPackage) {
            return;
        }
        int size = this.packages.size();
        for (int i = 0; i < size; ++i) {
            if (name != this.packages.elementAt(i).getName()) continue;
            return;
        }
        this.packages.addElement(t);
    }

    public void addPackage(Identifier id) {
        this.addPackage(new IdentifierToken(id));
    }

    public synchronized void setCurrentPackage(IdentifierToken t) {
        this.currentPackage = t.getName();
        this.currentPackageWhere = t.getWhere();
    }

    public synchronized void setCurrentPackage(Identifier id) {
        this.currentPackage = id;
    }

    public Identifier getCurrentPackage() {
        return this.currentPackage;
    }

    public List<IdentifierToken> getImportedPackages() {
        return Collections.unmodifiableList(this.packages);
    }

    public List<IdentifierToken> getImportedClasses() {
        return Collections.unmodifiableList(this.singles);
    }

    public Environment newEnvironment(Environment env) {
        return new ImportEnvironment(env, this);
    }
}

