/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.java;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassPathEntry;

final class ZipClassPathEntry
extends ClassPathEntry {
    private final ZipFile zip;

    ZipClassPathEntry(ZipFile zip) {
        this.zip = zip;
    }

    @Override
    void close() throws IOException {
        this.zip.close();
    }

    @Override
    ClassFile getFile(String name, String subdir, String basename, boolean isDirectory) {
        String newname = name.replace(File.separatorChar, '/');
        ZipEntry entry = this.zip.getEntry(newname);
        return entry != null ? ClassFile.newClassFile(this.zip, entry) : null;
    }

    @Override
    void fillFiles(String pkg, String ext, Hashtable<String, ClassFile> files) {
        Enumeration<? extends ZipEntry> e = this.zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String name = entry.getName();
            if (!(name = name.replace('/', File.separatorChar)).startsWith(pkg) || !name.endsWith(ext)) continue;
            files.put(name, ClassFile.newClassFile(this.zip, entry));
        }
    }
}

