/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import sun.tools.asm.Assembler;
import sun.tools.java.Environment;
import sun.tools.java.Type;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.FieldExpression;
import sun.tools.tree.FieldUpdater;
import sun.tools.tree.TypeExpression;
import sun.tools.tree.UnaryExpression;
import sun.tools.tree.Vset;

public class ArrayAccessExpression
extends UnaryExpression {
    Expression index;

    public ArrayAccessExpression(long where, Expression right, Expression index) {
        super(48, where, Type.tError, right);
        this.index = index;
    }

    @Override
    public Vset checkValue(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        vset = this.right.checkValue(env, ctx, vset, exp);
        if (this.index == null) {
            env.error(this.where, "array.index.required");
            return vset;
        }
        vset = this.index.checkValue(env, ctx, vset, exp);
        this.index = this.convert(env, ctx, Type.tInt, this.index);
        if (!this.right.type.isType(9)) {
            if (!this.right.type.isType(13)) {
                env.error(this.where, "not.array", this.right.type);
            }
            return vset;
        }
        this.type = this.right.type.getElementType();
        return vset;
    }

    @Override
    public Vset checkAmbigName(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp, UnaryExpression loc) {
        if (this.index == null) {
            vset = this.right.checkAmbigName(env, ctx, vset, exp, this);
            if (this.right.type == Type.tPackage) {
                FieldExpression.reportFailedPackagePrefix(env, this.right);
                return vset;
            }
            if (this.right instanceof TypeExpression) {
                Type atype = Type.tArray(this.right.type);
                loc.right = new TypeExpression(this.where, atype);
                return vset;
            }
            env.error(this.where, "array.index.required");
            return vset;
        }
        return super.checkAmbigName(env, ctx, vset, exp, loc);
    }

    @Override
    public Vset checkLHS(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        return this.checkValue(env, ctx, vset, exp);
    }

    @Override
    public Vset checkAssignOp(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp, Expression outside) {
        return this.checkValue(env, ctx, vset, exp);
    }

    @Override
    public FieldUpdater getAssigner(Environment env, Context ctx) {
        return null;
    }

    @Override
    public FieldUpdater getUpdater(Environment env, Context ctx) {
        return null;
    }

    @Override
    Type toType(Environment env, Context ctx) {
        return this.toType(env, this.right.toType(env, ctx));
    }

    Type toType(Environment env, Type t) {
        if (this.index != null) {
            env.error(this.index.where, "array.dim.in.type");
        }
        return Type.tArray(t);
    }

    @Override
    public Expression inline(Environment env, Context ctx) {
        this.right = this.right.inlineValue(env, ctx);
        this.index = this.index.inlineValue(env, ctx);
        return this;
    }

    @Override
    public Expression inlineValue(Environment env, Context ctx) {
        this.right = this.right.inlineValue(env, ctx);
        this.index = this.index.inlineValue(env, ctx);
        return this;
    }

    @Override
    public Expression inlineLHS(Environment env, Context ctx) {
        return this.inlineValue(env, ctx);
    }

    @Override
    public Expression copyInline(Context ctx) {
        ArrayAccessExpression e = (ArrayAccessExpression)this.clone();
        e.right = this.right.copyInline(ctx);
        e.index = this.index == null ? null : this.index.copyInline(ctx);
        return e;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        return 1 + this.right.costInline(thresh, env, ctx) + this.index.costInline(thresh, env, ctx);
    }

    @Override
    int codeLValue(Environment env, Context ctx, Assembler asm) {
        this.right.codeValue(env, ctx, asm);
        this.index.codeValue(env, ctx, asm);
        return 2;
    }

    @Override
    void codeLoad(Environment env, Context ctx, Assembler asm) {
        switch (this.type.getTypeCode()) {
            case 0: 
            case 1: {
                asm.add(this.where, 51);
                break;
            }
            case 2: {
                asm.add(this.where, 52);
                break;
            }
            case 3: {
                asm.add(this.where, 53);
                break;
            }
            default: {
                asm.add(this.where, 46 + this.type.getTypeCodeOffset());
            }
        }
    }

    @Override
    void codeStore(Environment env, Context ctx, Assembler asm) {
        switch (this.type.getTypeCode()) {
            case 0: 
            case 1: {
                asm.add(this.where, 84);
                break;
            }
            case 2: {
                asm.add(this.where, 85);
                break;
            }
            case 3: {
                asm.add(this.where, 86);
                break;
            }
            default: {
                asm.add(this.where, 79 + this.type.getTypeCodeOffset());
            }
        }
    }

    @Override
    public void codeValue(Environment env, Context ctx, Assembler asm) {
        this.codeLValue(env, ctx, asm);
        this.codeLoad(env, ctx, asm);
    }

    @Override
    public void print(PrintStream out) {
        out.print("(" + opNames[this.op] + " ");
        this.right.print(out);
        out.print(" ");
        if (this.index != null) {
            this.index.print(out);
        } else {
            out.print("<empty>");
        }
        out.print(")");
    }
}

