/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import sun.tools.java.AmbiguousMember;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.MemberDefinition;
import sun.tools.tree.CheckContext;
import sun.tools.tree.ContextEnvironment;
import sun.tools.tree.Expression;
import sun.tools.tree.FieldExpression;
import sun.tools.tree.IdentifierExpression;
import sun.tools.tree.InlineMethodExpression;
import sun.tools.tree.InlineNewInstanceExpression;
import sun.tools.tree.LocalMember;
import sun.tools.tree.Node;
import sun.tools.tree.Statement;
import sun.tools.tree.ThisExpression;
import sun.tools.tree.UplevelReference;
import sun.tools.tree.Vset;

public class Context
implements Constants {
    Context prev;
    Node node;
    int varNumber;
    LocalMember locals;
    LocalMember classes;
    MemberDefinition field;
    int scopeNumber;
    int frameNumber;

    public Context(Context ctx, MemberDefinition field) {
        this.field = field;
        if (ctx == null) {
            this.frameNumber = 1;
            this.scopeNumber = 2;
            this.varNumber = 0;
        } else {
            this.prev = ctx;
            this.locals = ctx.locals;
            this.classes = ctx.classes;
            if (field != null && (field.isVariable() || field.isInitializer())) {
                this.frameNumber = ctx.frameNumber;
                this.scopeNumber = ctx.scopeNumber + 1;
            } else {
                this.frameNumber = ctx.scopeNumber + 1;
                this.scopeNumber = this.frameNumber + 1;
            }
            this.varNumber = ctx.varNumber;
        }
    }

    public Context(Context ctx, ClassDefinition c) {
        this(ctx, (MemberDefinition)null);
    }

    Context(Context ctx, Node node) {
        if (ctx == null) {
            this.frameNumber = 1;
            this.scopeNumber = 2;
            this.varNumber = 0;
        } else {
            this.prev = ctx;
            this.locals = ctx.locals;
            this.classes = ctx.classes;
            this.varNumber = ctx.varNumber;
            this.field = ctx.field;
            this.frameNumber = ctx.frameNumber;
            this.scopeNumber = ctx.scopeNumber + 1;
            this.node = node;
        }
    }

    public Context(Context ctx) {
        this(ctx, (Node)null);
    }

    public int declare(Environment env, LocalMember local) {
        local.scopeNumber = this.scopeNumber;
        if (this.field == null && idThis.equals(local.getName())) {
            ++local.scopeNumber;
        }
        if (local.isInnerClass()) {
            local.prev = this.classes;
            this.classes = local;
            return 0;
        }
        local.prev = this.locals;
        this.locals = local;
        local.number = this.varNumber;
        this.varNumber += local.getType().stackSize();
        return local.number;
    }

    public LocalMember getLocalField(Identifier name) {
        LocalMember f = this.locals;
        while (f != null) {
            if (name.equals(f.getName())) {
                return f;
            }
            f = f.prev;
        }
        return null;
    }

    public int getScopeNumber(ClassDefinition c) {
        Context ctx = this;
        while (ctx != null) {
            if (ctx.field != null && ctx.field.getClassDefinition() == c) {
                return ctx.frameNumber;
            }
            ctx = ctx.prev;
        }
        return -1;
    }

    private MemberDefinition getFieldCommon(Environment env, Identifier name, boolean apparentOnly) throws AmbiguousMember, ClassNotFound {
        ClassDefinition thisClass;
        LocalMember lf = this.getLocalField(name);
        int ls = lf == null ? -2 : lf.scopeNumber;
        for (ClassDefinition c = thisClass = this.field.getClassDefinition(); c != null; c = c.getOuterClass()) {
            MemberDefinition f = c.getVariable(env, name, thisClass);
            if (f == null || this.getScopeNumber(c) <= ls || apparentOnly && f.getClassDefinition() != c) continue;
            return f;
        }
        return lf;
    }

    public int declareFieldNumber(MemberDefinition field) {
        return this.declare(null, new LocalMember(field));
    }

    public int getFieldNumber(MemberDefinition field) {
        LocalMember f = this.locals;
        while (f != null) {
            if (f.getMember() == field) {
                return f.number;
            }
            f = f.prev;
        }
        return -1;
    }

    public MemberDefinition getElement(int number) {
        LocalMember f = this.locals;
        while (f != null) {
            if (f.number == number) {
                MemberDefinition field = f.getMember();
                return field != null ? field : f;
            }
            f = f.prev;
        }
        return null;
    }

    public LocalMember getLocalClass(Identifier name) {
        LocalMember f = this.classes;
        while (f != null) {
            if (name.equals(f.getName())) {
                return f;
            }
            f = f.prev;
        }
        return null;
    }

    private MemberDefinition getClassCommon(Environment env, Identifier name, boolean apparentOnly) throws ClassNotFound {
        LocalMember lf = this.getLocalClass(name);
        int ls = lf == null ? -2 : lf.scopeNumber;
        for (ClassDefinition c = this.field.getClassDefinition(); c != null; c = c.getOuterClass()) {
            MemberDefinition f = c.getInnerClass(env, name);
            if (f == null || this.getScopeNumber(c) <= ls || apparentOnly && f.getClassDefinition() != c) continue;
            return f;
        }
        return lf;
    }

    public final MemberDefinition getField(Environment env, Identifier name) throws AmbiguousMember, ClassNotFound {
        return this.getFieldCommon(env, name, false);
    }

    public final MemberDefinition getApparentField(Environment env, Identifier name) throws AmbiguousMember, ClassNotFound {
        return this.getFieldCommon(env, name, true);
    }

    public boolean isInScope(LocalMember field) {
        LocalMember f = this.locals;
        while (f != null) {
            if (field == f) {
                return true;
            }
            f = f.prev;
        }
        return false;
    }

    public UplevelReference noteReference(Environment env, LocalMember target) {
        int targetScopeNumber = !this.isInScope(target) ? -1 : target.scopeNumber;
        UplevelReference res = null;
        int currentFrameNumber = -1;
        Context refctx = this;
        while (refctx != null) {
            if (currentFrameNumber != refctx.frameNumber) {
                currentFrameNumber = refctx.frameNumber;
                if (targetScopeNumber >= currentFrameNumber) break;
                ClassDefinition refc = refctx.field.getClassDefinition();
                UplevelReference r = refc.getReference(target);
                r.noteReference(env, refctx);
                if (res == null) {
                    res = r;
                }
            }
            refctx = refctx.prev;
        }
        return res;
    }

    public Expression makeReference(Environment env, LocalMember target) {
        UplevelReference r = this.noteReference(env, target);
        if (r != null) {
            return r.makeLocalReference(env, this);
        }
        if (idThis.equals(target.getName())) {
            return new ThisExpression(0L, target);
        }
        return new IdentifierExpression(0L, target);
    }

    public Expression findOuterLink(Environment env, long where, MemberDefinition f) {
        ClassDefinition reqc;
        ClassDefinition fc = f.getClassDefinition();
        ClassDefinition classDefinition = f.isStatic() ? null : (!f.isConstructor() ? fc : (reqc = fc.isTopLevel() ? null : fc.getOuterClass()));
        if (reqc == null) {
            return null;
        }
        return this.findOuterLink(env, where, reqc, f, false);
    }

    private static boolean match(Environment env, ClassDefinition thisc, ClassDefinition reqc) {
        try {
            return thisc == reqc || reqc.implementedBy(env, thisc.getClassDeclaration());
        }
        catch (ClassNotFound ee) {
            return false;
        }
    }

    public Expression findOuterLink(Environment env, long where, ClassDefinition reqc, MemberDefinition f, boolean needExactMatch) {
        if (this.field.isStatic()) {
            if (f == null) {
                Identifier nm = reqc.getName().getFlatName().getName();
                env.error(where, "undef.var", Identifier.lookup(nm, idThis));
            } else if (f.isConstructor()) {
                env.error(where, "no.outer.arg", reqc, f.getClassDeclaration());
            } else if (f.isMethod()) {
                env.error(where, "no.static.meth.access", f, f.getClassDeclaration());
            } else {
                env.error(where, "no.static.field.access", f.getName(), f.getClassDeclaration());
            }
            ThisExpression e = new ThisExpression(where, this);
            e.type = reqc.getType();
            return e;
        }
        LocalMember lp = this.locals;
        Expression thise = null;
        LocalMember root = null;
        ClassDefinition thisc = null;
        ClassDefinition conCls = null;
        if (this.field.isConstructor()) {
            conCls = this.field.getClassDefinition();
        }
        if (!this.field.isMethod()) {
            thisc = this.field.getClassDefinition();
            thise = new ThisExpression(where, this);
        }
        while (true) {
            if (thise == null) {
                while (lp != null && !idThis.equals(lp.getName())) {
                    lp = lp.prev;
                }
                if (lp == null) break;
                thise = new ThisExpression(where, lp);
                thisc = lp.getClassDefinition();
                root = lp;
                lp = lp.prev;
            }
            if (thisc == reqc || !needExactMatch && Context.match(env, thisc, reqc)) break;
            MemberDefinition outerMember = thisc.findOuterMember();
            if (outerMember == null) {
                thise = null;
                continue;
            }
            ClassDefinition prevc = thisc;
            thisc = prevc.getOuterClass();
            if (prevc == conCls) {
                Identifier nm = outerMember.getName();
                IdentifierExpression arg = new IdentifierExpression(where, nm);
                arg.bind(env, this);
                thise = arg;
                continue;
            }
            thise = new FieldExpression(where, thise, outerMember);
        }
        if (thise != null) {
            return thise;
        }
        if (f == null) {
            Identifier nm = reqc.getName().getFlatName().getName();
            env.error(where, "undef.var", Identifier.lookup(nm, idThis));
        } else if (f.isConstructor()) {
            env.error(where, "no.outer.arg", reqc, f.getClassDefinition());
        } else {
            env.error(where, "no.static.field.access", f, this.field);
        }
        ThisExpression e = new ThisExpression(where, this);
        e.type = reqc.getType();
        return e;
    }

    public static boolean outerLinkExists(Environment env, ClassDefinition reqc, ClassDefinition thisc) {
        while (!Context.match(env, thisc, reqc)) {
            if (thisc.isTopLevel()) {
                return false;
            }
            thisc = thisc.getOuterClass();
        }
        return true;
    }

    public ClassDefinition findScope(Environment env, ClassDefinition reqc) {
        ClassDefinition thisc;
        for (thisc = this.field.getClassDefinition(); thisc != null && !Context.match(env, thisc, reqc); thisc = thisc.getOuterClass()) {
        }
        return thisc;
    }

    Identifier resolveName(Environment env, Identifier name) {
        if (name.isQualified()) {
            Identifier rhead = this.resolveName(env, name.getHead());
            if (rhead.hasAmbigPrefix()) {
                return rhead;
            }
            if (!env.classExists(rhead)) {
                return env.resolvePackageQualifiedName(name);
            }
            try {
                return env.getClassDefinition(rhead).resolveInnerClass(env, name.getTail());
            }
            catch (ClassNotFound ee) {
                return Identifier.lookupInner(rhead, name.getTail());
            }
        }
        try {
            MemberDefinition f = this.getClassCommon(env, name, false);
            if (f != null) {
                return f.getInnerClass().getName();
            }
        }
        catch (ClassNotFound classNotFound) {
            // empty catch block
        }
        return env.resolveName(name);
    }

    public Identifier getApparentClassName(Environment env, Identifier name) {
        if (name.isQualified()) {
            Identifier rhead = this.getApparentClassName(env, name.getHead());
            return rhead == null ? idNull : Identifier.lookup(rhead, name.getTail());
        }
        try {
            MemberDefinition f = this.getClassCommon(env, name, true);
            if (f != null) {
                return f.getInnerClass().getName();
            }
        }
        catch (ClassNotFound ee) {
            // empty catch block
        }
        Identifier topnm = this.field.getClassDefinition().getTopClass().getName();
        if (topnm.getName().equals(name)) {
            return topnm;
        }
        return idNull;
    }

    public void checkBackBranch(Environment env, Statement loop, Vset vsEntry, Vset vsBack) {
        LocalMember f = this.locals;
        while (f != null) {
            if (f.isBlankFinal() && vsEntry.testVarUnassigned(f.number) && !vsBack.testVarUnassigned(f.number)) {
                env.error(loop.where, "assign.to.blank.final.in.loop", f.getName());
            }
            f = f.prev;
        }
    }

    public boolean canReach(Environment env, MemberDefinition f) {
        return this.field.canReach(env, f);
    }

    public Context getLabelContext(Identifier lbl) {
        Context ctx = this;
        while (ctx != null) {
            if (ctx.node != null && ctx.node instanceof Statement && ((Statement)ctx.node).hasLabel(lbl)) {
                return ctx;
            }
            ctx = ctx.prev;
        }
        return null;
    }

    public Context getBreakContext(Identifier lbl) {
        if (lbl != null) {
            return this.getLabelContext(lbl);
        }
        Context ctx = this;
        while (ctx != null) {
            if (ctx.node != null) {
                switch (ctx.node.op) {
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: {
                        return ctx;
                    }
                }
            }
            ctx = ctx.prev;
        }
        return null;
    }

    public Context getContinueContext(Identifier lbl) {
        if (lbl != null) {
            return this.getLabelContext(lbl);
        }
        Context ctx = this;
        while (ctx != null) {
            if (ctx.node != null) {
                switch (ctx.node.op) {
                    case 92: 
                    case 93: 
                    case 94: {
                        return ctx;
                    }
                }
            }
            ctx = ctx.prev;
        }
        return null;
    }

    public CheckContext getReturnContext() {
        Context ctx = this;
        while (ctx != null) {
            if (ctx.node != null && ctx.node.op == 47) {
                return (CheckContext)ctx;
            }
            ctx = ctx.prev;
        }
        return null;
    }

    public CheckContext getTryExitContext() {
        Context ctx = this;
        while (ctx != null && ctx.node != null && ctx.node.op != 47) {
            if (ctx.node.op == 101) {
                return (CheckContext)ctx;
            }
            ctx = ctx.prev;
        }
        return null;
    }

    Context getInlineContext() {
        Context ctx = this;
        while (ctx != null) {
            if (ctx.node != null) {
                switch (ctx.node.op) {
                    case 150: 
                    case 151: {
                        return ctx;
                    }
                }
            }
            ctx = ctx.prev;
        }
        return null;
    }

    Context getInlineMemberContext(MemberDefinition field) {
        Context ctx = this;
        while (ctx != null) {
            if (ctx.node != null) {
                switch (ctx.node.op) {
                    case 150: {
                        if (!((InlineMethodExpression)ctx.node).field.equals(field)) break;
                        return ctx;
                    }
                    case 151: {
                        if (!((InlineNewInstanceExpression)ctx.node).field.equals(field)) break;
                        return ctx;
                    }
                }
            }
            ctx = ctx.prev;
        }
        return null;
    }

    public final Vset removeAdditionalVars(Vset vset) {
        return vset.removeAdditionalVars(this.varNumber);
    }

    public final int getVarNumber() {
        return this.varNumber;
    }

    public int getThisNumber() {
        LocalMember thisf = this.getLocalField(idThis);
        if (thisf != null && thisf.getClassDefinition() == this.field.getClassDefinition()) {
            return thisf.number;
        }
        return this.varNumber;
    }

    public final MemberDefinition getField() {
        return this.field;
    }

    public static Environment newEnvironment(Environment env, Context ctx) {
        return new ContextEnvironment(env, ctx);
    }
}

